/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Functionality routines for pane mktb
   >>>> 
   >>>>  Private: 
   >>>>         mktb_createtb
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "craftsman.h"

#define NUM_TB_ARGS	5

/*-- structure which holds information about one arg for kgentb --*/
typedef struct _gentb_arg
{
   char *   field;       /*-- what the field is       --*/
   char **  selection;   /*-- pointer into gui struct --*/
   int      mandatory;   /*-- TRUE if it is mandatory --*/
   int      attribute;   /*-- attribute identifier    --*/
} GenTbArg;

AttributeSelection create_args[NUM_TB_ARGS] =
{
   {"Toolbox name", NULL, NULL, -1},
   {"Toolbox path", NULL, NULL, -1},
   {"Toolbox title", NULL, NULL, KCMS_TB_TITLE},
   {"Author's email address", NULL, NULL, KCMS_TB_AUTHOR_EMAIL},
   {"Author's name", NULL, NULL, KCMS_TB_AUTHOR}
};

/*-----------------------------------------------------------
| Routine Name:	mktb_createtb
| 
| Purpose:	Do routine which is called when
|		pane action button createtb is used
| 
| Input:	mktb_info - ptr to PaneInfo struct for mktb pane
| 
| Output:	None
| Written By:	Neil Bowers
| Date:		Sep 18, 1993
------------------------------------------------------------*/
/* ARGSUSED */
void
mktb_createtb(
   newtb_mktb * mktb_info)
{
   int      i;
   kobject  toolbox;
   char     cwd[KLENGTH];
   char     tbpath[KLENGTH];


   create_args[0].selvalue = &gui_info->newtb->mktb->tbname;
   create_args[1].selvalue = &gui_info->newtb->mktb->tbpath;
   create_args[2].selvalue = &gui_info->newtb->mktb->tbtitle;
   create_args[3].selvalue = &gui_info->newtb->mktb->email;
   create_args[4].selvalue = &gui_info->newtb->mktb->name;

   create_args[0].selection = &gui_info->newtb->mktb->tbname_struct;
   create_args[1].selection = &gui_info->newtb->mktb->tbpath_struct;
   create_args[2].selection = &gui_info->newtb->mktb->tbtitle_struct;
   create_args[3].selection = &gui_info->newtb->mktb->email_struct;
   create_args[4].selection = &gui_info->newtb->mktb->name_struct;

   if (*create_args[0].selvalue == NULL)
   {
      kerror(NULL, "Create Toolbox",
	     "You must provide the %s for the new toolbox.",
	     create_args[0].field);
      return;
   }

   if (*create_args[1].selvalue == NULL && kgetcwd(cwd, KLENGTH) != NULL)
   {
      ksprintf(tbpath, "%s/%s", cwd, *create_args[0].selvalue);
      if (!kprompt(KFORCE, NULL, NULL, 0,
		   "Operation: create toolbox\n\n"
		   "\tToolbox: %s\n\n"
		   "You did not specify a path for the toolbox.\n"
		   "A toolbox must have a path.\n\n"
		   "Do you want to go ahead and create the "
		   "toolbox in the current directory?\n\n"
		   "The path would be %s",
		   *create_args[0].selvalue, tbpath))
	 return;
      xvf_set_attribute(*create_args[1].selection, XVF_STRING_VAL, tbpath);
      kfree(*create_args[1].selvalue);
      *create_args[1].selvalue = kstrdup(tbpath);
   }

   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, TRUE);
   xvw_format_attribute(xvoNotifier, XVW_NOTIFYWINDOW_MESSAGE,
			"Creating new toolbox '%s'.",
			*create_args[0].selvalue);

   toolbox = kcms_create_toolbox(*create_args[0].selvalue,
				 *create_args[1].selvalue);
   if (toolbox != NULL)
   {
      for (i = 0; i < NUM_TB_ARGS; i++)
	 if (create_args[i].attribute != -1
	     && *create_args[i].selvalue)
	    kcms_set_attribute(
				 toolbox, create_args[i].attribute,
				 *create_args[i].selvalue);
      kcms_set_attribute(toolbox, KCMS_TB_STATUS,
			 gui_info->newtb->mktb->tbstatus_val - 1);

      update_tblist();
      select_toolbox(toolbox);

      /*-- clear selections for toolbox attributes --*/
      for (i = 0; i < 4; i++)
      {
	 xvf_set_attribute(*create_args[i].selection,
			   XVF_STRING_VAL, NULL);
         kfree(*create_args[1].selvalue);
         *create_args[1].selvalue = NULL;
      }
   }
   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
}
