/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane flags
   >>>> 
   >>>>  Private: 
   >>>> 	flags_flags_apply
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"

/*-----------------------------------------------------------
| Routine Name:	flags_flags_apply - callback function for flags Apply button
| 
| Purpose:	This function is invoked when the user hits the
|		"Apply Changes" button on the "Flags" pane of the toolbox
|		attributes subform.  If any changes have been made to the
|		attribute selections, then the changes are saved to the
|		toolbox database.
| 
| Input:	flags_info - ptr to PaneInfo struct for flags pane
| 
| Written By:	Neil Bowers
| Date:		14-aug-94
------------------------------------------------------------*/
void
flags_flags_apply(
   tbattrs_flags *flags_info)
{
   int      status;
   int      newstatus;


   if (cmsToolbox == NULL)
   {
      kerror(NULL, "flags_flags_apply()", "You have not selected a toolbox.");
      return;
   }

   kcms_get_attribute(cmsToolbox, KCMS_TB_STATUS, &status);
   newstatus = flags_info->tbstatus_val - 1;
   if (status != newstatus)
   {
      if (kcms_set_attribute(cmsToolbox, KCMS_TB_STATUS, newstatus))
	 kcms_sync(cmsToolbox);
   }
}
