 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane copyright
   >>>> 
   >>>>  Private: 
   >>>> 	copyright_copyright_apply
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"

/*-----------------------------------------------------------
| Routine Name: copyright_copyright_apply
| 
| Purpose:	This function is invoked when the user hits the
|		"Apply Changes" button on the copyright pane of
|		the "Toolbox Attributes" subform.
| 
| Input:	copyright_info - ptr to PaneInfo struct for copyright pane
| 
| Output:	None
| Written By:	Neil Bowers
| Date:		20-aug-94
------------------------------------------------------------*/
/* ARGSUSED */
void
copyright_copyright_apply(
   tbattrs_copyright *copyright_info)
{
   kstring  attrval;


   if (cmsToolbox == NULL)
   {
      kerror(NULL, "copyright_copyright_apply()",
	     "You have not selected a toolbox in which to modify the "
	     "copyright(s)");
      return;
   }

   /*-- update the short copyright attribute if it has changed --------*/
   if (kcms_get_attribute(cmsToolbox, KCMS_TB_COPYRIGHT_SHORT, &attrval)
       && kstrcmp(copyright_info->short_copyright, attrval) != 0)
   {
      kcms_set_attribute(cmsToolbox, KCMS_TB_COPYRIGHT_SHORT,
			 copyright_info->short_copyright);
   }

   /*-- update the long copyright attribute if it has changed ---------*/
   if (kcms_get_attribute(cmsToolbox, KCMS_TB_COPYRIGHT_LONG, &attrval)
       && kstrcmp(copyright_info->long_copyright, attrval) != 0)
   {
      kcms_set_attribute(cmsToolbox, KCMS_TB_COPYRIGHT_LONG,
			 copyright_info->long_copyright);
   }
}


