/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Functionality routines for pane rename_pane
   >>>> 
   >>>>  Private: 
   >>>>         move_pane_move
   >>>>         move_pane_move_from
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "composer.h"

static void rename_file_object PROTO((kobject, char *));

/*-----------------------------------------------------------
| Routine Name:	rename_pane_rename
| 
| Purpose:	Do routine which is called when
|		pane action button rename is used
| 
| Input:	move_pane_info - ptr to PaneInfo struct for rename_pane pane
| 
| Written By:	Neil Bowers
| Date:		26-may-93
------------------------------------------------------------*/
void
rename_pane_rename(
   renamefile_rename_pane * rename_pane_info)
{
   rename_file_object(cur_fileobj, rename_pane_info->rename_to);
}

/*-----------------------------------------------------------
| Routine Name:	rename_pane_rename_to
| 
| Purpose:	Do routine which is called when
|		string selection rename_to is used
| 
| Input:	rename_pane_info - ptr to PaneInfo struct for rename_pane pane
| 
| Written By:	Neil Bowers
| Date:		8-dec-93
------------------------------------------------------------*/
void
rename_pane_rename_to(
   renamefile_rename_pane * rename_pane_info)
{
   rename_file_object(cur_fileobj, rename_pane_info->rename_to);
}

/*-----------------------------------------------------------
| Routine Name:	rename_file_object - rename file object
|
| Purpose:	This function is used to rename a file object.
|
| Input:	fileobj	-	the file object
|		newname	-	new name (full path) of file object
|
| Written By:	Neil Bowers
| Date:		8-dec-93
------------------------------------------------------------*/
static void
rename_file_object(
   kobject  fobj,
   kstring  newname)
{
   kstring  routine           = "Rename File Object";
   kstring  new;
   kstring  oldname;
   kstring  oldpath;
   char     dir[KLENGTH];
   char     newpath[KLENGTH];


   if (newname == NULL || (new = kstring_cleanup(newname, NULL)) == NULL)
   {
      kerror(NULL, routine, "How about you specify a new filename?");
      return;
   }

   if (!kcms_get_attribute(fobj, KCMS_FOBJ_FULLNAME, &oldpath) ||
       !kcms_get_attribute(fobj, KCMS_FOBJ_BASENAME, &oldname))
      return;

   /*-- prompt the user for confirmation --*/
   if (!kprompt(KSTANDARD, "Yes", "No", FALSE,
		"Operation: rename file\n\n"
		"\tToolbox:  %s\n"
		"\tObject:   %s\n\n"
		"\tOld Name: %s\n"
		"\tNew Name: %s\n\n"
		"Do you want to continue with rename?",
		strToolbox, strObject, oldname, newname))
      return;

   if (kdirname(oldpath, dir) == NULL)
   {
      kerror(NULL, routine, "Can't get path to file object.");
      return;
   }
   ksprintf(newpath, "%s/%s", dir, new);

#ifdef UNDEFINED
   xvf_set_attribute(gui_info->utilities_struct,
		     XVF_DISPLAY_SUBFORM, 0);
#endif

   xvw_format_attribute(xvoNotifier, XVW_NOTIFYWINDOW_MESSAGE,
			"Renaming file \"%s\" to \"%s\".", oldname, newname);
   xvw_format_attribute(xvoNotifier, XVW_NOTIFYWINDOW_MESSAGE,
			"Renaming file \"%s\" to \"%s\".", oldname, newname);
   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, TRUE);

   if (kcms_set_attribute(fobj, KCMS_FOBJ_FULLNAME, newpath))
      reload_object();

   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
   kfree(new);
}
