/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Functionality routines for pane logging
   >>>> 
   >>>>  Private: 
   >>>>         logging_clear
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "composer.h"


/*-----------------------------------------------------------
| Routine Name:	logging_clear() - clear the output log
| 
| Purpose:	This is the callback function for the "Clear Log"
|		button on the Output Log subform.
| 
| Written By:	Neil Bowers
| Date:		4-dec-93
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_clear(
   logform_logging * logging_info)
{
   xvw_set_attribute(xvoLog, XVW_TEXTDISPLAY_CLEARTEXT, TRUE);
}

/*-----------------------------------------------------------
| Routine Name:	logging_gen_code
| 
| Purpose:	Do routine which is called when
|		pane action button gen_code is used
| 
| Input:	logging_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		25-may-93
------------------------------------------------------------*/
void
logging_gen_code(
   logform_logging  *logging_info)
{
   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_LABEL, "Generating Code");
   xvw_set_attributes(xvoNotifier,
		      XVW_NOTIFYWINDOW_LABEL, "Generating Code",
		      XVW_NOTIFYWINDOW_VISIBLE, TRUE,
		      XVW_NOTIFYWINDOW_MESSAGE, ". . .",
		      NULL);

   log_append("-------------- Generating Code --------------\n");

   if (logging_info->force)
      kcms_set_bit(cmsObject, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE);

   kgen_generate_object(cmsObject);

   xvw_set_attributes(xvoNotifier,
		      XVW_NOTIFYWINDOW_VISIBLE, FALSE,
		      XVW_NOTIFYWINDOW_LABEL, "Please Wait",
		      NULL);

   kcms_sync(cmsObject);

   log_append("------------- End of Generation -------------\n");
}

/*-----------------------------------------------------------
| Routine Name:	logging_compile
| 
| Purpose:	Do routine which is called when
|		pane action button compile is used
| 
| Input:	logging_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		25-may-93
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_compile(
   logform_logging  *logging_info)
{
   (void)log_command("make", FALSE);
}

/*-----------------------------------------------------------
| Routine Name:	logging_make_clean
| 
| Purpose:	Do routine which is called when
|		master action button make_clean is used
| 
| Input:	logging_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		30-oct-93
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_make_clean(
   logform_logging  *logging_info)
{
   (void)log_command("make clean", FALSE);
}


/*-----------------------------------------------------------
| Routine Name:	logging_make_install
| 
| Purpose:	Do routine which is called when
|		master action button make_install is used
| 
| Input:	logging_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		23-jun-93
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_make_install(
   logform_logging  *logging_info)
{
   (void)log_command("make install", FALSE);
}

/*-----------------------------------------------------------
| Routine Name:	logging_make_Makefile
| 
| Purpose:	Do routine which is called when
|		master action button make_Makefile is used
| 
| Input:	logging_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		23-jun-93
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_make_Makefile(
   logform_logging  *logging_info)
{
   (void)log_command("kgenmake", FALSE);
}

/*-----------------------------------------------------------
| Routine Name:	logging_make_Imakefile
| 
| Purpose:	action routine for "make Imakefile" on make menu.
| 
| Input:	logging_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		30-oct-93
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_make_Imakefile(
   logform_logging  *logging_info)
{
   char buffer[KLENGTH];


   (void)ksprintf(buffer, "kgenimake -tb %s -oname %s",
		  clui_info->tb_string, clui_info->oname_string);
   (void)log_command(buffer, FALSE);
}

/*-----------------------------------------------------------
| Routine Name:	logging_make_target
| 
| Purpose:	Do routine which is called when
|		master action button make_target is used
| 
| Input:	logging_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		4-dec-93
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_make_target(
   logform_logging  *logging_info)
{
   log_command("make", FALSE);
}

/*-----------------------------------------------------------
| Routine Name:	logging_lib_make_target
| 
| Purpose:	Do routine which is called when
|		master action button lib_make_target is used
| 
| Input:	logging_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		4-dec-93
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_lib_make_target(
   logform_logging  *logging_info)
{
   log_command("make", TRUE);
}


/*-----------------------------------------------------------
| Routine Name:	logging_lib_make_clean
| 
| Purpose:	Do routine which is called when
|		master action button lib_make_clean is used
| 
| Input:	logging_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		4-dec-93
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_lib_make_clean(
   logform_logging  *logging_info)
{
   log_command("make clean", TRUE);
}


/*-----------------------------------------------------------
| Routine Name:	logging_lib_make_install
| 
| Purpose:	Do routine which is called when
|		master action button lib_make_install is used
| 
| Input:	logging_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		4-dec-93
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_lib_make_install(
   logform_logging  *logging_info)
{
   log_command("make install", TRUE);
}


/*-----------------------------------------------------------
| Routine Name:	logging_lib_make_Makefile
| 
| Purpose:	Do routine which is called when
|		master action button lib_make_Makefile is used
| 
| Input:	logging_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		4-dec-93
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_lib_make_Makefile(
   logform_logging  *logging_info)
{
   log_command("kgenmake", TRUE);
}


/*-----------------------------------------------------------
| Routine Name:	logging_lib_make_Imakefile
| 
| Purpose:	Do routine which is called when
|		master action button lib_make_Imakefile is used
| 
| Input:	logging_info - ptr to FormInfo struct for composer
| 
| Written By:	Neil Bowers
| Date:		4-dec-93
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_lib_make_Imakefile(
   logform_logging  *logging_info)
{
   log_command("make Imakefile", TRUE);
}

/*-----------------------------------------------------------
| Routine Name: logging_make_klint
| 
| Purpose:	Do routine which is called when
|		master action button make_klint is used
| 
| Input:	logging_info - ptr to PaneInfo struct for logging pane
| 
| Written By:	Neil Bowers
| Date:		10-mar-1995
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_make_klint(
   logform_logging *logging_info)
{
   char   cmdbuffer[KLENGTH];

   ksprintf(cmdbuffer, "klint -tb %s -oname %s",
	    clui_info->tb_string, clui_info->oname_string);
   log_command(cmdbuffer, FALSE);
}


/*-----------------------------------------------------------
| Routine Name:	logging_lib_make_klint - run klint on associated library
| 
| Purpose:	Do routine which is called when
|		master action button lib_make_klint is used
| 
| Input:	logging_info - ptr to PaneInfo struct for logging pane
| 
| Written By:	Neil Bowers
| Date:		10-mar-1995
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_lib_make_klint(
   logform_logging *logging_info)
{
   char   cmdbuffer[KLENGTH];

   ksprintf(cmdbuffer, "klint -tb %s -oname %s",
	    clui_info->tb_string, strLibrary);
   log_command(cmdbuffer, TRUE);
}

/*-----------------------------------------------------------
| Routine Name:	logging_grep - search for specified text in object
| 
| Purpose:	This function is called when the user enters some text
|		in the "Grep:" text selection, and hits return.
|		We then spawn grep, with the output going to the log/console.
| 
| Input:	logging_info - ptr to PaneInfo struct for logging pane
| 
| Written By:	Neil Bowers
| Date:		13-mar-1995
------------------------------------------------------------*/
/* ARGSUSED */
void
logging_grep(
   logform_logging *logging_info)
{
   composer_grep_object(cmsObject, logging_info->grep);
}

