 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane finder
   >>>> 
   >>>>  Private: 
   >>>> 	finder_open
   >>>> 	finder_expr
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "cantata.h"

/*-----------------------------------------------------------
| 
|  Routine Name: finder_open
| 
|       Purpose: Do routine which is called when
|                  pane action button open is used
| 
|         Input: finder_info - ptr to PaneInfo struct for finder pane
| 
|        Output: None
|    Written By: 
|          Date: Feb 24, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void finder_open(
     find_finder *finder_info)
{
	xvw_set_attribute(finder, XVW_FINDERLIST_OPEN, TRUE);
}

/*-----------------------------------------------------------
| 
|  Routine Name: finder_expr
| 
|       Purpose: Do routine which is called when
|                  string selection expr is used
| 
|         Input: finder_info - ptr to PaneInfo struct for finder pane
| 
|        Output: None
|    Written By: 
|          Date: Jul 03, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void finder_expr(
     find_finder *finder_info)
{
	xvw_set_attribute(finder, XVW_FINDERLIST_EXPRESSION, finder_info->expr);
}
