 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Routines For Creating and Initializing Cantata
   >>>> 
   >>>>  Private: 
   >>>>			initialize_cantata()
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "cantata.h"

/*-----------------------------------------------------------
|
|  Routine Name: initialize_cantata
|
|       Purpose: Initialize cantata
|       Returns:
|    Written By: Mark Young
|          Date: Sep 10, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void initialize_cantata(void)
{
	int	   width, height;
	kobject    toolbox, program, obj; 
	char	   *filename = NULL, *tbname, *oname;
	xvobject   date, commandbar, parent, annotations,
		   help, quit, license, temp;


	kannounce(NULL, "main", "Creating Status Label");
	status = xvw_create_labelstr(gui_info->workspace, "Status");
	xvw_set_attributes(status,
		XVW_BORDER_WIDTH,    2,
		XVW_TACK_EDGE,       KMANAGER_TACK_HORIZ,
		XVW_FORCE_REDISPLAY, TRUE,
		NULL);
	/*
	 *  Reset the Quit/Help/License buttons so that they are left of the
	 *  workspace.
	 */
	kannounce(NULL, "main", "Adjusting Cantata GUI");
	quit = xvf_get_xvobject(gui_info->quit_struct, XVF_BACKPLANE, TRUE);
	help = xvf_get_xvobject(gui_info->help1_struct, XVF_BACKPLANE, TRUE);
	license = xvf_get_xvobject(gui_info->license_struct,XVF_BACKPLANE,TRUE);
	xvw_set_attribute(quit, XVW_LEFT_OF, NULL);
	xvw_set_attribute(help, XVW_LEFT_OF, quit);
	xvw_set_attribute(license, XVW_LEFT_OF, help);

	/*
	 *  Set the announce handler to "update_status"
	 */
	kset_announcehandler(update_status);
	xvw_set_attributes(gui_info->workspace,
	        XVW_TACK_EDGE, KMANAGER_TACK_RIGHT|KMANAGER_TACK_BOTTOM,
		XVW_VERT_DIST,  0,
		NULL);

	/*
	 *  Create the menu area in which we will allow the user to play 
	 */
	if (clui_info->tbmenus_logic)
	{
	   kannounce(NULL, "main", "Creating Toolbox Menus");
	   tbmenu = xvw_create_toolboxmenu(gui_info->workspace, "ToolboxMenu");
	   xvw_set_attributes(tbmenu,
		XVW_BORDER_WIDTH, 0,
	        XVW_BELOW,     NULL,
	        XVW_TACK_EDGE, KMANAGER_TACK_HORIZ,
		NULL);
	}
	else tbmenu = NULL;

	/*
	 *  Make the status line below the toolbox menu
	 */
	xvw_set_attribute(status, XVW_BELOW, tbmenu);

	/*
	 *  Create the date object in the upper-left hand corner
	 */
	kannounce(NULL, "main", "Creating Workspace Date");
	date = xvw_create_date(gui_info->workspace, "Date");
	xvw_set_attributes(date,
		XVW_BELOW,   tbmenu,
		XVW_LEFT_OF, NULL,
		NULL);

	/*
	 *  Create the date object in the upper-left hand corner
	 */
	kannounce(NULL, "main", "Creating Workspace CommandBar");
	commandbar = xvw_create_commandbar(gui_info->workspace, "CommandBar");
	xvw_set_attributes(commandbar,
		XVW_BELOW,     date,
		XVW_LEFT_OF,   NULL,
		XVW_TACK_EDGE, KMANAGER_TACK_HORIZ,
		NULL);


	/*
	 *  Create the position indicator
	 */
	kannounce(NULL, "main", "Creating Workspace Position Indicator");
	position = xvw_create_labelstr(gui_info->workspace, "Position");
	xvw_set_attributes(position,
		XVW_VERT_DIST,  0,
		XVW_HORIZ_DIST, 0,
		XVW_LABEL,	" ",
		XVW_ABOVE,     NULL,
		XVW_LEFT_OF,   NULL,
		NULL);

	/*
	 *  Create the position indicator
	 */
	kannounce(NULL, "main", "Creating Active Workspace Indicator");
	active = xvw_create_labelstr(gui_info->workspace, "Active");
	xvw_set_attributes(active,
		XVW_VERT_DIST,  0,
		XVW_HORIZ_DIST, 0,
		XVW_LABEL,	"Active Workspace:  MainWorkspace",
		XVW_ABOVE,      NULL,
		XVW_RIGHT_OF,   NULL,
		NULL);

	/*
	 *  Create the main workspace which is used to build our visual program
	 */
	kannounce(NULL, "main", "Creating Main Workspace");
	workspace = xvw_create_workspace(gui_info->workspace, "MainWorkspace");
	main_workspace = workspace;
	xvw_set_attributes(workspace,
		XVW_VERT_DIST, 2,
		XVW_BELOW,  commandbar,
		XVW_ABOVE,  position,
		XVW_CANVAS_WIDTH,  3000,
		XVW_CANVAS_WIDTH,  3000,
		XVW_CANVAS_HEIGHT, 3000,
	        XVW_TACK_EDGE, KMANAGER_TACK_ALL,
		NULL);
	xvw_set_attribute(commandbar,  XVW_COMMANDBAR_WORKSPACE,  workspace);
	xvw_add_callback(workspace, XVW_WORKSPACE_ACTIVE_CALLBACK,
			change_workspace, active);
	temp = NULL;
	xvw_get_attribute(workspace, XVW_VP_PLANE_OBJECT, &temp);
	xvw_add_event(temp, PointerMotionMask, update_position, position);


	/*
	 *  Create the accelerated toolbox list
	 */
	kannounce(NULL, "main", "Creating Routines List");
	parent = gui_info->list->routines->rlists;
	xvw_get_attributes(parent, XVW_WIDTH, &width, XVW_HEIGHT, &height,NULL);
	routines = xvw_create_toolboxlist(parent, "ToolboxList");
        xvw_set_attributes(routines,
		XVW_TACK_EDGE, KMANAGER_TACK_ALL,
		XVW_WIDTH,  width,
		XVW_HEIGHT, height,
		NULL);
        xvw_set_attribute(parent, XVW_BORDER_WIDTH, 0);

	xvw_set_attribute(parent, XVW_TACK_EDGE,
		KMANAGER_TACK_RIGHT | KMANAGER_TACK_BOTTOM);
	xvw_set_attribute(xvw_parent(parent), XVW_TACK_EDGE,
		KMANAGER_TACK_RIGHT | KMANAGER_TACK_BOTTOM);

	/*
	 *  Create the accelerated finder list
	 */
	kannounce(NULL, "main", "Creating Finder List");
	parent = gui_info->find->finder->flist;
	finder = xvw_create_finderlist(parent, "FinderList");
        xvw_set_attribute(finder, XVW_TACK_EDGE, KMANAGER_TACK_ALL);
        xvw_set_attribute(parent, XVW_BORDER_WIDTH, 0);

	temp = xvf_get_xvobject(gui_info->find->finder->expr_struct,
		XVF_BACKPLANE, TRUE);
	xvw_set_attributes(parent,
		XVW_TACK_EDGE, KMANAGER_TACK_RIGHT | KMANAGER_TACK_BOTTOM,
		XVW_ABOVE, temp,
		NULL);
	xvw_set_attribute(xvw_parent(parent), XVW_TACK_EDGE,
		KMANAGER_TACK_RIGHT | KMANAGER_TACK_BOTTOM);

	/*
	 *  Create the console for cantata
	 */
	kannounce(NULL, "main", "Creating Console");
	parent = gui_info->consoleform->console->wksp;
	console = xvw_create_console(parent, "Console");
        xvw_set_attribute(console, XVW_TACK_EDGE, KMANAGER_TACK_ALL);
	xvw_set_attribute(parent, XVW_BORDER_WIDTH, 0);

	xvw_set_attribute(parent, XVW_TACK_EDGE,
		KMANAGER_TACK_RIGHT | KMANAGER_TACK_BOTTOM);
	xvw_set_attribute(xvw_parent(parent), XVW_TACK_EDGE,
		KMANAGER_TACK_RIGHT | KMANAGER_TACK_BOTTOM);

	/*
	 *  Create the annotations menu
	 */
	kannounce(NULL, "main", "Creating Annotations Menu");
	parent = gui_info->annotationform->annotations->wksp;
	annotations = xvw_create_annotatemenu(parent, "AnnotationMenu");
	xvw_set_attributes(annotations,
		XVW_ANNOTATEMENU_WORKSPACE, workspace,
		XVW_TACK_EDGE, KMANAGER_TACK_ALL,
		NULL);
	xvw_set_attribute(parent, XVW_BORDER_WIDTH, 0);

	xvw_set_attribute(parent, XVW_TACK_EDGE,
		KMANAGER_TACK_RIGHT | KMANAGER_TACK_BOTTOM);
	xvw_set_attribute(xvw_parent(parent), XVW_TACK_EDGE,
		KMANAGER_TACK_RIGHT | KMANAGER_TACK_BOTTOM);

	
	/*
	 *  Add extra call to initialize the create_program subform
	 */
        xvf_add_extra_call(gui_info->create_struct,
                initialize_create_program, (kaddr) gui_info->create->program,
                XVF_CALL_FIRST);
 
	/*
	 *  Add associated callbacks to our user interface to either create
	 *  glyphs or update the announce status
	 */
	if (tbmenu != NULL)
	   xvw_add_callback(tbmenu, XVW_TOOLBOXMENU_CREATE, create_glyph, NULL);

	xvw_add_callback(finder, XVW_FINDERLIST_CREATE,  create_glyph, NULL);
	xvw_add_callback(routines, XVW_TOOLBOXLIST_CREATE, create_glyph, NULL);
	xvw_add_callback(finder, XVW_FINDERLIST_SELECT,  status_callback, NULL);
	xvw_add_callback(routines,XVW_TOOLBOXLIST_SELECT, status_callback,NULL);

	/*
	 *  Restore file if one is supplied on the command line
	 */
	if (clui_info->wksp_file)
	{
	   filename = clui_info->wksp_file;
	}
	else if (clui_info->tb_string && clui_info->oname_string)
	{
	   tbname = clui_info->tb_string;
	   oname  = clui_info->oname_string;
	   if ((toolbox = kcms_open_toolbox(tbname)) == NULL ||
	       (program = kcms_open_cmobj(toolbox, oname)) == NULL)
	   {
	      (void) kerror(NULL, "main()", "Cannot open %s '%s'.",
			(!toolbox) ? "toolbox" : "program",
			(!toolbox) ? clui_info->tb_string :
			clui_info->oname_string);
	      kexit(KEXIT_FAILURE);
	   }

	   if (kcms_get_attribute(program, KCMS_CMOBJ_WORKSPACE, &obj) && obj)
	      kcms_get_attribute(obj, KCMS_PATH, &filename);

	   kcms_close(program); kcms_close(toolbox);
	}

	if (filename != NULL)
	{
	   restore_workspace(filename);
	   xvf_set_attribute(gui_info->dir->files->restore_workspace_struct,
			XVF_FILE_NAME, filename);
	}
	kannounce(NULL, "main", "Ready... ");

	/*
	 * update "Variables" subform
	 */
	update_varscope_displaylist(NULL);
}
