 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       	Common xvobject Creation and Utilities
   >>>>
   >>>>   Private:
   >>>>    Static:
   >>>>    Public:
   >>>>           xvw_create_transient_shell()
   >>>>           xvw_create_application_shell()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#include "internals.h"

int xvw_toplevel_count = 0;


/*-----------------------------------------------------------
|
|  Routine Name: delete_toplevel - delete window callback
|
|       Purpose: This routine destroys the shell since a delete
|		 window has been called.  When a "WM_DELETE_WINDOW"
|		 is detected then we simply destroy the toplevel
|		 rather than default, which is to exit the program.
|		 If the programmer wishes to do something else then
|		 they can use xvw_add_protocol().
|
|         Input: object      - the shell object to be deleted
|                client_data - unused
|                call_data   - unused
|        Output:
|       Returns:
|
|    Written By: Mark Young
|          Date: Jun 28, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void delete_toplevel(
   xvobject toplevel,
   kaddr  client_data,
   kaddr  call_data)
{
	xvw_remove_protocol(toplevel, "WM_DELETE_WINDOW",delete_toplevel,NULL);
	xvw_unmap(toplevel);
	xvw_destroy(toplevel);
}

/*-----------------------------------------------------------
|
|  Routine Name: set_position - set the toplevel position..
|
|       Purpose: This sets the toplevel position.
|
|         Input: toplevel - the toplevel object
|                attribute - the attribute (shell xpositon or shell yposition)
|                calldata - the value to be set
|
|    Written By: Mark Young
|          Date: Jul 12, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int set_position(
    xvobject toplevel,
    char     *attribute,
    kaddr    calldata)
{
	int      i;
	Position x, y;
	Arg	 args[10];
	char	 temp[KLENGTH];
	Widget   widget = xvw_widget(toplevel);

        i = 0;
        XtSetArg(args[i], XtNx, &x);           i++;
        XtSetArg(args[i], XtNy, &y);           i++;
	XtGetValues(widget, args, (Cardinal) i);

	if (kstrcmp(attribute, XVW_SHELL_X) == 0)
	   x = *((int *) calldata);
	else if (kstrcmp(attribute, XVW_SHELL_Y) == 0)
	   y = *((int *) calldata);
	else
	   return(FALSE);

	/*
	 *  Set it the geometry way to force a position mapping...
	 */
	ksprintf(temp, "%+d%+d", x, y);

        i = 0;
        XtSetArg(args[i], XtNx, x);           i++;
        XtSetArg(args[i], XtNy, y);           i++;
        XtSetArg(args[i], XtNgeometry, kstrdup(temp)); i++;
	XtSetValues(widget, args, (Cardinal) i);
	return(TRUE);
}

/************************************************************
*
*  Routine Name: xvw_create_application_shell() - create an application 
*                                                 shell object
*
*       Purpose: Creates an application shell object to serve as
*                a toplevel for an application; the toplevel serves
*                as a mediating device between the application and
*                the window manager.  This call allows the application 
*                to have several independant windows, which is the case 
*                with xvroutines having multiple subforms.  The routine
*                also supports the creation of toplevels on potentially 
*                different screens, which applies when a Khoros application 
*                distributes its user interface with the concert program.  
*                Both the display and screen are optional arguments;  if 
*                either of these are set to NULL, then the default display 
*                and default screen will be used.
*
*         Input: name    - name for the application shell object
*		 display - the X Display structure; pass NULL to use the
*			   default display
*                screen  - the X Screen structure; pass NULL to use the
*			   default screen
*
*        Output: 
*	Returns: returns the application shell object on success,
*		 NULL on failure
*
*  Restrictions:
*    Written By: Danielle Argiro & Mark Young
*          Date: Apr 9, 1992 9:12
*      Verified: 
*  Side Effects:
* Modifications:
*   Declaration: xvobject xvw_create_application_shell(
*                !   char    *name,
*                !   Display *display,
*                !   Screen  *screen)
*
*******************************************************************/

static xvattribute shell_attributes[] = {
{XVW_SHELL_INPUT,       XtNinput,            XtRBoolean,  NULL},
{XVW_SHELL_TITLE,       XtNtitle,            XtRString,   NULL},
{XVW_SHELL_X,           XtNx,                XtRPosition, NULL},
{XVW_SHELL_Y,           XtNy,                XtRPosition, NULL},
{XVW_SHELL_RESIZE,      XtNallowShellResize, XtRBoolean,  NULL},
{XVW_SHELL_ICON_NAME,   XtNiconName,         XtRString,   NULL},
{XVW_SHELL_ICON_WINDOW, XtNiconWindow,       XtRWindow,   NULL},
{XVW_SHELL_ICON_PIXMAP, XtNiconPixmap,       XtRPixmap,   NULL},
{XVW_SHELL_ICON_PIXMAPFILE, XtNiconPixmap,   XtRFilename, XtRPixmap},
{XVW_SHELL_ICON_MASK, XtNiconMask,       XtRPixmap,   NULL},
{XVW_SHELL_ICON_MASKFILE, XtNiconMask,   XtRFilename, XtRPixmap},
{XVW_SHELL_WIN_GRAVITY, XtNwinGravity,       XtRInt,      NULL},
{XVW_SHELL_INITIAL_STATE, XtNinitialState,   XtRInt,      NULL},
};

xvobject xvw_create_application_shell(
   char    *name,
   Display *display,
   Screen  *screen)
{
        int    i;
        Widget shell;
        Arg    args[MAX_ARGS];
	static  int initialized = FALSE;

	/*
	 *  The screen and display are optional since we have already
	 *  initialized the display.  Therefore if NULL then the defaults
	 *  are used.
	 */
	if (display == NULL) display = xvw_display(NULL);
	if (screen  == NULL) screen  = DefaultScreenOfDisplay(display);

        i = 0;
        XtSetArg(args[i], XtNscreen, screen);           i++;
        XtSetArg(args[i], XtNargc, xvw_ac);             i++;
        XtSetArg(args[i], XtNargv, xvw_av);             i++;
        XtSetArg(args[i], XtNinput, TRUE);              i++;
        XtSetArg(args[i], XtNallowShellResize, TRUE);   i++;
        shell = XtAppCreateShell(name, kprog_get_program(), 
				 applicationShellWidgetClass,
				 display, args, (Cardinal) i);

	/* add toplevel to xvw_toplevels list so that when jp is used,
           that list is searched first */
	xvw_add_toplevel(xvw_object(shell));
	xvw_add_protocol(xvw_object(shell), "WM_DELETE_WINDOW",
			delete_toplevel, NULL);

	if (!initialized)
	{
	   initialized = TRUE;
	   xvw_init_attributes(XtClass(shell), shell_attributes,
			    knumber(shell_attributes), NULL, 0, NULL);
	   xvw_define_attributes(XtClass(shell),
	      XVW_SHELL_X, XtRInt, set_position, NULL,
	      XVW_SHELL_Y, XtRInt, set_position, NULL,
	      NULL);
	}
	xvw_toplevel_count++;
        return(xvw_object(shell));
}


/************************************************************
*
*  Routine Name: xvw_create_transient_shell() - create a transient shell object
*
*       Purpose: Creates an transient shell object to serve as
*                the toplevel for a popup object.  Both the display and 
*                the screen are optional arguments;  if either is set to 
*                NULL, then the default display and default screen are used.
*
*         Input: name    - name for the transient shell object
*                display - the X Display structure; pass NULL to use the
*			   default display
*                screen  - the X Screen structure; pass NULL to use the
*			   default screen
*        Output: 
*	Returns: the transient shell object on success,
*		 NULL on failure
*
*  Restrictions:
*    Written By: Danielle Argiro & Mark Young
*          Date: Apr 9, 1992 9:12
*      Verified: 
*  Side Effects:
* Modifications:
*   Declaration: xvobject xvw_create_transient_shell(
*                !   char    *name,
*                !   Display *display,
*                !   Screen  *screen)
*
*******************************************************************/

xvobject xvw_create_transient_shell(
   char    *name,
   Display *display,
   Screen  *screen)
{
	int	i;
	Widget	shell;
	Arg	args[MAX_ARGS];
	static  int initialized = FALSE;

	/*
	 *  The screen and display are optional since we have already
	 *  initialized the display.  Therefore if NULL then the defaults
	 *  are used.
	 */
	if (display == NULL) display = xvw_display(NULL);
	if (screen  == NULL) screen  = DefaultScreenOfDisplay(display);

	/*
	 * The following kludge is implemented because with Olit, when a 
         * transient shell is created before any application shell has been 
         * created and mapped, (eg, when the first thing to appear is a popup
         * error message) you will get a core dump down in _OlGetScale().
	 */
	if (xvw_toplevel_count < 1)
	{
	    xvw_toplevel_count--;
	    return(xvw_create_application_shell(name, display, screen));
	}

	i = 0;
	XtSetArg(args[i], XtNscreen,       screen);        i++;
	XtSetArg(args[i], XtNinput,        TRUE);          i++;
	XtSetArg(args[i], XtNallowShellResize, TRUE);      i++;
	XtSetArg(args[i], XtNwindowGroup,  xvw_rootwindow(NULL)); i++;
	shell = XtAppCreateShell(name, kprog_get_program(), 
				 transientShellWidgetClass,
				 display, args, (Cardinal) i);

	/* add toplevel to xvw_toplevels list so that when jp is used,
           that list is searched first */
	xvw_add_toplevel(xvw_object(shell));
	xvw_add_protocol(xvw_object(shell), "WM_DELETE_WINDOW",
			delete_toplevel, NULL);

	if (!initialized)
	{
	   xvw_init_attributes(XtClass(shell), shell_attributes,
			    knumber(shell_attributes), NULL, 0, NULL);
	}
	return(xvw_object(shell));
}
