 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Private Resources Routines
   >>>>
   >>>>   Static:
   >>>>  Private:
   >>>>		   xvw_load_resources()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#define XLIB_ILLEGAL_ACCESS
#include "internals.h"


/*--------------------------------------------------------------
|
|  Routine Name: xvw_load_resources
|
|       Purpose: load resources for a specific resource filename..
|         Input: filename - the name of resource file
|		 global_dir - the path to the resource file
|        Output: none
|	Returns: none
|
|          Date: Jun 17, 1993
|    Written By: Mark Young
| Modifications:
|
----------------------------------------------------------------*/

void xvw_load_resources(
   char *path)
{
	Display *display;
	XrmDatabase database;
	char *file, filename[KLENGTH], temp[KLENGTH], dbpath[KLENGTH];


	/*
	 *  Sanity check to make sure we've initialized
	 */
	if ((display = xvw_display(NULL)) == NULL)
	   return;

	if (!kbasename(path, filename))
	    return;

	if ((kfullpath(filename, "~/app-defaults", temp) &&
	     kaccess(temp, R_OK) == 0))
	{
	   kstrcpy(dbpath, temp);
	}
	else if ((file = XtResolvePathname(display, "app-defaults", filename,
			NULL, NULL, NULL, 0, NULL)) != NULL &&
		 kstrcmp(kbasename(file, temp), filename) == 0)
	{
	   kstrcpy(dbpath, file);
	   kfree(file);
	}
	else if (kaccess(path, R_OK) == 0)
	   kfullpath(path, NULL, dbpath);
	else
	   return;

	database = XrmGetFileDatabase(dbpath);
	(void) XrmMergeDatabases(database, &(display->db));
}
