 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>             file name: system.c                       <<<<
   >>>>                                                       <<<<
   >>>>		       Dispatch Routines                      <<<<
   >>>>                                                       <<<<
   >>>>       These routines are used to handle the execution <<<<
   >>>>	 of running processes.				      <<<<
   >>>>                                                       <<<<
   >>>>			xvw_fork()			      <<<<
   >>>>			xvw_system()			      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#include "internals.h"

/*-----------------------------------------------------------
|
|  Routine Name: xvw_fork
|
|       Purpose: forks a child.  The child executes a routine based 
|                on the command, while the parent continues doing 
|                cantata programming stuff.
|
|         Input: command     -
|                routine     - 
|                client_data -
|    Written By: Mark Young
|          Date: Jun 15, 1992
|
------------------------------------------------------------*/

int xvw_fork(
   char        *command,
   kfunc_void  routine,
   kaddr       client_data)
{
	kfile	   *file;
	xvw_signal *entry;

	/*
	 *  Create the process by using kpopen().  The "R" says that we
	 *  want all standard output and standard error message to be
	 *  read thru the transport.
	 */
	if ((file = kpopen(command, "R")) == NULL)
	{
	   kerror("xvforms", "xvw_fork", "Error! Cannot execute the \
following command\n\n'%s'\n\nNo update to any variables will be made.",
			command);
	   return(FALSE);
	}
	entry = xvw_add_handler(routine, client_data, file);
	return(entry->pid);
}

/*-----------------------------------------------------------
|
|  Routine Name: xvw_system
|
|       Purpose: The child executes the routine in foreground based on the
|                command passed in.  Call xvw_fork to execute
|                the routine then wait until the process
|                finishes before returning.
|
|         Input: command 
|       Returns: none
|    Written By: Mark Young
|          Date: Jun 15, 1992 
|
------------------------------------------------------------*/

int xvw_system(
   char *command)
{
	int	pid;

	/*
	 *  Create the process by using kspawn().
	 */
	if ((pid = kspawn(command)) != -1)
	{
	   if (xvw_waitpid(pid, NULL) != -1)
	      return(0);
	}
	else
	{
	   kerror("xvforms", "xvw_system", "Error! Cannot execute the \
following command\n\n'%s'\n\n.", command);
	}
	return(-1);
}
