 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>		Various Utility Routines	              <<<<
   >>>>                                                       <<<<
   >>>>  Private:					      <<<<
   >>>>             Used by the List xvobject:		      <<<<
   >>>>             xvu_get_path_info()                       <<<<
   >>>>             xvu_compose_whole_list()                  <<<<
   >>>>             xvu_compose_single_list()                 <<<<
   >>>>                                                       <<<<
   >>>>             Used by Various Routines:                 <<<<
   >>>>             xvu_figure_width()                        <<<<
   >>>>             xvu_figure_height()                       <<<<
   >>>>             xvu_dummy_icon_cb()                       <<<<
   >>>>             xvu_find_string_width()                   <<<<
   >>>>                                                       <<<<
   >>>>   Static:					      <<<<
   >>>>   Public:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"	

/*------------------------------------------------------------
|
|  Routine Name: xvu_get_path_info()
|
|       Purpose: Goes out to the path provided, and first determines if:
|		    1) the path is to a file
|		    2) the path is to a directory
|		    3) the path is bogus
|	
|		 In case (1), it simply returns the filename, and file_num = 1; 
|		 In case (2), it goes out to the specified directory, 
|		 does a listing, and returns an array of strings that 
|		 are the names of the files in that directory.  
|		 Also returns the number of files in the directory. 
|		 In case (3), it returns NULL for the filename and file_num = 0.
|
|         Input: path - the directory path in which we are interested
|
|        Output: Returns an array of strings with the names of the files in
|		 the directory (if the path is to a directory), the name of
|		 the file (if the path is to a file), or NULL (if the path
|		 is bogus).
|		 dir_type  - one of DIRECTORY_PATH, FILE_PATH, BOGUS_PATH
|		 file_num  - (see above)
|
|    Written By: Danielle Argiro & Mark Young
|          Date: Jul 15, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/

char **xvu_get_path_info(
   char *path,
   int  *dir_type,
   int  *filenum)
{
	int	mode, num1 = 0, num2 = 0;
	char	**filenames, **name1, **name2;
	struct  stat stat_buffer;


	if (stat(path, &stat_buffer) != -1)  
	{
	   /* path specified is a directory */
	   if (S_ISDIR(stat_buffer.st_mode))
	   {
	      *dir_type = XVU_DIRECTORY_PATH;

	      /*
	       *  set the list mode to look for files and directories.
	       */
	      mode = KFILE;
	      name1 = karray_dirlist(path, NULL, ".*\\.hlp$", mode,
				         FALSE, &num1);
	      name2 = karray_dirlist(path, NULL, ".*\\.doc$", mode,
				         FALSE, &num2);
	      filenames = karray_merge(name1, name2, num1, num2, FALSE);
	      *filenum = num1 + num2;
	      kfree(name1); 
	      kfree(name2);
	      if (filenames == NULL)
	      {
		 *dir_type = XVU_BOGUS_PATH;
		 *filenum  = 0;
		 return(NULL);
	      }
	      return(filenames);
	   }
	   /* path specified is a single file */
	   else if (S_ISREG(stat_buffer.st_mode))
	   {
	      filenames = (char **) kcalloc(1,sizeof(char *));
	      filenames[0] = kbasename(path, NULL);
	      *dir_type = XVU_FILE_PATH;
	      *filenum = 1;
	      return(filenames);
	   }
	   else
	   {
	      *dir_type = XVU_BOGUS_PATH;
	      *filenum  = 0;
	      return(NULL);
	   }
	}
        else  
	{
	   /*
	    *  set the list mode to look for files and directories.
	    */
	   mode = KFILE;
	   name1 = karray_dirlist(path, NULL, ".*\\.hlp$", mode,
				         FALSE, &num1);
	   name2 = karray_dirlist(path, NULL, ".*\\.doc$", mode,
				         FALSE, &num2);
	   filenames = karray_merge(name1, name2, num1, num2, FALSE);
	   *filenum = num1 + num2;
	   kfree(name1); 
	   kfree(name2);
	   if (filenames == NULL)
	   {
	      *dir_type = XVU_BOGUS_PATH;
	      *filenum  = 0;
	      return(NULL);
	   }
	   *dir_type = XVU_FILE_PATH;
	   if (*filenum > 1)  *dir_type = XVU_DIRECTORY_PATH;
	   return(filenames);
	}
}


/*------------------------------------------------------------
|
|  Routine Name: xvu_compose_whole_list()
|
|       Purpose: This routine is used to go out to the files indictated,
|		 and create a list out of their contents (which should be
|		 a list of strings).  This routine is used only by 
|		 xvu_create_multlist_object().
|
|         Input: path - the directory path to files which contain the
|			contents for our list
|		 filenames - names of files containing our list entries
|		 filenum - number of files
|
|        Output: Returns a list of strings with the contents of the files in
|		 the directory specified
|
|    Written By: Danielle Argiro & Mark Young
|          Date: Jul 15, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/

int xvu_compose_whole_list(
   char *path,
   char **filenames,
   int  filenum,
   char **list_entries,
   int  *num_entries,
   int  duplicate_entries)
{
	int  i, j, k, offset;
	char *fullpath, temp[KLENGTH];
	kfile *file;

	j = 0;
	for (i = 0; i < filenum; i++)
	{
	    fullpath = kfullpath(filenames[i], path, NULL);
	    if ((file = kfopen(fullpath, "r")) == NULL)
            {
                kfprintf(kstderr, "\nxvu_compose_list: \n");
                kfprintf(kstderr, "Error: unable to open file %s\n", filenames[i]);
                return(FALSE);
            }
	    /*
             * read the contents of the file,
             * into the array of strings which will be our list
             */
            while (!(kfeof(file)))
            {
                list_entries[j] = (char *) kcalloc(1,sizeof(char)*KLENGTH);
                kfgets(temp, KLENGTH, file);
		k = 0;
		list_entries[j][0] = list_entries[j][1] = 
		list_entries[j][2] = ' '; offset = 3;
		if (duplicate_entries) 
		{
		    list_entries[j][3] = list_entries[j][4] = ' '; offset = 5;
		}
		while (temp[k] != '\n')
		{
		   if (temp[k] != '_') list_entries[j][k+offset] = temp[k];
		   k++;
		}
                j++;
            }
	    kfree(fullpath);
	}
	*num_entries = j-1;
	return(TRUE);
}

/*------------------------------------------------------------
|
|  Routine Name: xvu_compose_single_list()
|
|       Purpose: This routine is used to go out to the file indictated,
|		 and create a list out of its contents (which should be
|		 a list of strings). 
|
|         Input: path     - the directory path to files which contain the
|			    contents for our list
|		 filename - names of file containing our list entries
|                duplicate_entries - pass as TRUE if user will be allowed
|                                    to select an entry more than once
|
|        Output: Returns a list of strings with the contents of the files in
|		 the directory specified
|
|                num_entries - returns the number of entries in the list
|
|    Written By: Danielle Argiro & Mark Young
|          Date: Jul 15, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/


#define ListSize 100

char **xvu_compose_single_list(
   char *path,
   char *filename,
   int  *num_entries,
   int  duplicate_entries)
{
	int  j, k, offset;
	char temp[KLENGTH], *fullpath;
	kfile *file;
	char **list_entries;

	list_entries = (char **) kcalloc(1,sizeof(char *) * ListSize);

	j = 0;
	fullpath = kfullpath(filename, path, NULL);
	if ((file = kfopen(fullpath, "r")) == NULL)
        {
            kfprintf(kstderr, "\nxvu_compose_single_list: \n");
            kfprintf(kstderr, "Error: unable to open file %s\n", fullpath);
	    kfree(fullpath);
            return(NULL);
        }
	/*
         * read the contents of the file,
         * into the array of strings which will be our list
         */
        while (!(kfeof(file)))
        {
            list_entries[j] = (char *) kcalloc(1,sizeof(char)*KLENGTH);
            kfgets(temp, KLENGTH, file);
	    k = 0;
	    list_entries[j][0] = list_entries[j][1] = 
	    list_entries[j][2] = ' '; offset = 3;
	    if (duplicate_entries)
	    {
		list_entries[j][3] = list_entries[j][4] = ' '; offset = 5;
	    }
	    while (temp[k] != '\n')
	    {
	        if (temp[k] != '_') list_entries[j][k+offset] = temp[k];
	        k++;
	    }
            j++;
	}
	*num_entries = j-1;
	kfree(fullpath);
	return(list_entries);
}

/*------------------------------------------------------------
|
|  Routine Name: xvu_figure_width()
|
|       Purpose: Figures the minimum width (in characters)
|		 of a text object needed to display the given 
|		 string, based on the string passed in.
|
|         Input: message - the string to be displayed in the text object
|
|        Output: Returns necessary width (in characters) for the text object.
|
|    Written By: Mark Young
|          Date: Oct 23, 1993
| Modifications: 
|
------------------------------------------------------------*/

int xvu_figure_width(
   char *message)
{
	int i, width = 0;

	if (!message)
	   return(width);

	for (i = 0; *message != '\0'; message++)
	{
	   if (*message == '\n')
	   {
	      if (i > width)
	         width = i;

	      i = 0;
	   }
	   else i++;
	}
	return(width);
}


/*------------------------------------------------------------
|
|  Routine Name: xvu_figure_height()
|
|       Purpose: Figures the minimum height (in characters)
|		 of a text object needed to display the given 
|		 string, based on the width passed in (in characters).
|
|         Input: message - the string to be displayed in the text object
|		 width   - width of the text object to be used (in characters)
|
|        Output: Returns necessary height (in characters) for the text object.
|
|    Written By: Danielle Argiro
|          Date: Jul 15, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/

int xvu_figure_height(
   char *message,
   int  width)
{
	int i, j, length, row_size, height = 1;

	if (message == NULL) return (0);

	row_size = 0;
	j = 0;
	length = kstrlen(message);
	if (length == 0) return (0);

	i = 0;
	while (i < length)
	{
	     if (message[i] != '\n') 
	     {
		j = i;
		while ((message[j] != ' ') && (message[j] != '\0'))
		{
	            row_size++;
		    j++;
		}
	     }
	     else row_size = width;

	     if (row_size >= width) 
	     {
		row_size = 0;
	        height++;
	     }
	     i += kmax(1, (j-i));
	}
	return(height);
}


/*------------------------------------------------------------
|
|  Routine Name: xvu_dummy_icon_cb
|
|       Purpose: Dummy routine for when the user attempts
|		 to use the window manager to iconify a pop-up
|		 when they shouldn't.
|
|         Input: toplevel - the toplevel object created by one
|		 of the xvu_create_xxx_routines in the xvutils lib.
|        Output: none
|
|    Written By: Danielle Argiro
|          Date: Jul 15, 1992
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/
/* ARGSUSED */
void xvu_dummy_icon_cb(
   xvobject object,
   kaddr  client_data)
{
	xvobject toplevel = (xvobject) client_data;

	xvw_remove_protocol(toplevel, "WM_CHANGE_STATE",
                            xvu_dummy_icon_cb, toplevel);
	return;
}


/*--------------------------------------------------------------
|
|  Routine Name: xvu_find_string_object()
|
|       Purpose: Checks a string for \n's.  If there are \n's
|                in the string, returns the length of the longest
|                line in the string.  Otherwise, returns the
|                length of the string.
|
|         Input: string - the string to be checked for \ns
|        Output: Length of the longest segment of the string between
|                \n's if it contains carriage returns, the literal
|                length of the string otherwise.
|
|    Written By: Danielle Argiro
|          Date: May 20, 1992
| Modifications: 
|
----------------------------------------------------------------*/

int xvu_find_string_width(
   char *string)
{
     int maxlen = 0, count = 0, i = 0;

     while (string[i] != '\0')
     {
        if (string[i] == '\n')
        {
           if (count > maxlen) maxlen = count;
           count = 0;
        }
        else count++;
        i++;
     }
     if (count > maxlen) maxlen = count;
     return(maxlen);
}
