 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>                 File Browser                          <<<<
   >>>>  Private:                                             <<<<
   >>>>   Static:      xvu_browser_cb()		              <<<<              
   >>>>   Public:      xvu_run_browser()		      <<<<              
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"	

static char browser_filename[KLENGTH];
static int  xvu_browser_done  = FALSE;

/*--------------------------------------------------------------
|
|  Routine Name: xvu_browser_cb()
|
|       Purpose: This callback gets called when the user selects something
|		 from the browser list of aliases or files.
|	  Input: object - the browser object
|		 client_data - not used
|		 call_data   - returns the selection from the list
|        Output: none
|    Written By: Danielle Argiro & Mark Young
|          Date: Dec 13, 1994
| Modifications:
|
--------------------------------------------------------------------*/
/* ARGSUSED */
static void xvu_browser_cb(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	char *filename = *((char **) call_data);

	if (filename != NULL)
	   kstrcpy(browser_filename, filename); 
	else browser_filename[0] = '\0';

	xvu_browser_done = TRUE;
}

/**************************************************************
*
*  Routine Name:  xvu_run_browser - run the Khoros file browser.
*
*       Purpose:  Causes the file browser to pop up with a browser list.  
*
*                 The first element in the list is the "-- aliases --" 
*                 entry with which the user may access the aliases capability 
*                 of the browser.  For more information on the Aliases 
*                 capability, see Chapter 1 of the Khoros User's Manual.  
*
*                 The second element of the list is "../", which is used to 
*                 move to an upper level directory.  The remaining elements of 
*                 the browser list are the contents of the specified directory.
*                 The browser remains displayed until the user selects a
*                 file from the browser, or clicks on "Cancel".
*
*                 The user may select a file from the browser list;  when
*                 this happens, the full path to the file is returned to
*                 the calling routine.
*                 
*                 Alternatively, the user may select a sub-directory to change
*                 to that directory, or "../" to go up in the directory 
*                 structure.
*
*                 A text object at the bottom of the browser allows the
*                 user to type their own filename, or change directories.
*		  If a directory path is typed into the bottom text object
*                 followed by a <cr>, files in the browser list will be 
*                 updated with the contents of the new directory.
*
*	  Input: directory - path to initial directory 
*
*        Output:
*	Returns: The string chosen from the browser by the user, or
*                NULL if the user clicked on "Cancel".
*  Restrictions: 
*    Written By: Mark Young and Danielle Argiro
*          Date: Dec 13, 1994
*      Verified:
*  Side Effects:
* Modifications:
*
**************************************************************/

char *xvu_run_browser(
   char *directory)
{
	xvobject browser;
	char     name[KLENGTH];


	/*
	 *  xvw_create_browser creates the error object pop-up
	 */
	xvw_busy(NULL, TRUE);
	(void) ksprintf(name, "Browser for %s", kprog_get_program());
	if ((browser = xvw_create_browser(NULL, name)) == NULL)
	{
	   xvw_busy(NULL, FALSE);
	   return(NULL);
	}
	xvw_set_attribute(browser, XVW_BROWSER_DIRECTORY, directory);
	xvw_add_callback(browser, XVW_BROWSER_CALLBACK, xvu_browser_cb, NULL);
	xvw_place(xvw_toplevel(browser), NULL);

	/*
	 *  Do the spin until a valid filename is specified... or cancel occurs
	 */
	xvu_browser_done = FALSE;
	while (!xvu_browser_done)
	    xvw_process_event();  

	xvw_busy(NULL, FALSE);
	return(kstring_cleanup(browser_filename, NULL));
}
