 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Canvas Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>> 		Initialize()
   >>>> 		ConstraintInitialize()
   >>>> 		CanvasActions()
   >>>> 		CanvasSelect()
   >>>>   Public:
   >>>>			xvw_create_canvas()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvobjects/CanvasP.h>

#define XK_LATIN1
#include <X11/keysymdef.h>


static void ClassInitialize	 PROTO((void));
static void ConstraintInitialize PROTO((Widget, Widget, ArgList, Cardinal *));
static void Initialize		 PROTO((Widget, Widget, ArgList, Cardinal *));
static int  CanvasActions	 PROTO((xvobject, char *, kaddr));
static void CanvasSelect	 PROTO((xvobject, kaddr, XEvent *));
static void ActionCallback       PROTO((xvobject, kaddr, XEvent *));


/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_CANVAS_RUBBERBAND,		NULL,   XtRInt,  XtRBoolean},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define DEFAULT_GRIDSIZE 15

#define offset(field) XtOffsetOf(XvwCanvasWidgetRec, canvas.field)

static XtResource resources[] = { 
{XVW_CANVAS_RUBBERBAND, NULL, XtRBoolean, sizeof(Boolean),
        offset(rubberband), XtRImmediate, (XtPointer) TRUE},

{XVW_VP_USE_RIGHT, NULL, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XvwViewportWidgetRec, viewport.use_right),
        XtRImmediate, (XtPointer) TRUE},
{XVW_VP_FORCE_HORIZ, NULL, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XvwViewportWidgetRec, viewport.force_horizontal),
        XtRImmediate, (XtPointer) TRUE},
{XVW_VP_FORCE_VERT, NULL, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XvwViewportWidgetRec, viewport.force_vertical),
        XtRImmediate, (XtPointer) TRUE},
{XVW_VP_ALLOW_HORIZ, NULL, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XvwViewportWidgetRec, viewport.allow_horizontal),
        XtRImmediate, (XtPointer) TRUE},
{XVW_VP_ALLOW_VERT, NULL, XtRBoolean, sizeof(Boolean),
	XtOffsetOf(XvwViewportWidgetRec, viewport.allow_vertical),
        XtRImmediate, (XtPointer) TRUE},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Canvas Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwViewportWidgetClassRec)

XvwCanvasWidgetClassRec xvwCanvasWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Canvas",				/* class_name		  */
    sizeof(XvwCanvasWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    NULL,				/* set_values	          */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* geometry_manager	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwCanvasWidgetConstraintsRec),  /* constraint_size	  */
    ConstraintInitialize,		    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine   */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwCanvasWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwCanvasWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwCanvasWidgetClass = (WidgetClass) &xvwCanvasWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef  kwidget
#undef  kwidgetclass

#define kwidget(widget)	     (XvwCanvasWidget) (widget)
#define kwidgetclass(widget) (XvwCanvasWidgetClass) (widget)->core.widget_class


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwCanvasWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|         Input:
|
|        Output:
|       Returns: 
|
|    Written By: Mark Young
|          Date: Oct 19, 1992 9:54
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwCanvasWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/Canvas");

	xvw_define_attributes(xvwCanvasWidgetClass,
		XVW_CANVAS_DUPLICATE,	XtRInt,    CanvasActions,  NULL,
		XVW_CANVAS_UNDO,	XtRInt,    CanvasActions,  NULL,
		XVW_CANVAS_COPY,	XtRInt,    CanvasActions,  NULL,
		XVW_CANVAS_PASTE,	XtRInt,    CanvasActions,  NULL,
		XVW_CANVAS_CUT,		XtRInt,    CanvasActions,  NULL,
		XVW_CANVAS_RAISE,	XtRInt,    CanvasActions,  NULL,
		XVW_CANVAS_LOWER,	XtRInt,    CanvasActions,  NULL,
		XVW_CANVAS_DELETE,	XtRInt,    CanvasActions,  NULL,
		NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial canvas
|                for the canvas widget instance.
|
|         Input: request - not used
|                new     - widget instance after initialization, with
|                          initial canvas
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwCanvasWidget	     xwid  = kwidget(new);
        XvwCanvasWidgetClass class = kwidgetclass(new);
	Widget parent = xvw_widget(xwid->viewport.plane);
        xvobject object = xvw_object(new);


	xwid->canvas.selected = NULL;
	xvw_set_attributes(object,
		XVW_CANVAS_WIDTH,  1000,
		XVW_CANVAS_HEIGHT, 1000,
		NULL);
	xvw_add_event(xwid->viewport.plane, ButtonPressMask, CanvasSelect,
		(kaddr) object);
        xvw_add_action(xwid->viewport.plane, "Ctrl<Key>d", ActionCallback,
                        object, TRUE);
        xvw_add_action(xwid->viewport.plane, "Ctrl<Key>u", ActionCallback,
                        object, TRUE);
        xvw_add_action(xwid->viewport.plane, "Ctrl<Key>x", ActionCallback,
                        object, TRUE);

	xvw_remove_action(xwid->viewport.plane, "Meta<Btn1Down>", 
                      ManagerActionHandler, (kaddr) new);
	xvw_remove_action(xwid->viewport.plane, "Shift<Btn1Down>", 
		      ManagerActionHandler, (kaddr) new);
}

/*-----------------------------------------------------------
|
|  Routine Name: ConstraintInitialize
|
|       Purpose: When a new child of the canvas is created,
|		 tell the child who its parent is. 
|                
|         Input: request  - widget child with requested constraints
|                new      - widget child with actual constraints
|		 args     - not used
|		 num_args - not used
|
|        Output: None
|       Returns: None 
|
|    Written By: Mark Young
|          Date: Nov 26, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ConstraintInitialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwCanvasWidget xwid = kwidget(XtParent(request));
	Widget parent = xvw_widget(xwid->viewport.plane);


	if (xwid->viewport.override == FALSE) 
	{
	   xvw_add_event(xvw_object(new), ButtonPressMask | ButtonReleaseMask |
		ButtonMotionMask, ManagerWidgetHandler, (kaddr) parent);

	   if (XtIsSubclass(new, ManagerWidgetClass))
	   {
	      xvw_remove_action(xvw_object(new), "Meta<Btn1Down>", 
                      ManagerActionHandler, (kaddr) new);
	      xvw_remove_action(xvw_object(new), "Shift<Btn1Down>", 
		      ManagerActionHandler, (kaddr) new);
	   }
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: CanvasActions
|
|       Purpose: SetFormfile is used to set the filename associated
|		 with the attribute.
|
|         Input: object    - the object in which we will be getting the
|			     filename
|		 attribute - the old object to be closed
|		 calldata  - the filename to be set
|
|        Output:
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 21, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int CanvasActions(
   xvobject object,
   char     *attribute,
   kaddr    calldata)
{
	XvwCanvasWidget  xwid = (XvwCanvasWidget) xvw_widget(object);

	int	 i, x, y, num;
	XvwManagerWidget xman;
	xvobject *selections, temp;


	/*
	 *  Get the current selections
	 */
	object = xwid->viewport.plane;
	xman = (XvwManagerWidget) xvw_widget(object);
	num        = xman->manager.numsels;
	selections = xman->manager.objectsels;

	if (kstrcmp(attribute, XVW_CANVAS_DUPLICATE) == 0)
	{
	   for (i = 0; i < num; i++)
	   {
	      temp = xvw_duplicate(selections[i]);
	      xvw_geometry(selections[i], &x, &y, NULL, NULL, NULL);
	      xvw_set_attributes(temp,
			XVW_XPOSITION, x + 10,
			XVW_YPOSITION, y + 10,
			NULL);
	   }
	}
/*
	else if (kstrcmp(attribute, XVW_CANVAS_UNDO) == 0)
	{
	}
	else if (kstrcmp(attribute, XVW_CANVAS_COPY) == 0)
	{
	}
	else if (kstrcmp(attribute, XVW_CANVAS_PASTE) == 0)
	{
	}
	else if (kstrcmp(attribute, XVW_CANVAS_CUT) == 0)
	{
	}
*/
	else if (kstrcmp(attribute, XVW_CANVAS_RAISE) == 0)
	{
	   for (i = 0; i < num; i++)
	       xvw_raise(selections[i]);
	}
	else if (kstrcmp(attribute, XVW_CANVAS_LOWER) == 0)
	{
	   for (i = 0; i < num; i++)
	       xvw_lower(selections[i]);
	}
	else if (kstrcmp(attribute, XVW_CANVAS_DELETE) == 0)
	{
	   for (i = num-1; i >= 0; i--)
	       xvw_destroy(selections[i]);
	}
	else
	{
	   kerror(XVOBJECTS,"CanvasActions","invalid attribute %s", attribute);
	   return(FALSE);
	}
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: CanvasSelect
|
|       Purpose: CanvasSelect is used to select/unselect the object being
|		 manipulated
|
|         Input: object    - the object in which we will be getting the
|			     filename
|		 attribute - the old object to be closed
|		 calldata  - the filename to be set
|
|        Output:
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Dec 13, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void CanvasSelect(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
	Widget widget = xvw_widget(object);
	xvobject parent = (xvobject) client_data;

	int	 x, y;
	unsigned int w, h;


	if (event->type != ButtonPress)
	   return;

	xvw_set_attribute(parent, XVW_CANVAS_UNSELECTALL, TRUE);
	if (xvw_getextent(object, &x, &y, &w, &h) == TRUE)
	   ManagerAddExtentSelections(widget, x, y, (int) x+w, (int) y+h);
}

/*-----------------------------------------------------------
|
|  Routine Name: ActionCallback - action handler for quick bindings to the
|                                different canvas attributes.
|
|       Purpose: This routine is used to perform quick key bindings on the
|                canvas.
|
|         Input: object - object in which the object was invoked
|                client_data - the canvas widget
|                XEvent      - the event (action) which is desired
|
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Nov 26, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ActionCallback(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
	xvobject canvas = (xvobject) client_data;

	XKeyEvent *xkey;
	KeySym    keysym;
	char      temp[KLENGTH];

	/*
	 *  Make sure only KeyPress events get registered...
	 */
	if (event->type != KeyPress)
	   return;

	xkey = (XKeyEvent *) &(event->xkey);
	(void) XLookupString(xkey, temp, KLENGTH, &keysym, NULL);
	switch (keysym)
	{
	   case XK_d:
	   case XK_D:
		xvw_set_attribute(canvas, XVW_CANVAS_DUPLICATE, TRUE);
		break;

	   case XK_u:
	   case XK_U:
		xvw_set_attribute(canvas, XVW_CANVAS_UNDO, TRUE);
		break;

	   case XK_x:
	   case XK_X:
		xvw_set_attribute(canvas, XVW_CANVAS_DELETE, TRUE);
		break;

	   default:
		kerror(XVOBJECTS, "ActionCallback",  "Internal Error.  \
Unknown action associated with internal key bindings for keysym '%d'", keysym);
		break;
	}
}


/************************************************************
*
*  Routine Name: xvw_create_canvas - create a canvas object
*
*       Purpose:  The canvas object is essentially a manager object
*		  combined with a virtual window size.  The virtual
*		  window is a viewport where a canvas may contain a
*		  vertical scrollbar, a horizontal scrollbar, or both.
*		  In general, it is used to confine large visual displays
*		  to a predefined area.  The canvas object may have one
*		  or many children; usually, the object(s) created inside
*		  the canvas will take up more space than the canvas
*		  itself, so that the scrollbar(s) of the canvas may be
*		  used to view the entire display.  The canvas object is
*		  similar to the viewport object, except the canvas
*		  provides an area for displaying graphical objects,
*		  while the viewport object is typically only used to
*		  contain GUI objects.  The canvas object allows the
*		  application to set a default width and height, while
*		  the viewport will shrink its area to the minimum size
*		  required to lay out all its children.
*
*		  The canvas object also offers a global clipboard, which
*		  acts as a common cut and paste area for use by all
*		  canvas objects that may be displayed at the same time,
*		  providing an easy method for the user to transfer
*		  objects from one canvas to another.
*
*         Input: parent - parent of the canvas object; NULL will cause
*			  a default toplevel to be created automatically
*                name   - name with which to reference canvas object
*        Output:
*       Returns: The canvas object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Jan 14, 1993
*      Verified:
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_canvas(
   xvobject parent,
   char     *name)
{
	xvobject canvas;


	canvas = xvw_create(parent, FALSE, TRUE, name, CanvasWidgetClass);
	return(canvas);
}
