 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	General Utilities
   >>>> 
   >>>>  Private: 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvlang/GlyphP.h>


/*-----------------------------------------------------------
|
|  Routine Name: CreateExternalConnectors - creates external connectors
|
|       Purpose: This routine creates the external connectors would within
|		 procedures to represent connections to the outside world.
|
|         Input: procedure - the procedure in which the connection should be
|			     made
|		 glyph     - the glyph in which connection is being made for
|		 kformstruct - the form structure the connection is being
|			       made for.
|    Written By: Mark Young
|          Date: Mar 07, 1995
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void CreateExternalConnector(
  xvobject procedure,
  xvobject glyph,
  kform_struct *kformstruct)
{
	XvwGlyphWidget xglyph;
	int       i, x, y, xpos, ypos;
	xvobject  iconnector, oconnector, workspace, parent;


	/*
	 *  Yack! Hack!  This is where we do the twisty doodle.  We need to
	 *  connect the port/control within workspace such that there is
	 *  a visual indicator that this is an external connection.
	 */

	/*
	 *  Create the input or output port that we will be connecting to...
	 */
	xglyph = (XvwGlyphWidget) xvw_widget(glyph);
	workspace = xglyph->glyph.connection_parent;
	xvw_translate_coords(workspace, 0, 0, &x, &y);

	for (i = 0; i < xglyph->glyph.osize; i++)
	{
	   if (xglyph->glyph.osels[i] != kformstruct)
	      continue;

	   oconnector = xglyph->glyph.oports[i];
	   xvw_translate_coords(oconnector, -x, -y, &xpos, &ypos);
	   parent = xvw_create_manager(workspace, "Port Parent");
	   xvw_set_attributes(parent,
		XVW_XPOSITION, xpos + 100,
		XVW_YPOSITION, ypos,
		XVW_RESIZABLE, FALSE,
		NULL);
	   iconnector = xvw_create_port(parent, "Input Port");
	   xvw_set_attributes(iconnector,
		XVW_PORT_SELECTION, xglyph->glyph.osels[i],
		XVW_PORT_TYPE, KPORT_TYPE_INPUT,
		XVW_PORT_CONNECTION_PARENT, xglyph->glyph.connection_parent,
		XVW_PORT_MODIFIED, TRUE,
		NULL);
	   xvw_set_attribute(glyph, XVW_GROUP_ADD, parent);
	   PortCreateConnection(iconnector, oconnector);
	   break;
	}

	for (i = 0; i < xglyph->glyph.isize; i++)
	{
	   if (xglyph->glyph.isels[i] != kformstruct)
	      continue;

	   iconnector = xglyph->glyph.iports[i];
	   xvw_translate_coords(iconnector, -x, -y, &xpos, &ypos);
	   parent = xvw_create_manager(workspace, "Port Parent");
	   xvw_set_attributes(parent,
		XVW_XPOSITION, xpos - 100,
		XVW_YPOSITION, ypos,
		XVW_RESIZABLE, FALSE,
		NULL);
	   oconnector = xvw_create_port(parent, "Output Port");
	   xvw_set_attributes(oconnector,
		XVW_PORT_SELECTION, xglyph->glyph.isels[i],
		XVW_PORT_TYPE, KPORT_TYPE_OUTPUT,
		XVW_PORT_CONNECTION_PARENT, xglyph->glyph.connection_parent,
		NULL);
	   xvw_set_attribute(glyph, XVW_GROUP_ADD, parent);
	   PortCreateConnection(iconnector, oconnector);
	   xvw_set_attribute(oconnector, XVW_PORT_DAV, TRUE);
	   break;
	}
	GlyphUpdateForm(xvw_widget(procedure));
}

/*-----------------------------------------------------------
|
|  Routine Name: xvw_copy_selection
|
|       Purpose: Creates a new GUI selection on the workspace GUI
|                modelled after the selection the glyph that it comes from.
|
|         Input: form        - pointer to the workspace GUI form tree
|                procedure   - procedure associated with the form (if any)
|                glyph       - glyph associated with the selection (if any)
|                kformstruct - GUI selection from glyph to copy
|                varname     - the new variable name of the selection
|			       (if NULL then make sure that the name is
|				unique).
|        Output:
|       Returns: 
|    Written By: Mark Young & Danielle Argiro
|          Date: July 05, 1994
| Modifications:
|
------------------------------------------------------------*/
/*ARGSUSED*/
void xvw_copy_selection(
   kform        *form,
   xvobject	procedure,
   xvobject	glyph,
   kform_struct *kformstruct,
   char		*varname)
{
	kcontrol   *pane;
	float      y, height;
	char       *line, *variable, temp[KLENGTH];
	int        i, optional, optsel, duplicate, type;
	kselection *old_selection, *toggleptr, *selptr;
	kselection *new_selection, *toggle_member;


	/* shouldn't be in this routine w/ anything other than a sel ptr */
	if (kformstruct->type != KSELECTION)
	    return;

	/* get UIS line defining selection */
	old_selection = kformstruct->Selptr;
	line = old_selection->line;

	/*
	 * assumption: that workspace GUI has a single pane on a single
	 * subform
	 */
	if (!(kvf_check_for_single_pane(form, "xvw_copy_selection")))
	    return;

	/*
	 *  Need to make sure that the kformstruct has not already been
	 *  exported to form.  We only want the selection to be linked
	 *  once for each form, otherwise we may end up with a selection
	 *  being exported into the workspace gui multiple times.
	 */
	pane = form->subform->guide->pane;
	for (i = 0; i < kformstruct->Selptr->extension_num; i++)
	{
	   if (kformstruct->Selptr->extensions[i]->back_control == pane)
	      return;
	}

	/*
         *  create the new selection in the form tree of the workspace GUI
         */
        new_selection = kvf_create_new_selection(pane, line);

	/*
	 * zero out the (x,y) position of the new selection so 
         * kvf_calculate_y_position won't use *it's* y position & height when 
         * calculating the desired y position  (but save height for restoration)
	 */
	kvf_get_attribute(new_selection->back_kformstruct,
			  KVF_HEIGHT, &height);
	kvf_set_attributes(new_selection->back_kformstruct,
			   KVF_Y,      0.0,
			   KVF_HEIGHT, 0.0,
			   NULL);
	/*
	 * set the y position of the selection in the workspace GUI
	 */
	y = kvf_calculate_y_position(pane);
	kvf_set_attributes(new_selection->back_kformstruct,
			  KVF_X,      1.0,
			  KVF_Y,      y,
			  KVF_HEIGHT, height,
			  NULL);

        /*
         * create the new selection on the GUI: groups not supported 
         */
        if ((new_selection->type != KUIS_MUTEXCL) &&
            (new_selection->type != KUIS_MUTINCL) &&
            (new_selection->type != KUIS_GROUP) &&
	    (pane->back != NULL))
	{
            if (!(xvf_create_selection(new_selection, pane->back, pane->type)))
		return;
	    kvf_get_attributes(new_selection->back_kformstruct,
			       KVF_OPTIONAL, &optional,
			       KVF_OPTSEL,   &optsel,
			       NULL);
	    if ((optional) && (optsel) && 
		(new_selection->opt_object != NULL))
		xvw_reverse_colors(new_selection->opt_object, TRUE);
	}

	/*
         *  for toggles, all the toggle members also need to be copied
         */
        if (new_selection->type == KUIS_TOGGLE)
        {
            toggleptr = old_selection->toggle_next;
            while (toggleptr != NULL)
            {
                toggle_member  = kvf_create_new_toggle_member(new_selection,
                                                              toggleptr->line);
		if (new_selection->back != NULL)
                    xvf_create_selection(toggle_member, new_selection->back,
                                         pane->type);
                toggleptr = toggleptr->next;
            }
            xvf_highlight_toggle(new_selection);
        }

	/*
	 *  Go thru all the selections and make sure the new selection's
	 *  variable name doesn't collide with an existing selection:
	 *  if its name, for example, is "i1", and we already have an "i1",
	 *  we name it "i1_2".  However, if there is already an "i1_2",
	 *  then we must name it "i1_3".
	 */
	if (varname == NULL)
	{
	   selptr = new_selection->back_control->sel_list;
	   duplicate = 0;
	   while (selptr != NULL)
	   {
	       if (selptr != new_selection)
	       {
		   if (selptr->var_token == new_selection->var_token)
		       duplicate++;
		   else 
		   {
		       ksprintf(temp, "%s_", 
			        ktoken_to_string(new_selection->var_token));
		       if (kstrncmp(ktoken_to_string(selptr->var_token), temp,
				    kstrlen(temp)) == 0)
			   duplicate++;
		   }
	       }
	       selptr = selptr->next;
	   }

	   if (duplicate > 0)
	   {
	       kvf_get_attribute(new_selection->back_kformstruct, KVF_VARIABLE, 
			         &variable);
	       ksprintf(temp, "%s_%d", variable, duplicate+1);
	       kvf_set_attribute(new_selection->back_kformstruct, KVF_VARIABLE, 
			         temp);
	   }
	}
	else
	   kvf_set_attribute(new_selection->back_kformstruct, KVF_VARIABLE,
			     varname);

	/*
	 *  If we are inside a procedure then we need to create an external
	 *  connection, but only for input and output user interface types.
	 */
	type = old_selection->type;
	if (type == KUIS_TOGGLE)
	   kvf_get_attribute(kformstruct, KVF_TOGGLE_TYPE, &type);

	if (procedure != NULL && glyph != NULL &&
	    (type == KUIS_INPUTFILE || type == KUIS_OUTPUTFILE ||
	     type == KUIS_STDIN     || type == KUIS_STDOUT))
	{
	   CreateExternalConnector(procedure, glyph, kformstruct);
	}

	/*
	 *  Create the extension connection between the two form structs.
	 */
	kvf_link_extension(kformstruct, new_selection->back_kformstruct);
}

/*-----------------------------------------------------------
|
|  Routine Name: xvw_copy_pane
|
|       Purpose: Copies the selections on pane to the workspace GUI, 
|                which is modelled after the selection the glyph that 
|                it comes from.
|
|         Input: wkspgui   - pointer to the workspace GUI form tree
|                procedure - procedure associated with the form (if any)
|                glyph     - glyph associated with the selection (if any)
|                paneform  - the form which contains the pane which we will be
|			     exporting
|        Output:
|       Returns: 
|    Written By: Mark Young & Danielle Argiro
|          Date: Nov 10, 1994
| Modifications:
|
------------------------------------------------------------*/
/*ARGSUSED*/
void xvw_copy_pane(
   kform *wkspgui,
   xvobject procedure,
   xvobject glyph,
   kform *paneform)
{
	int	     i, num, options_button; 
	int          options_button_contents, etc_buttons;
	kguide	     *guide;
	kform_struct **kformstructs;

	if ((guide = kvf_search_sel_guide(paneform->subform)) == NULL)
	   return;

	/*
	 * get the kformstructs from all the selections on the pane
	 */
	kformstructs = kvf_get_selection_kformstructs(guide->pane, NONE, &num);

	/*
	 * add each of the selections to the workspace GUI
	 */
	for (i = 0; i < num; i++)
	{
	   /*
	    *  except... don't want the Options button (already have one) and 
	    *            don't want any of the buttons from the Options button
	    *            and don't want any help or quit buttons 
	    */
	   options_button = FALSE;
	   options_button_contents = FALSE;
	   etc_buttons = FALSE;

	   if ((kformstructs[i]->flag == KUIS_STARTSUBMENU) &&
                (kformstructs[i]->Selptr->var_token ==
                                kstring_to_token("_gui_options")))
		options_button = TRUE;

	   else if ((kformstructs[i]->Selptr->back_submenu != NULL) &&
                    (kformstructs[i]->Selptr->back_submenu->var_token ==
                                kstring_to_token("_gui_options")))
                options_button_contents = TRUE;

	   else if ((kformstructs[i]->flag == KUIS_HELP) ||
		     (kformstructs[i]->flag == KUIS_QUIT) ||
		     (kformstructs[i]->flag == KUIS_BLANK) ||
		     (kformstructs[i]->flag == KUIS_ROUTINE))
		etc_buttons = TRUE;

	   if (!options_button && !options_button_contents && !etc_buttons)
	      xvw_copy_selection(wkspgui,procedure,glyph,kformstructs[i],NULL);
	}
	kfree(kformstructs);
}
