 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Glyph Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>> 		Initialize()
   >>>> 		SetValues()
   >>>> 		Destroy()
   >>>> 		GlyphCheck()
   >>>> 		GlyphExec()
   >>>> 		DispatchCallback()
   >>>> 		ProcessCallback()
   >>>>   Public:
   >>>>			xvw_create_glyph()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvlang/GlyphP.h>
#include <kutils/ksignal.h>

static void ClassInitialize     PROTO((void));
static void Initialize      PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,Cardinal *));
static void    Destroy	    PROTO((Widget));
static int     GlyphCheck   PROTO((Widget));
static void    GlyphExec    PROTO((Widget, int));
static void DispatchCallback  PROTO((int, int, kaddr, char *));
static void ProcessCallback PROTO((int, int, kaddr));


/*-------------------------------------------------------------------*
|
|   Define Default Pixmap Paths
|
--------------------------------------------------------------------*/

#define ON_PIXMAP	  "$DESIGN/objects/library/xvlang/misc/glyph/on.xpm"
#define OFF_PIXMAP	  "$DESIGN/objects/library/xvlang/misc/glyph/off.xpm"
#define ERROR_PIXMAP	  "$DESIGN/objects/library/xvlang/misc/glyph/error.xpm"
#define INFO_PIXMAP	  "$DESIGN/objects/library/xvlang/misc/glyph/info.xpm"
#define DESTROY_PIXMAP	  "$DESIGN/objects/library/xvlang/misc/glyph/destroy.xpm"
#define DAV_PIXMAP	  "$DESIGN/objects/library/xvlang/misc/glyph/dav.xpm"
#define OPENPANE_PIXMAP	  "$DESIGN/objects/library/xvlang/misc/glyph/pane.xpm"
#define CLOSEPANE_PIXMAP  "$DESIGN/objects/library/xvlang/misc/glyph/pane_selected.xpm"
#define DISTRIBUTE_PIXMAP "$DESIGN/objects/library/xvlang/misc/glyph/distributed.xpm"

#define CONTROL_PIXMAP   "$DESIGN/objects/library/xvlang/misc/glyph/control.xpm"

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_GLYPH_FORM,         NULL, XtRPointer,  NULL},
{XVW_GLYPH_WKSPGUI,      NULL, XtRPointer,  NULL},
{XVW_GLYPH_TBNAME,       NULL, XtRString,   NULL},
{XVW_GLYPH_ONAME,        NULL, XtRString,   NULL},
{XVW_GLYPH_ECHO,	 NULL, XtRInt,      XtRBoolean},
{XVW_GLYPH_REPORTING,	 NULL, XtRInt,      XtRBoolean},
{XVW_GLYPH_SHOWSTATUS,   NULL, XtRInt,      XtRBoolean},
{XVW_GLYPH_CONNECTION_PARENT, NULL, XtRPointer, NULL},
{XVW_GLYPH_EXPRESSION_ID, NULL, XtRPointer, NULL},

{XVW_GLYPH_ON_PIXMAP, NULL, XtRPixmap, NULL},
{XVW_GLYPH_OFF_PIXMAP, NULL, XtRPixmap, NULL},
{XVW_GLYPH_INFO_PIXMAP, NULL, XtRPixmap, NULL},
{XVW_GLYPH_ERROR_PIXMAP, NULL, XtRPixmap, NULL},
{XVW_GLYPH_DESTROY_PIXMAP, NULL, XtRPixmap, NULL},
{XVW_GLYPH_OPENPANE_PIXMAP, NULL, XtRPixmap, NULL},
{XVW_GLYPH_CLOSEPANE_PIXMAP, NULL, XtRPixmap, NULL},
{XVW_GLYPH_DISTRIBUTE_PIXMAP, NULL, XtRPixmap, NULL},
{XVW_GLYPH_DAV_PIXMAP, NULL, XtRPixmap, NULL},
{XVW_GLYPH_CONTROL_PIXMAP, NULL, XtRPixmap, NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwGlyphWidgetRec, glyph.field)

static XtResource resources[] = { 
{XVW_GLYPH_FORM, NULL, XtRPointer, sizeof(XtPointer),
        offset(form), XtRImmediate, (XtPointer) NULL},
{XVW_GLYPH_WKSPGUI, NULL, XtRPointer, sizeof(XtPointer),
        offset(wkspgui), XtRImmediate, (XtPointer) NULL},
{XVW_GLYPH_TBNAME, NULL, XtRString, sizeof(String),
        offset(tbname), XtRImmediate, (XtPointer) NULL},
{XVW_GLYPH_ONAME, NULL, XtRString, sizeof(String),
        offset(oname), XtRImmediate, (XtPointer) NULL},
{XVW_GLYPH_SHOWSTATUS, NULL, XtRBoolean, sizeof(Boolean),
        offset(show_status), XtRImmediate, (XtPointer) FALSE},
{XVW_GLYPH_ECHO, NULL, XtRBoolean, sizeof(Boolean),
        offset(echo), XtRImmediate, (XtPointer) TRUE},
{XVW_GLYPH_REPORTING, NULL, XtRBoolean, sizeof(Boolean),
        offset(reporting), XtRImmediate, (XtPointer) TRUE},
{XVW_GLYPH_CONNECTION_PARENT, NULL, XtRPointer, sizeof(XtPointer),
        offset(connection_parent), XtRImmediate, (XtPointer) NULL},
{XVW_GLYPH_EXPRESSION_ID, NULL, XtRPointer, sizeof(XtPointer),
        offset(expression_id), XtRImmediate, (XtPointer) 0},

{XVW_GLYPH_ON_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(on_pixmap), XtRString, (XtPointer) ON_PIXMAP},
{XVW_GLYPH_OFF_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(off_pixmap), XtRString, (XtPointer) OFF_PIXMAP},
{XVW_GLYPH_DESTROY_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(destroy_pixmap), XtRString, (XtPointer) DESTROY_PIXMAP},
{XVW_GLYPH_OPENPANE_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(openpane_pixmap), XtRString, (XtPointer) OPENPANE_PIXMAP},
{XVW_GLYPH_CLOSEPANE_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(closepane_pixmap), XtRString, (XtPointer) CLOSEPANE_PIXMAP},
{XVW_GLYPH_DISTRIBUTE_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(distribute_pixmap), XtRString, (XtPointer) DISTRIBUTE_PIXMAP},
{XVW_GLYPH_DAV_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(dav_pixmap), XtRString, (XtPointer) DAV_PIXMAP},
{XVW_GLYPH_ERROR_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(error_pixmap), XtRString, (XtPointer) ERROR_PIXMAP},
{XVW_GLYPH_INFO_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(info_pixmap), XtRString, (XtPointer) INFO_PIXMAP},
{XVW_GLYPH_CONTROL_PIXMAP, NULL, XtRPixmap, sizeof(Pixmap),
        offset(control_pixmap), XtRString, (XtPointer) CONTROL_PIXMAP},

{XVW_DEF_HORIZ_DIST, NULL, XtRPosition, sizeof(Position),
        XtOffsetOf(XvwGlyphWidgetRec, manager.horiz_offset),
        XtRImmediate, (XtPointer) 0},
{XVW_DEF_VERT_DIST, NULL, XtRPosition, sizeof(Position),
        XtOffsetOf(XvwGlyphWidgetRec, manager.vert_offset),
        XtRImmediate, (XtPointer) 1},
{XVW_MINIMUM_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwManagerWidgetRec, manager.min_width),
        XtRImmediate, (XtPointer) 24},
{XVW_MINIMUM_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwManagerWidgetRec, manager.min_height),
        XtRImmediate, (XtPointer) 24},
{XVW_CURSOR, XVW_CURSORNAME, XtRCursor, sizeof(Cursor),
      XtOffsetOf(XvwGlyphWidgetRec, manager.cursor), XtRString,
      (XtPointer) "hand1"},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Glyph Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwNodeWidgetClassRec)

XvwGlyphWidgetClassRec xvwGlyphWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Glyph",				/* class_name		  */
    sizeof(XvwGlyphWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwGlyphWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selection proc */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    GlyphCheck,		                    /* firing rule check  */
    GlyphExec, 		                    /* execute node       */
    NULL, 		                    /* extension          */
  },  /* XvwNodeWidgetClass fields initialization */
  {
    NULL,                   	    	    /* extension  */
  },  /* XvwGlyphWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwGlyphWidgetClass = (WidgetClass) &xvwGlyphWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	    (XvwGlyphWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwGlyphWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Mark Young
|          Date: Oct 19, 1992
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
	int     inum;
	kfile   *ifile;


	xvw_init_attributes(xvwGlyphWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvlang/uis/Glyph.pane");
	xvw_load_resources("$DESIGN/objects/library/xvlang/app-defaults/Glyph");

	xvw_define_attributes(xvwGlyphWidgetClass,
		XVW_GLYPH_FORMFILE, XtRString, SetFormfile, GetFormfile,
		NULL);

	kputenv("KHOROS_TRANSPORT_USELOCKF=TRUE");
	kvf_set_expr_handler(GlyphFormExpression);
	if (kipc_start(KIPC_PROCESS) == -1)
	   return;

	if (kipc_getdescriptors(KIPC_PROCESS, &ifile, NULL) == -1 ||
	    kgetdescriptors(ifile, &inum, NULL) == -1)
	{
	   kipc_stop(KIPC_PROCESS);
	   return;
	}
	xvw_add_detectfid(NULL, inum, ProcessCallback, NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial glyph
|                widget instance.
|
|         Input: request - not used
|                new     - widget instance after initialization
|    Written By: Mark Young
|          Date: May 26, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	long mask;
        XvwGlyphWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);
	xvobject parent = xvw_parent(object);


	xwid->glyph.pid           = 0;
	xwid->glyph.rsels         = NULL;
	xwid->glyph.rsize         = 0;
	xwid->glyph.iports        = NULL;
	xwid->glyph.isels         = NULL;
	xwid->glyph.isize         = 0;
	xwid->glyph.oports        = NULL;
	xwid->glyph.osels         = NULL;
	xwid->glyph.osize         = 0;
	xwid->glyph.inum	  = 0;
	xwid->glyph.onum	  = 0;
	xwid->glyph.iconnections  = NULL;
	xwid->glyph.oconnections  = NULL;
	xwid->glyph.error         = NULL;
	xwid->glyph.help          = NULL;
	xwid->glyph.panefile      = NULL;
	xwid->glyph.export_button = NULL;
	xwid->glyph.created_form  = FALSE;
	xwid->glyph.options_initialized = FALSE;

	xwid->glyph.status  = xvw_create_labelstr(parent, "Status");
	xwid->glyph.error     = xvw_create_pixmap(parent, "error/info");
	xwid->glyph.execute   = xvw_create_pixmap(object, "execute");
	xwid->glyph.menuform  = xvw_create_pixmap(object, "menuform");
	xwid->glyph.destroy   = xvw_create_pixmap(object, "destroy");
	xwid->glyph.cflow_in  = xvw_create_pixmap(object, "control");
	xwid->glyph.cflow_out = xvw_create_pixmap(object, "control");
	xwid->glyph.remote    = NULL;

#if 0
/*
 *  Start of creating iconic glyphs...
 */
xvw_unmanage(xwid->glyph.execute);
xvw_unmanage(xwid->glyph.menuform);
xvw_unmanage(xwid->glyph.destroy);
xvw_unmanage(xwid->glyph.cflow_in);
xvw_unmanage(xwid->glyph.cflow_out);
#endif

	xvw_set_attributes(xwid->glyph.cflow_in,
		XVW_PIXMAP,	      xwid->glyph.control_pixmap,
		XVW_BELOW,	      NULL,
		XVW_RIGHT_OF,	      NULL,
		XVW_BORDER_WIDTH,     0,
		XVW_HORIZ_DIST,	      1,
		XVW_VERT_DIST,	      1,
		NULL);
	xvw_set_attributes(xwid->glyph.destroy,
		XVW_PIXMAP,	      xwid->glyph.destroy_pixmap,
		XVW_BELOW,	      NULL,
		XVW_RIGHT_OF, 	      xwid->glyph.cflow_in,
		XVW_BORDER_WIDTH,     0,
		XVW_HORIZ_DIST,	      2,
		XVW_VERT_DIST,        1,
		NULL);
	xvw_set_attributes(xwid->glyph.menuform,
		XVW_PIXMAP,	      xwid->glyph.openpane_pixmap,
		XVW_BELOW,	      NULL,
		XVW_RIGHT_OF,         xwid->glyph.destroy,
		XVW_BORDER_WIDTH,     0,
		XVW_HORIZ_DIST,	      3,
		XVW_VERT_DIST,        1,
		NULL);
	xvw_set_attributes(xwid->glyph.execute,
		XVW_PIXMAP,	      xwid->glyph.off_pixmap,
		XVW_BELOW,	      NULL,
		XVW_RIGHT_OF,	      xwid->glyph.menuform,
		XVW_BORDER_WIDTH,     0,
		XVW_HORIZ_DIST,	      3,
		XVW_VERT_DIST,        1,
		NULL);
	xvw_set_attributes(xwid->glyph.cflow_out,
		XVW_PIXMAP,	      xwid->glyph.control_pixmap,
		XVW_BELOW,	      NULL,
		XVW_RIGHT_OF,	      xwid->glyph.execute,
		XVW_LEFT_OF,	      NULL,
		XVW_BORDER_WIDTH,     0,
		XVW_HORIZ_DIST,	      1,
		XVW_VERT_DIST,        1,
		NULL);
#ifdef REMOTE
	xvw_set_attributes(xwid->glyph.remote,
		XVW_PIXMAP,	   xwid->glyph.distribute_pixmap,
		XVW_BELOW,	   xwid->glyph.menuform,
		XVW_LEFT_OF,	   NULL,
		XVW_RIGHT_OF,	   NULL,
		XVW_MAPPED,	   xwid->node.remote_enable,
		XVW_BORDER_WIDTH,     0,
		XVW_HORIZ_DIST,	      2,
		XVW_VERT_DIST,        1,
		NULL);
#endif
	xvw_set_attributes(xwid->glyph.error,
		XVW_PIXMAP,	   xwid->glyph.error_pixmap,
		XVW_MAPPED,	   FALSE,
                XVW_BELOW,         object,
                XVW_LEFT_OF,       object,
                XVW_RIGHT_OF,      object,
                XVW_SELECTABLE,    FALSE,
                XVW_RESIZABLE,     FALSE,
                XVW_MENUABLE,      FALSE,
		NULL);

	xvw_set_attributes(xwid->glyph.status,
		XVW_LABEL,		NULL,
		XVW_BELOW,		xwid->node.label,
		XVW_FORCE_REDISPLAY,	TRUE,
		XVW_LEFT_OF,		object,
		XVW_RIGHT_OF,		object,
		XVW_SELECTABLE,		FALSE,
		XVW_RESIZABLE,		FALSE,
		XVW_MENUABLE,		FALSE,
		NULL);

	mask = ButtonPressMask | ButtonReleaseMask |
	       EnterWindowMask | LeaveWindowMask;
	xvw_insert_event(xwid->glyph.destroy, mask, GlyphHandler,
		object, KLIST_HEAD);
	xvw_insert_event(xwid->glyph.menuform, mask, GlyphHandler,
		object, KLIST_HEAD);
	xvw_insert_event(xwid->glyph.execute, mask, GlyphHandler,
		object, KLIST_HEAD);
	xvw_insert_event(xwid->glyph.cflow_in, mask, GlyphHandler,
		object, KLIST_HEAD);
	xvw_insert_event(xwid->glyph.cflow_out, mask, GlyphHandler,
		object, KLIST_HEAD);
	xvw_insert_event(xwid->glyph.error, mask, GlyphHandler,
		object, KLIST_HEAD);
#ifdef REMOTE
	xvw_insert_event(xwid->glyph.remote, mask, GlyphHandler,
		object, KLIST_HEAD);
#endif
	xvw_insert_callback(object, XVW_DESTROY, FALSE,
		GlyphDestroyCallback, NULL);

	if (xwid->glyph.connection_parent == NULL)
	   xwid->glyph.connection_parent = parent;
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwGlyphWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the glyph.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output:
|       Returns:
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Aug 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwGlyphWidget cxwid = kwidget(current);
	XvwGlyphWidget nxwid = kwidget(new);

	int      i;
	kguide   *guide;


	/*
	 *  Set the form associated with the glyph:
         *  1) create the I/O ports on the glyph according to selected pane
         *  2) set the name of the glyph according to the selected pane
         *  3) if there is > 1 pane, install callbacks to update the glyph
         *     name and I/O ports when the pane is changed.
	 */
	if (cxwid->glyph.form !=  nxwid->glyph.form)
	{
	   /* 
	    * update the glyph label and the I/O ports according
            * to the currently selected pane
	    */
	   GlyphInitForm(new);

	   /* 
	    * more than one pane? add callbacks to each guide button that
            * will update the glyph label & I/O ports when pane is changed
            */
	   if ((guide=kvf_search_sel_guide(nxwid->glyph.form->subform)) != NULL)
	   {
	      while (guide != NULL)
	      {
		 xvf_add_extra_call(guide->back_kformstruct, GlyphInitForm,
				       (kaddr) nxwid, XVF_CALL_LAST);
		 guide = guide->next;
	      }
	   }
	   nxwid->glyph.created_form = FALSE;

	   if (cxwid->glyph.form != NULL && cxwid->glyph.created_form)
	      xvf_destroy_form(cxwid->glyph.form);
	}

	if (cxwid->node.modified      != nxwid->node.modified ||
	    cxwid->node.show_modified != nxwid->node.show_modified)
	{
	   if (nxwid->node.modified && nxwid->glyph.exectype != 0)
	   {
	      for (i = 0; i < nxwid->glyph.osize; i++)
	         xvw_set_attribute(nxwid->glyph.oports[i], XVW_PORT_DAV, FALSE);
	   }
	   xvw_unmap(nxwid->glyph.error);
	}

	if (cxwid->glyph.tbname != nxwid->glyph.tbname)
	{
	   kfree(cxwid->glyph.tbname);
	   nxwid->glyph.tbname = kstrdup(nxwid->glyph.tbname);
	}

	if (cxwid->glyph.oname != nxwid->glyph.oname)
	{
	   kfree(cxwid->glyph.oname);
	   nxwid->glyph.oname = kstrdup(nxwid->glyph.oname);
	}
#ifdef REMOTE
	if (cxwid->node.remote_enable != nxwid->node.remote_enable)
	{
	   if (nxwid->node.remote_enable)
	      xvw_map(nxwid->glyph.remote);
	   else
	      xvw_unmap(nxwid->glyph.remote);
	}
#endif
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: destroy the glyph...
|         Input: widget - the glyph widget being destroyed 
|        Output: 
|
|    Written By: Mark Young
|          Date: Nov 21, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
	XvwGlyphWidget xwid = kwidget(widget);

	int          i, num;
	kform_struct **extensions;
	Widget parent =  XtParent(widget);


	/*
	 *  Now destroy any associated objects...
	 */
	if (xwid->glyph.help)
	   xvw_destroy(xwid->glyph.help);

	if (!parent->core.being_destroyed)
	{
	   if (xwid->glyph.status)
	      xvw_destroy(xwid->glyph.status);

	   if (xwid->glyph.error)
	      xvw_destroy(xwid->glyph.error);

	   for (i = xwid->glyph.inum-1; i >= 0; i--)
	      xvw_destroy(xwid->glyph.iconnections[i]);

	   for (i = xwid->glyph.onum-1; i >= 0; i--)
	      xvw_destroy(xwid->glyph.oconnections[i]);
	}

	/*
	 *  Delete any extensions associated with the glyph's wkspgui...
	 */
	if (xwid->glyph.form != NULL)
	{
	   extensions = kvf_get_extensions(xwid->glyph.form, &num);
	   for (i = 0; i < num; i++)
	      xvf_set_attribute(extensions[i], XVF_DELETE, TRUE);

	   kfree(extensions);
	   if (xwid->glyph.created_form) xvf_destroy_form(xwid->glyph.form);
	}

	/*
	 *  Free memory...  We do what we can to conserve
	 */
	kfree(xwid->glyph.panefile);
	kfree(xwid->glyph.tbname);
	kfree(xwid->glyph.oname);
	xwid->glyph.help  = NULL;
	xwid->glyph.form  = NULL;
}

/*-----------------------------------------------------------
|
|  Routine Name: GlyphCheck
|
|       Purpose: This routine will check to see if a glyph is ready to run.
|         Input: widget      - the glyph widget to be checked
|
|    Written By: Mark Young
|          Date: Jul 30, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static int GlyphCheck(
   Widget   widget)
{
        XvwGlyphWidget xwid = (XvwGlyphWidget) widget;

	xvobject temp;
	int i, test, executing, modified, selected;


	for (i = 0; i < xwid->glyph.isize; i++)
	{
	   xvw_get_attributes(xwid->glyph.iports[i],
			XVW_PORT_DAV,      &test,
	      		XVW_PORT_SELECTED, &selected,
			NULL);
	   if (test == FALSE && selected == TRUE)
	      return(FALSE);
	}

	for (i = 0; i < xwid->glyph.inum; i++)
	{
	   temp = NULL;
	   xvw_get_attribute(xwid->glyph.iconnections[i],
			XVW_CONNECTION_BEGIN, &temp);

	   temp = xvw_parent(temp);
	   xvw_get_attributes(temp,
			XVW_NODE_EXECUTE, &executing,
			XVW_NODE_MODIFIED, &modified,
			NULL);
	   if (executing == TRUE || modified == TRUE)
	      return(FALSE);
	}
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: GlyphExec
|
|       Purpose: This routine will run or stop the execution of an glyph .
|         Input: widget      - the glyph widget to be run
|                exec        - whether we wish to run or stop the glyph
|
|    Written By: Mark Young
|          Date: Jul 30, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void GlyphExec(
   Widget   widget,
   int      exec)
{
	XvwGlyphWidget xwid = (XvwGlyphWidget) widget;

	int  i;
	char *command, temp[KLENGTH];
	xvobject glyph = xvw_object(widget);


	if (exec == KNODE_RUNNING)
	{
	   /*
	    *  Make sure that our glyph data available is set to
	    *  false.
	    */
	   for (i = 0; i < xwid->glyph.osize; i++)
	      xvw_set_attribute(xwid->glyph.oports[i], XVW_PORT_DAV, FALSE);

	   GlyphFormCallback(xwid->glyph.form, xwid->glyph.form->subform,
			(kaddr) glyph);
	   if (xwid->glyph.exectype != 0)
	   {
	      xvw_set_attribute(xwid->glyph.execute, XVW_PIXMAP,
			xwid->glyph.on_pixmap);
	      if ((command = kvf_form_to_cmd(xwid->glyph.form,
			xwid->glyph.form->subform, NULL, TRUE)) == NULL)
	      {
	         kerror(XVLANG, "GlyphExec", "Unable to build command line");
	         return;
	      }

	      /*
	       *  Check to see if we should echo the command, before executing
	       */
	      if (xwid->glyph.echo)
	      {
	         kprintf("\n# %s %s %s\n%s\n", xwid->glyph.tbname,
			xwid->glyph.oname, xwid->node.name, command);
	      }

	      if (xwid->node.testing == TRUE)
	         ksprintf(temp, "test '%s'", command);
	      else
	         kstrcpy(temp, command);

	      xwid->glyph.pid = xvw_fork(temp, DispatchCallback, glyph);
	      kfree(command);
	   }
	   else
	      DispatchCallback(0, 0, glyph, NULL);
	}
	else if (exec == KNODE_STOPPED)
	{
	   xvw_set_attribute(xwid->glyph.execute, XVW_PIXMAP,
			xwid->glyph.off_pixmap);
	   if (xwid->glyph.pid != 0)
	   {
	      kill(xwid->glyph.pid, SIGHUP);
	      xwid->glyph.pid = 0;
              for (i = 0; i < xwid->glyph.osize; i++)
                 xvw_set_attribute(xwid->glyph.oports[i], XVW_PORT_DAV, FALSE);
	   }
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: DispatchCallback - execute callback routine
|
|       Purpose: This routine is used to process when a glyph finishes
|		 executing.
|         Input: object - object to be used to build the form
|    Written By: Mark Young
|          Date: Nov 26, 1993
|
------------------------------------------------------------*/

extern klist *frontier;

/* ARGSUSED */ 
static void DispatchCallback(
   int     pid,
   int     status,
   kaddr   client_data,
   char    *error)
{
	xvobject object;
	XvwGlyphWidget xwid;
        xvobject glyph = (xvobject) client_data;

	int   i;
	long  id;
	klist *entry;
	char  *tmp, temp[KLENGTH], message[KLENGTH];


	/*
	 *  Better check to see if this an actively executing glyph.
	 *  Otherwise we better just bag it and return.  If the glyph
	 *  has been destroyed it is possible that we will get called
	 *  after the glyph has been destroyed and we will end up accessing
	 *  freed memory.  Hence, we don't want to dive into any structures,
	 *  of get the widget structure.
	 */
	if ((entry = klist_locate(frontier, (kaddr) glyph)) == NULL)
	   return;

	xwid = (XvwGlyphWidget) xvw_widget(glyph);
	if (status != 0 && xwid->glyph.pid == pid)
	{
	   xvw_set_attribute(glyph, XVW_NODE_MODIFIED, TRUE);
	   if (!error)
	   {
	      ksprintf(message,
"Error!  The following routine has terminated abnormally but no error\n\
message was found.  The following information can be determined\n\
about the terminating\n process:\n\n\t Routine Name: (%s)\n\t Process \
id (%d)\n\t Exit Status (%d)\n\t Termination Signal: ", xwid->node.name,
pid, status);
              error = message;
	   }
	}
	else if (xwid->glyph.pid == pid)
	{
	   if (xwid->node.type != KNODE_TYPE_SINK)
	   {
	      if (xwid->node.testing == FALSE)
	         xvw_set_attribute(glyph, XVW_NODE_MODIFIED, FALSE);
	      else
	         xvw_set_attribute(glyph, XVW_NODE_MODIFIED, TRUE);

	      for (i = 0; i < xwid->glyph.osize; i++)
	         xvw_set_attribute(xwid->glyph.oports[i], XVW_PORT_DAV, TRUE);
	   }
	   else
	      xvw_set_attribute(glyph, XVW_NODE_MODIFIED, TRUE);
	}

	if (error != NULL && error != message && xwid->glyph.exectype == 4)
	{
	   kchar_replace(error, '\n', ';', temp);
	   id = (long) xwid->glyph.expression_id;
	   if (kexpr_evaluate_generic(id, temp, KSTRING, NULL, NULL))
	      error = NULL;
	}

	if (error != NULL && xwid->glyph.reporting == TRUE)
	{
	   if (!xwid->glyph.help)
	   {
	      xwid->glyph.help = xvw_create_help(NULL, "Glyph Help Output");
	      xvw_unmap(xvw_toplevel(xwid->glyph.help));

	      (void) ksprintf(temp, "Output For '%s'", xwid->node.name);
	      xvw_set_attributes(xwid->glyph.help,
			XVW_HELP_TITLE, temp,
			XVW_PREFERRED_HEIGHT, 350,
			XVW_HELP_QUITLABEL,   "Close",
			XVW_HELP_DESTROY_ON_QUIT, FALSE,
			NULL);
	   }
	   xvw_get_attribute(xwid->glyph.help, XVW_HELP_TEXTDISPLAY_OBJECT,
			&object);
	   xvw_set_attributes(object,
		XVW_TEXTDISPLAY_CLEARTEXT, TRUE,
		XVW_TEXTDISPLAY_ADDTEXT, error,
		NULL);

	   if (status != 0)
	      xvw_set_attribute(xwid->glyph.error, XVW_PIXMAP,
			xwid->glyph.error_pixmap);
	   else
	      xvw_set_attribute(xwid->glyph.error, XVW_PIXMAP,
			xwid->glyph.info_pixmap);

	   xvw_map(xwid->glyph.error);
	}
	else
	{
	   while (error != NULL)
	   {
	      if ((tmp = kstrchr(error, '\n')) != NULL)
		 *tmp++ = '\0';

	      kfprintf(kstderr, "%d: %s\n", pid, error);
	      error = tmp;
	   }
	}

	/*
	 *  This process is done.  So we now want to clear the process id
	 *  and set the stop the glyph execution.
	 */
	if (xwid->glyph.pid == pid)
	{
	   xwid->glyph.pid = 0;
	   xvw_set_attribute(glyph, XVW_NODE_EXECUTE, FALSE);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: ProcessCallback - routine for handling process negotiation
|
|       Purpose: This routine is called when one of the sub-process wants to
|		 inform of some process update
|
|         Input: id  - the callback id
|                fid - the input file descriptor
|		 client_data - not used
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Dec 12, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ProcessCallback(
   int id,
   int fid, 
   kaddr client_data)
{
	kfile *ifile, *ofile;
	char  buffer[KLENGTH];


        if (kipc_getdescriptors(KIPC_PROCESS, &ifile, &ofile) == -1)
           return;
 
        if (kfgets(buffer, KLENGTH, ifile) == NULL)
           return;
 
	kfprintf(kstderr,"cantata: '%s'\n", buffer);
        kfputs("yes", ofile);
}


/************************************************************
*
*  Routine Name: xvw_create_glyph - create a glyph object
*
*       Purpose: The purpose of the Glyph GUI object is to used to represent
*		 an operator within Khoros.  Typically these are data processing
*		 routines that have a set of inputs and outputs that can be
*		 used to connect to other glyph's in which to form a visual
*		 program.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object
*        Output: None
*       Returns: The glyph object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Jan 14, 1993
*      Verified:
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_glyph(
   xvobject parent,
   char     *name)
{
	xvobject glyph;


	glyph = xvw_create(parent, FALSE, TRUE, name, GlyphWidgetClass);
	xvw_set_attributes(glyph,
		XVW_SELECTABLE, TRUE,
		XVW_RESIZABLE, FALSE,
		XVW_MENUABLE, FALSE,
		NULL);
	return(glyph);
}
