 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            General Utility Routines
   >>>>
   >>>>   Static:
   >>>>  Private:
   >>>>   Public:
   >>>>		   xvw_save_annotations()
   >>>>		   xvw_restore_annotations()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/CircleP.h>
#include <xvisual/DateP.h>
#include <xvisual/LineP.h>
#include <xvisual/MarkerP.h>
#include <xvisual/RectangleP.h>
#include <xvisual/StringP.h>
#include <xvisual/StringValueP.h>
#include <xvisual/TextStringP.h>


/************************************************************
*
*  Routine Name: xvw_save_annotations - saves the annotations associated
*					with a workspace
*
*       Purpose: xvw_save_annotations saves the annotations associated with
*		 a workspace into the specified filename
*         Input: object -   the workspace in which we will be saving the
*			    annotations
*		 filename - the annotation file to be created
*        Output:
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: 
*    Written By: Mark Young
*          Date: Oct 12, 1993
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

int xvw_save_annotations(
   xvobject object,
   kfile    *file)
{
	int    i, num;
	Widget *children;

	xvw_get_attributes(object,
		XVW_NUM_CHILDREN, &num,
		XVW_CHILDREN,     &children,
		NULL);

	kfprintf(file, "AnnotationsBegin\n");
	for (i = 0; i < num; i++)
	{
	   if (XtClass(children[i]) == CircleGadgetClass)
	   {
	      kfprintf(file, "circle\n");
	   }
	   else if (XtClass(children[i]) == DateGadgetClass)
	   {
	      kfprintf(file, "date\n");
	   }
	   else if (XtClass(children[i]) == LineGadgetClass)
	   {
	      kfprintf(file, "line\n");
	   }
	   else if (XtClass(children[i]) == MarkerGadgetClass)
	   {
	      kfprintf(file, "marker\n");
	   }
	   else if (XtClass(children[i]) == RectangleGadgetClass)
	   {
	      kfprintf(file, "rectangle\n");
	   }
	   else if (XtClass(children[i]) == StringGadgetClass)
	   {
	      kfprintf(file, "string\n");
	   }
	   else if (XtClass(children[i]) == StringValueGadgetClass)
	   {
	      kfprintf(file, "stringvalue\n");
	   }
	   else if (XtClass(children[i]) == TextStringGadgetClass)
	   {
	      kfprintf(file, "textstring\n");
	   }
	}
	kfprintf(file, "AnnotationsEnd\n");
	return(TRUE);
}


/************************************************************
*
*  Routine Name: xvw_restore_annotations - restore the annotations associated
*					   with a workspace
*
*       Purpose: xvw_restore_annotations restore the annotations associated
*		 with a workspace into the specified filename
*         Input: object -   the workspace in which we will be restoring the
*			    annotations
*		 filename - the annotation file to be read
*        Output:
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: 
*    Written By: Mark Young
*          Date: Oct 12, 1993
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

int xvw_restore_annotations(
   xvobject object,
   kfile    *file)
{
	char   temp[KLENGTH];


	return(TRUE);
#if 0
	while (!kfeof(file))
	{
	   if (kstrcmp(temp, "circle") == 0)
	   {
	   }
	   else if (kstrcmp(temp, "cursor") == 0)
	   {
	   }
	   else if (kstrcmp(temp, "date") == 0)
	   {
	   }
	   else if (kstrcmp(temp, "line") == 0)
	   {
	   }
	   else if (kstrcmp(temp, "marker") == 0)
	   {
	   }
	   else if (kstrcmp(temp, "raster") == 0)
	   {
	   }
	   else if (kstrcmp(temp, "rectangle") == 0)
	   {
	   }
	   else if (kstrcmp(temp, "string") == 0)
	   {
	   }
	   else if (kstrcmp(temp, "stringvalue") == 0)
	   {
	   }
	   else if (kstrcmp(temp, "text") == 0)
	   {
	   }
	}
	return(TRUE);
#endif
}
