 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                Threshold Widget Routines
   >>>>
   >>>>	Private:
   >>>>	 Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			ValueCallback()
   >>>>			UpdateValue()
   >>>>			SetValues()
   >>>>  Public:
   >>>>			xvw_create_threshold()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/xvisual.h>
#include <xvisual/ThresholdP.h>
#include <xvisual/Palette.h>

static int last_range = 0;

static void ClassInitialize PROTO((void));
static void Initialize	    PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,
				   Cardinal *));

static void ValueCallback PROTO((xvobject, kaddr, kaddr));
static void UpdateValue   PROTO((Widget, xvobject, int));

#undef kwidget
#undef kwidgetclass
#undef kconstraint

#define kwidget(widget)      (XvwThresholdWidget) (widget)
#define kwidgetclass(widget) (XvwThresholdWidgetClass) (widget)->core.widget_class
#define kconstraint(widget)  (XvwThresholdWidgetConstraints) (widget)->core.constraints


/*-------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_THRESHOLD_SHOW_PALETTE,   NULL, XtRInt,      XtRBoolean},
{XVW_THRESHOLD_POLICY,	       NULL, XtRInt,      NULL},
{XVW_THRESHOLD_LOWERVAL,       NULL, XtRInt,      NULL},
{XVW_THRESHOLD_UPPERVAL,       NULL, XtRInt,      NULL},
{XVW_THRESHOLD_CLIP_PIXELVAL,  NULL, XtRPixel,    NULL},
{XVW_THRESHOLD_CLIP_ACCEPT,    NULL, XtRInt,      XtRBoolean},
{XVW_THRESHOLD_THRES_PIXELVAL, NULL, XtRPixel,    NULL},
{XVW_THRESHOLD_THRES_INVERT,   NULL, XtRInt,      XtRBoolean},
{XVW_THRESHOLD_CALLBACK,       NULL, XtRCallback, NULL},
{XVW_THRESHOLD_PALETTE_OBJECT, NULL, XtRPointer, NULL},
};

/*-------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwThresholdWidgetRec, threshold.field)

static XtResource resources[] = { 
{XVW_THRESHOLD_SHOW_PALETTE, NULL, XtRBoolean, sizeof(Boolean),
      offset(show_palette), XtRImmediate, (XtPointer) TRUE},
{XVW_THRESHOLD_POLICY, NULL, XtRInt, sizeof(int),
      offset(policy), XtRImmediate, (XtPointer) KTHRESHOLD_POLICY_CLIP},
{XVW_THRESHOLD_LOWERVAL, NULL, XtRInt, sizeof(int),
      offset(lowerval), XtRImmediate, (XtPointer) 0},
{XVW_THRESHOLD_UPPERVAL, NULL, XtRInt, sizeof(int),
      offset(upperval), XtRImmediate, (XtPointer) 255},
{XVW_THRESHOLD_CLIP_PIXELVAL, NULL, XtRPixel, sizeof(Pixel),
      offset(clip_pixelval), XtRString, (XtPointer) "black"},
{XVW_THRESHOLD_CLIP_ACCEPT, NULL, XtRBoolean, sizeof(Boolean),
      offset(clip_accept), XtRImmediate, (XtPointer) TRUE},
{XVW_THRESHOLD_THRES_PIXELVAL, NULL, XtRPixel, sizeof(Pixel),
      offset(thres_pixelval), XtRString, (XtPointer) "white"},
{XVW_THRESHOLD_THRES_INVERT, NULL, XtRBoolean, sizeof(Boolean),
      offset(thres_invert), XtRImmediate, (XtPointer) FALSE},
{XVW_THRESHOLD_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(threshold_callbacks), XtRCallback, (XtPointer) NULL},
{XVW_THRESHOLD_PALETTE_OBJECT, NULL, XtRObject, sizeof(xvobject),
        offset(palette), XtRImmediate, (XtPointer) NULL},
{NULL, NULL, XtRBoolean, sizeof(Boolean),
      XtOffsetOf(XvwColorWidgetRec, color.initialize_visual),
      XtRImmediate, (XtPointer) FALSE},
};
#undef offset


#define SUPERCLASS (&xvwColorWidgetClassRec)

XvwThresholdWidgetClassRec xvwThresholdWidgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Threshold",				/* class_name		  */
    sizeof(XvwThresholdWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    XtInheritTranslations,		/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,	            		/* subresources       */
    0,					/* subresources_count */
    sizeof(XvwManagerWidgetConstraintsRec),/* constraint_size    */
    NULL,				/* initialize         */
    NULL,                               /* destroy            */
    NULL,				/* set_values         */
    NULL,                               /* extension          */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,			/* child layout routine  */
    XtInheritChangeSel,		        /* change selected proc   */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritResize,			/* resize		  */
    XtInheritGeometryManager,  		/* geometry_manager	  */
  }, /* XvwManagerWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwGraphicsWidgetClass fields initialization */
  {
    XtInheritColorReload,		/* reload color proc             */
  },  /* XvwColorWidgetClass fields initialization */
  {
    NULL,                               /* field not used    */
  },  /* XvwThresholdWidgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwThresholdWidgetClass for public consumption
 */
WidgetClass xvwThresholdWidgetClass = (WidgetClass) &xvwThresholdWidgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of threshold widget class has been created.
|                It will initialize all the class attributes.
|
|    Written By: Mark Young 
|          Date: Nov 17, 1992
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwThresholdWidgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/Threshold.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Threshold");
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial threshold color
|                widget instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|    Written By: Mark Young
|          Date: May 26, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwThresholdWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);
	xvobject range_text_object, range_crlabel_object;


	xvw_set_attributes(object, 
			   XVW_WIDTH,  500,
			   XVW_HEIGHT, 175,
			   NULL);
	/*
	 *  Create the palette and threshold color scrollbars
	 */
	xwid->threshold.palette = xvw_create_palette(object, "palette");
	if (!xwid->threshold.show_palette)
	   xvw_unmanage(xwid->threshold.palette);

	xwid->threshold.lint = xvw_create_integer(object, "lower");
	xwid->threshold.uint = xvw_create_integer(object, "upper");
	xwid->threshold.rint = xvw_create_integer(object, "range");

	/*
	 *  Initialize the palette to extend the width of the palette
	 */
	xvw_set_attributes(xwid->threshold.palette,
		XVW_ABOVE,	xwid->threshold.lint,
		XVW_BELOW,	NULL,
		XVW_TACK_EDGE,	KMANAGER_TACK_ALL,
		NULL);

        /*
         *  Make sure the scrollbars extends the height of the
         *  threshold widget.
         */
        xvw_set_attributes(xwid->threshold.lint,
		XVW_ABOVE,	      xwid->threshold.uint,
                XVW_RIGHT_OF,         NULL,
                XVW_LEFT_OF,          NULL,
		XVW_TACK_EDGE,	      KMANAGER_TACK_HORIZ,
		XVW_CHAR_HEIGHT,      1.0,
                XVW_INTEGER_LABEL,    "Lower",
                XVW_INTEGER_MINVALUE, 0,
                XVW_INTEGER_MAXVALUE, 255,
		NULL);

        xvw_set_attributes(xwid->threshold.uint,
		XVW_ABOVE,	      xwid->threshold.rint,
                XVW_RIGHT_OF,         NULL,
                XVW_LEFT_OF,          NULL,
                XVW_TACK_EDGE,        KMANAGER_TACK_HORIZ,
		XVW_CHAR_HEIGHT,      1.0,
                XVW_INTEGER_LABEL,    "Upper",
                XVW_INTEGER_MINVALUE, 0,
                XVW_INTEGER_MAXVALUE, 255,
		NULL);

        xvw_set_attributes(xwid->threshold.rint,
		XVW_ABOVE,	      NULL,
                XVW_RIGHT_OF,         NULL,
                XVW_LEFT_OF,          NULL,
                XVW_TACK_EDGE,        KMANAGER_TACK_HORIZ,
                XVW_CHAR_HEIGHT,      1.0,
                XVW_INTEGER_LABEL,    "Range",
                XVW_INTEGER_MINVALUE, 0,
                XVW_INTEGER_MAXVALUE, 255,
		NULL);

	/*
	 * to avoid scrollbar errors (bug in integer object),
	 * set integer values separately, afterwards.
	 */
	xvw_set_attribute(xwid->threshold.lint, XVW_INTEGER_VALUE, 0);
	xvw_set_attribute(xwid->threshold.uint, XVW_INTEGER_VALUE, 255);
	xvw_set_attribute(xwid->threshold.rint, XVW_INTEGER_VALUE, 0);

	/*
	 *  Add the callbacks for the red, green, and blue scrollbars that
	 *  will be used to change the color palette.
	 */
	xvw_insert_callback(xwid->threshold.lint, XVW_INTEGER_CALLBACK,
			 FALSE, ValueCallback, (XtPointer) xwid);
	xvw_insert_callback(xwid->threshold.uint, XVW_INTEGER_CALLBACK,
			 FALSE, ValueCallback, (XtPointer) xwid);
	xvw_insert_callback(xwid->threshold.rint, XVW_INTEGER_CALLBACK,
			 FALSE, ValueCallback, (XtPointer) xwid);

	/*
	 * display makes more sense if integer value for range isn't displayed.
	 */
	xvw_get_attributes(xwid->threshold.rint,
			   XVW_INTEGER_TEXT_OBJECT,    &range_text_object,
		           XVW_INTEGER_CRLABEL_OBJECT, &range_crlabel_object,
			   NULL);
	xvw_unmap(range_text_object);
	xvw_unmap(range_crlabel_object);
}


/*-----------------------------------------------------------
|
|  Routine Name: ValueCallback
|
|       Purpose: This routine will change the (L, U, or R) component
|	         according to the value in the integer object.
|
|         Input: object      - the integer object 
|		 client_data - the threshold widget
|		 call_data   - integer value of integer object
|    Written By: Mark Young & Danielle Argiro
|          Date: Jun 06, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ValueCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	XvwThresholdWidget xwid = kwidget(client_data);
	int value = *((int *) call_data);

	Widget widget = (Widget) xwid;
	xvw_threshold_struct threshold;
	int type, pos, lower, upper, range, diff, max;

	static int active = FALSE;


	/*
	 *  Make sure we aren't in the middle of callback...
	 */
	if (active)
	   return;
	else
	   active = TRUE;

	xvw_get_attribute(xwid->threshold.uint, XVW_INTEGER_VALUE, &upper);
	xvw_get_attribute(xwid->threshold.lint, XVW_INTEGER_VALUE, &lower);
	xvw_get_attribute(xwid->threshold.rint, XVW_INTEGER_VALUE, &range);

	/*
	 *  The lower bound has been changed.
	 */
	if (object == xwid->threshold.lint)
	{
	   pos   = 0;
	   type  = KTHRESHOLD_LOWER;

	   /* 
	    * can't allow lower bound value to exceed upper bound.
	    */
	   if (lower > upper)
	      xvw_set_attribute(xwid->threshold.uint, XVW_INTEGER_VALUE, lower);
	   if (lower > range)
	      xvw_set_attribute(xwid->threshold.rint, XVW_INTEGER_VALUE, lower);
	}

	/*
	 *  The upper bound has been changed.
	 */
	else if (object == xwid->threshold.uint)
	{
	   pos   = 1;
	   type  = KTHRESHOLD_UPPER;

	   /* 
	    * can't allow upper bound value to get below lower bound.
	    */
	   if (upper < lower)
	      xvw_set_attribute(xwid->threshold.lint, XVW_INTEGER_VALUE, upper);
	   if (upper < range)
	      xvw_set_attribute(xwid->threshold.rint, XVW_INTEGER_VALUE, upper);
	}

	/*
	 *  The range has been changed.
	 */
	else if (object == xwid->threshold.rint)
	{
	   pos   = 2;
	   type  = KTHRESHOLD_RANGE;

	   range = value;
           xvw_get_attribute(xwid->threshold.uint, XVW_INTEGER_MAXVALUE, &max);

	   /*
	    * moving range scrollbar to the right past lower scrollbar
	    */
	   if ((range > last_range) && (range > lower)) 
	   {
	      /*
	       * need to scoot both lower & upper scrollbars up but maintain
	       * relative distance between them.
	       */
	      diff = range - last_range;
	      if ((upper + diff) <= max)
	      {
	          xvw_set_attribute(xwid->threshold.lint, XVW_INTEGER_VALUE, 
				    lower + diff);
	          xvw_set_attribute(xwid->threshold.uint, XVW_INTEGER_VALUE, 
				    upper + diff);
	      }

	      /*	 
	       * move lower & upper scrollbars up as far as they can go
	       * (but still maintain relative distance)
	       */
	      else 
	      {
	 	  xvw_set_attribute(xwid->threshold.lint, XVW_INTEGER_VALUE,
                                    max - (upper - lower));
                  xvw_set_attribute(xwid->threshold.uint, XVW_INTEGER_VALUE,
                                    max);
	      }
	   }

	   /*
	    * moving range scrollbar to left past upper scrollbar
	    */
	   else if ((range < last_range) && (range < upper)) 
           {
              /*
               * need to scoot both lower & upper scrollbars back but maintain
               * relative distance between them.
               */
              diff = last_range - range;
              if ((lower - diff) >= 0)
              {
                  xvw_set_attribute(xwid->threshold.lint, XVW_INTEGER_VALUE,
                                    lower - diff);
                  xvw_set_attribute(xwid->threshold.uint, XVW_INTEGER_VALUE,
                                    upper - diff);
              }
              /*         
               * move lower & upper scrollbars back as far as they can go
               * (but still maintain relative distance)
               */
              else
              {
                  xvw_set_attribute(xwid->threshold.lint, XVW_INTEGER_VALUE, 0);
                  xvw_set_attribute(xwid->threshold.uint, XVW_INTEGER_VALUE,
                                    (upper - lower));
              }
           }
	}
	else return;

	xwid->threshold.lowerval = lower;
	xwid->threshold.upperval = upper;
	UpdateValue((Widget) xwid, object, value);

	threshold.type   = type;
	threshold.value = (int) value;
	XtCallCallbackList((Widget) xwid, xwid->threshold.threshold_callbacks,
			(XtPointer) &threshold);

	active = FALSE;
	last_range = range;
}

/*-----------------------------------------------------------
|
|  Routine Name: UpdateValue
|
|       Purpose: This routine will update the value.
|
|         Input: widget      - the threshold widget
|		 object      - the integer object 
|    Written By: Mark Young & Danielle Argiro
|          Date: Jan 04, 1995
|
------------------------------------------------------------*/
/* ARGSUSED */
static void UpdateValue(
  Widget   widget,
  xvobject object,
  int	   value)
{
        XvwThresholdWidget xwid = kwidget(widget);

	Pixel  *pixels;
	XColor *xcolors;
	int    i, ncolors, invert, lower, upper;

	if (object)
	   xvw_set_attribute(object, XVW_INTEGER_VALUE, value);
	if (xwid->color.info == NULL)
	   return;

	pixels  = ColorGetPixels(widget);
	xcolors = ColorGetXColors(widget);
	ncolors = xwid->color.info->ncolors;

	lower = xwid->threshold.lowerval;
	upper = xwid->threshold.upperval;
	if (xwid->threshold.policy == KTHRESHOLD_POLICY_THRESH)
	   invert = xwid->threshold.thres_invert;
	else
	   invert = !xwid->threshold.clip_accept;

	for (i = 0; i < ncolors; i++)
	{
	   if (xcolors[i].flags == 0)
	      continue;

	   if (!invert && (i <= lower || i >= upper))
	      pixels[i] = xwid->threshold.clip_pixelval;
	   else if (invert && (i >= lower && i <= upper))
	      pixels[i] = xwid->threshold.clip_pixelval;
	   else if (xwid->threshold.policy == KTHRESHOLD_POLICY_THRESH)
	      pixels[i] = xwid->threshold.thres_pixelval;
	   else
	      pixels[i] = xcolors[i].pixel;
	}
	ColorStore(widget, -1, NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: Determine what the widget should do by
|		 comparing the current values verse the
|		 new settings.
|
|         Input: current - the widget containing current settings 
|		 request - the widget containing requested settings
|		 new	 - the widget processed through all set values methods 
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Nov 17, 1992
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwThresholdWidget cxwid = kwidget(current);
	XvwThresholdWidget nxwid = kwidget(new);

	if (cxwid->color.object != nxwid->color.object)
	{
	   xvw_set_attribute(nxwid->threshold.palette, XVW_COLOR_COLOROBJ,
			nxwid->color.object);
	}

	if (cxwid->threshold.policy       != nxwid->threshold.policy ||
	    cxwid->threshold.thres_invert != nxwid->threshold.thres_invert ||
	    cxwid->threshold.clip_accept  != nxwid->threshold.clip_accept)
	{
	   UpdateValue(new, NULL, 0);
	}

	if (cxwid->threshold.lowerval != nxwid->threshold.lowerval)
	   UpdateValue(new, nxwid->threshold.lint, nxwid->threshold.lowerval);
	if (cxwid->threshold.upperval != nxwid->threshold.upperval)
	   UpdateValue(new, nxwid->threshold.uint, nxwid->threshold.upperval);

	if (cxwid->threshold.show_palette != nxwid->threshold.show_palette)
	{
	   if (!nxwid->threshold.show_palette)
	      xvw_unmanage(nxwid->threshold.palette);
	   else
	      xvw_manage(nxwid->threshold.palette);
	}
	return(FALSE);
}


/************************************************************
*
*  Routine Name: xvw_create_threshold - create a threshold object
*
*       Purpose: Creates an threshold object which will display
*		 the colormap values of an object's colormap.
*
*		 The threshold object is used by the user to mask out certain
*		 parts ofthe image so that they are only looking at desired
*		 range of pixels.  The threshold objects contains an
*		 upper and lower scrollbar from which we can extract
*		 the pixel range to be threshold.
*
*		 The threshold objects also contains the "pixel" that we
*		 are going to be setting the threshold values to, and
*		 whether we are to accept or reject that range.  The
*		 "accept" value is a boolean which tells us if we are
*		 to threshold everything outside the lower & upper
*		 range or whether we threshold everything inside that
*		 range.  (If accept is true then we threshold
*		 everything outside the range otherwise we threshold
*		 the pixels inside the range).
*
*		 The threshold works by setting the pixels in the
*		 threshold range to the current threshold color
*		 (specified by pixel).  And then storing these values
*		 in the xvdisplay colormap.  But in order to make sure
*		 none of the other displays over-ride this threshold we
*		 set the pixel's active boolean array to zero.  By
*		 setting the histogram to zero, none of the other
*		 displays will update those pixels with new values,
*		 until we restore the active states.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*        Output:
*	Returns: The threshold object on success, NULL on failure
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 17, 1992
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_threshold(
   xvobject parent,
   char     *name)
{
	xvobject object;


	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, ThresholdWidgetClass);
	return(object);
}
