 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                PrintMapVal Widget Routines
   >>>>
   >>>>	Private:
   >>>>	 Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			Redisplay()
   >>>>			SetValues()
   >>>>			GetObjectName()
   >>>>			SetObjectName()
   >>>>			ReloadCallback()
   >>>>			PositionCallback()
   >>>>			RedisplayMapVals()
   >>>>  Public:
   >>>>			xvw_create_printmapval()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/PrintMapValP.h>


static void ClassInitialize PROTO((void));
static void Initialize      PROTO((Widget, Widget, ArgList, Cardinal *));
static void Redisplay	    PROTO((Widget, XEvent *, Region));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,
				   Cardinal *));

static int  GetObjectName    PROTO((xvobject, char *, kaddr));
static int  SetObjectName    PROTO((xvobject, char *, kaddr));
static void ReloadCallback   PROTO((kobject, char *, Widget, kdms_callback *));
static void PositionCallback PROTO((kobject, char *, Widget, kdms_callback *));
static void RedisplayMapVals  PROTO((Widget));
static void format_number     PROTO((char *, char *, int));


#undef  kwidget
#define kwidget(widget)      (XvwPrintMapValWidget) (widget)

/*-------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_PRINTMAPVAL_WIDTH,     NULL,    XtRInt,        NULL},
{XVW_PRINTMAPVAL_HEIGHT,    NULL,    XtRInt,        NULL},
{XVW_PRINTMAPVAL_EDITABLE,  NULL,    XtRInt,        XtRBoolean},
{XVW_PRINTMAPVAL_OBJECT,    NULL,    XtRPointer,    NULL},
{XVW_PRINTMAPVAL_SHOWCOLOR, NULL,    XtRInt,        XtRBoolean},
{XVW_PRINTMAPVAL_UPDATEMODE,NULL,    XtRInt,        NULL},
{XVW_PRINTMAPVAL_XPOSITION, NULL,    XtRInt,        NULL},
{XVW_PRINTMAPVAL_YPOSITION, NULL,    XtRInt,        NULL},
{XVW_PRINTMAPVAL_POLICY,    NULL,    XtRInt,        NULL},
};

/*-------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwPrintMapValWidgetRec, printmapval.field)

static XtResource resources[] = { 

{XVW_PRINTMAPVAL_WIDTH, NULL, XtRInt, sizeof(int),
      offset(width), XtRImmediate, (XtPointer) 8},
{XVW_PRINTMAPVAL_HEIGHT, NULL, XtRInt, sizeof(int),
      offset(height), XtRImmediate, (XtPointer) 8},
{XVW_PRINTMAPVAL_EDITABLE, NULL, XtRBoolean, sizeof(Boolean),
      offset(editable), XtRImmediate, (XtPointer) FALSE},
{XVW_PRINTMAPVAL_SHOWCOLOR, NULL, XtRBoolean, sizeof(Boolean),
      offset(showcolor), XtRImmediate, (XtPointer) FALSE},
{XVW_PRINTMAPVAL_OBJECT, NULL, XtRPointer, sizeof(kobject),
      offset(object), XtRImmediate, (XtPointer) NULL},
{XVW_PRINTMAPVAL_UPDATEMODE, NULL, XtRInt, sizeof(int),
      offset(update_mode), XtRImmediate,(XtPointer) KPRINTMAPVAL_UM_CONTINUOUS},
{XVW_PRINTMAPVAL_XPOSITION, NULL, XtRInt, sizeof(int),
      offset(xposition), XtRImmediate, (XtPointer) 0},
{XVW_PRINTMAPVAL_YPOSITION, NULL, XtRInt, sizeof(int),
      offset(yposition), XtRImmediate, (XtPointer) 0},
{XVW_PRINTMAPVAL_POLICY, NULL, XtRInt, sizeof(int),
      offset(policy), XtRImmediate,(XtPointer) KPRINTMAPVAL_DISPLAYEDVALUES},

{NULL, NULL, XtRPixel, sizeof(Pixel),
      offset(black), XtRString, (XtPointer) "black"},
{NULL, NULL, XtRPixel, sizeof(Pixel),
      offset(white), XtRString, (XtPointer) "white"},
};
#undef offset


#define SUPERCLASS (&xvwColorWidgetClassRec)

XvwPrintMapValWidgetClassRec xvwPrintMapValWidgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "PrintMapVal",			/* class_name		  */
    sizeof(XvwPrintMapValWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    XtInheritTranslations,		/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,	            		/* subresources       */
    0,					/* subresources_count */
    sizeof(XvwManagerWidgetConstraintsRec),/* constraint_size    */
    NULL,				/* initialize         */
    NULL,                               /* destroy            */
    NULL,				/* set_values         */
    NULL,                               /* extension          */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,			/* child layout routine  */
    XtInheritChangeSel,		        /* change selected proc   */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritResize,			/* resize		  */
    XtInheritGeometryManager,  		/* geometry_manager	  */
  }, /* XvwManagerWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwGraphicsWidgetClass fields initialization */
  {
    XtInheritColorReload,		/* reload color proc             */
  },  /* XvwColorWidgetClass fields initialization */
  {
    NULL,                               /* field not used    */
  },  /* XvwPrintMapValWidgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwPrintMapValWidgetClass for public consumption
 */
WidgetClass xvwPrintMapValWidgetClass = (WidgetClass) &xvwPrintMapValWidgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of printmapval widget class has been created.
|                It will initialize all the class attributes.
|
|         Input: none 
|
|        Output: none
|
|    Written By: Mark Young 
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwPrintMapValWidgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$XVISUAL/objects/library/xvisual/uis/PrintMapVal.pane");
	xvw_load_resources("$XVISUAL/objects/library/xvisual/app-defaults/PrintMapVal");

	xvw_define_attributes(xvwPrintMapValWidgetClass,
	  XVW_PRINTMAPVAL_FILENAME, XtRString, SetObjectName, GetObjectName,
	  NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial image
|                for an image widget instance.
|
|         Input: request - not used
|                new     - widget instance after initialization, with
|                          initial image
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Mon Jun 29 10:35:11 MDT 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
        XvwPrintMapValWidget xwid = kwidget(new);

	XColor color;
	int    width, height;

	xvw_recompute_charfont(xvw_object(new), &width, &height);
	xwid->printmapval.font_width  = width;
	xwid->printmapval.font_height = height - (int) height * 0.2;

	color.flags = DoRed | DoGreen | DoBlue;

	color.red = color.green = color.blue = 0;
	if (XAllocColor(XtDisplay(new), new->core.colormap, &color) != 0)
	   xwid->printmapval.black = color.pixel;

	color.red = color.green = color.blue = 65535;
	if (XAllocColor(XtDisplay(new), new->core.colormap, &color) != 0)
	   xwid->printmapval.white = color.pixel;
}

/*-----------------------------------------------------------
|
|  Routine Name: Redisplay
|
|       Purpose: This routine calls the RedisplayMapVal procedure when an
|                expose event occurs.
|
|         Input: widget - widget data structure for palette
|		 event	- the event that caused the redraw
|		 region	- the region that was exposed
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Nov 17, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Redisplay(
   Widget widget,
   XEvent *event,
   Region region)
{
	RedisplayMapVals(widget);
	(*xvwPrintMapValWidgetClass->core_class.superclass->core_class.expose)
                (widget, event, region);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: Determine what the widget should do by
|		 comparing the current values verse the
|		 new settings.
|
|         Input: current - the widget containing current settings 
|		 request - the widget containing requested settings
|		 new	 - the widget processed through all set values methods 
|
|        Output: None directly
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/
static double dmin, dmax;

/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwPrintMapValWidget cxwid = kwidget(current);
	XvwPrintMapValWidget nxwid = kwidget(new);

	Boolean redisplay = FALSE;
	int datatype;


	if (cxwid->printmapval.object != nxwid->printmapval.object)
	{
	   nxwid->printmapval.object =
		kpds_reference_object(nxwid->printmapval.object);
	   kpds_close_object(cxwid->printmapval.object);
	   kpds_add_value_callback(nxwid->printmapval.object,
		KPDS_CALLBACK_CHANGE, ReloadCallback, (kaddr) new);
	   kpds_add_value_callback(nxwid->printmapval.object,
                KPDS_CALLBACK_ACCESS, PositionCallback, (kaddr) new);

	   xvw_set_attribute(xvw_object(new), XVW_COLOR_COLOROBJ,
                        nxwid->printmapval.object);

           kpds_get_attribute(nxwid->printmapval.object, 
			      KPDS_VALUE_DATA_TYPE, &datatype);
           if ((datatype == KDOUBLE) || (datatype == KFLOAT))
	   {
               kpds_get_attribute(nxwid->printmapval.object, 
			          KPDS_VALUE_MINMAX, &dmin, &dmax);
#if 0
	       kfprintf(kstderr, "dmin = %g\n", dmin);
	       kfprintf(kstderr, "dmax = %g\n", dmax);
#endif
	   }
	   redisplay = TRUE;
	}

	if (cxwid->printmapval.width  != nxwid->printmapval.width  ||
	    cxwid->printmapval.height != nxwid->printmapval.height)
	{
	   redisplay = TRUE;
	}

	if (cxwid->manager.font != nxwid->manager.font)
	{
	   int width, height;

	   xvw_recompute_charfont(xvw_object(new), &width, &height);
	   nxwid->printmapval.font_width  = width;
	   nxwid->printmapval.font_height = height - (int) height * 0.2;
	   redisplay = TRUE;
	}

	if (cxwid->printmapval.policy != nxwid->printmapval.policy)
        {
	   redisplay = TRUE;
	}

	return(redisplay);
}

/*-----------------------------------------------------------
|
|  Routine Name: GetObjectName
|
|       Purpose: GetObjectName is used to get the filename associated
|		 with the attribute.
|
|         Input: widget    - the widget in which we will be getting the
|			     filename
|		 attribute - the old object to be closed
|
|        Output: calldata  - pointer to retrieve the object name
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int GetObjectName(
   xvobject object,
   char     *attribute,
   kaddr    calldata)
{
	XvwPrintMapValWidget xwid = (XvwPrintMapValWidget) xvw_widget(object);
	String *filename = (String *) calldata;


	if (kstrcmp(attribute, XVW_PRINTMAPVAL_FILENAME) != 0)
	{
	   kerror(XVISUAL, "GetObjectName", "invalid attribute %s",
			attribute);
	   return(FALSE);
	}
	*filename = NULL;
	return(kpds_get_attribute(xwid->printmapval.object,KPDS_NAME,filename));
}


/*-----------------------------------------------------------
|
|  Routine Name: SetObjectName
|
|       Purpose: SetObjectName is used to set the filename associated
|		 with the attribute.
|
|         Input: object    - the object in which we will be getting the
|			     filename
|		 attribute - the old object to be closed
|		 calldata  - the filename to be set
|
|        Output:
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int SetObjectName(
   xvobject printmapval,
   char     *attribute,
   kaddr    calldata)
{
	int	locate = TRUE;
	kobject object = NULL;
	String *filename = (String *) calldata;


	if (*filename != NULL && !(object = kdms_locate(*filename)))
	{
	   locate = FALSE;
	   if (!(object = kpds_open_object(*filename, KOBJ_READ)))
	   {
	      kerror(XVISUAL, "SetObjectName", "Failed to load image '%s'",
			*filename);
	      return(TRUE);
	   }
	}

	if (kstrcmp(attribute, XVW_PRINTMAPVAL_FILENAME) == 0)
	   xvw_set_attribute(printmapval, XVW_PRINTMAPVAL_OBJECT, object);
	else
	{
	   kerror(XVISUAL, "SetObjectName", "invalid attribute %s",
			attribute);
	   if (!locate) kpds_close_object(object);
	   return(FALSE);
	}
	if (!locate) kpds_close_object(object);
	
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ReloadCallback
|
|       Purpose: Reload the mapvals since the data has changed
|
|         Input: xwid - the printmapval widget to load the value data
|        Output: 
|    Written By: Mark Young
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ReloadCallback(
   kobject object,
   char    *segment,
   Widget  widget,
   kdms_callback *cb)
{
	/* perform check to see if we are in the area that's changed */
	RedisplayMapVals(widget);
}

/*-----------------------------------------------------------
|
|  Routine Name: PositionCallback
|
|       Purpose: This re-prints the mapvals of the object being tracked
|
|         Input: xwid - the printmapval widget to load the value data
|        Output: 
|    Written By: Mark Young
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void PositionCallback(
   kobject object,
   char    *segment,
   Widget  widget,
   kdms_callback *cb)
{
	int      w, h, update;
	XvwPrintMapValWidget xwid = (XvwPrintMapValWidget) widget;


	/*
	 *  Make sure we aren't here because of ourself
	 */
	if (object == cb->object)
	   return;

	xvw_get_type(object, NULL, &update);
	if (xwid->printmapval.update_mode == KPRINTMAPVAL_UM_CONTINUOUS &&
	    update != MOTION_EVENT_UPDATE ||
	    xwid->printmapval.update_mode == KPRINTMAPVAL_UM_BUTTON_PRESS &&
	    update != BUTTONPRESS_EVENT_UPDATE)
	    /*update != IMAGE_POSITION_UPDATE)*/
	{
	   return;
	}

	w = (cb->end.w - cb->begin.w)/2 + cb->begin.w;
	h = (cb->end.h - cb->begin.h)/2 + cb->begin.h;
	xwid->printmapval.xposition = w - xwid->printmapval.width/2;
	xwid->printmapval.yposition = h - xwid->printmapval.height/2;
	RedisplayMapVals(widget);
}
 
/*-----------------------------------------------------------
|
|  Routine Name: RedisplayMapVals - create and relayout the mapvals
|
|       Purpose: create and relayout the mapvals being displayed.
|
|         Input: widget - the printmapval widget to create the mapvals for
|        Output: 
|       Returns: 
|    Written By: Mark Young & Danielle Argiro
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void RedisplayMapVals(
   Widget widget)
{
	XvwPrintMapValWidget xwid = kwidget(widget);
	xvobject printmapval = xvw_object(widget);
	XColor   *xcolors = ColorGetXColors(widget);

	unsigned char *maskdata = NULL;
	float    *mapdata = NULL;
	int	 i, y, xpos, ypos, indx, length, map_available = TRUE; 
	int      val_datatype, mapwidth, mapheight, map_datatype;
	Pixel	 background, foreground;
	double   *data; 
	double   light, val1, val3;
	char     orig[KLENGTH], temp1[KLENGTH], temp2[KLENGTH], temp3[KLENGTH];
	char     scale[KLENGTH];

	GC	 gc           = xwid->manager.gc;
	Window   window       = XtWindow(widget);
	Display  *display     = XtDisplay(widget);
	kobject  object       = xwid->printmapval.object;
	int      xposition    = xwid->printmapval.xposition;
	int      yposition    = xwid->printmapval.yposition;
	int      width        = xwid->printmapval.width;
	int      height       = xwid->printmapval.height;
	int      font_width   = xwid->printmapval.font_width;
	int      font_height  = xwid->printmapval.font_height;
	int      policy       = xwid->printmapval.policy;


	/*
	 *  if it's not visible, no sense in redisplaying it.
	 */
	if (!xvw_check_visible(xvw_object(widget)) || object == NULL)
	   return;

	
	map_available = xwid->color.info->initialized;
	if (!map_available)
	    XClearArea(display, window, 0, 0, 0, 0, FALSE);

	/*
	 *  get the data type of the value data
	 */
	kpds_get_attribute(object, KPDS_VALUE_DATA_TYPE, &val_datatype);

	/*
	 *  set the printmapval object to reflect the map values indexed
         *  by the pixel at the location of the pointer in the image
	 */
	kpds_set_attributes(object,
		KPDS_VALUE_POSITION,    xposition, yposition, 0, 0, 0,
		KPDS_VALUE_DATA_TYPE,   KDOUBLE,
		KPDS_VALUE_REGION_SIZE, width, height, 1, 1, 1,
		NULL);

	/*
	 *  get the value data at that location, for use in indexing into maps
	 */
	if (!(data = kpds_get_data(object, KPDS_VALUE_REGION, NULL)))
        {
           kerror(XVISUAL, "RedisplayMapVals", "Unable to get image mapvals");
           return;
        }

	/*
	 *  if there is a mask, will want to reflect which values are
	 *  valid in the printmapval display
	 */
        if (kpds_query_mask(object) == TRUE)
	{
	   kpds_set_attributes(object,
		KPDS_MASK_POSITION,    xposition, yposition, 0, 0, 0,
		KPDS_MASK_DATA_TYPE,   KUBYTE,
		KPDS_MASK_REGION_SIZE, width, height, 1, 1, 1,
		NULL);
	   maskdata = kpds_get_data(object, KPDS_MASK_REGION, NULL);
	}

	/*
	 *  ------ for printing actual values in map segment -------
	 *  Long nasty procedure in order to make the printmapval display look
         *  good, regardless of the data type of the maps.  In other words, 
	 *  want a small, 4-character string printed for each value of a byte
 	 *  map, while at the same time being able to support a larger, 8-char
         *  display w/ three significant digits for float displays (and all the
         *  others in between).
	 */
	if (policy == KPRINTMAPVAL_MAPDATAVALUES)
        {
	    /* get width, height, and data type of maps */
	    kpds_get_attributes(object, 
		KPDS_MAP_SIZE,      &mapwidth, &mapheight, NULL, NULL, NULL,
		KPDS_MAP_DATA_TYPE, &map_datatype,
		NULL);

	    /* set position, region size & data type in prep. for reading map */
            kpds_set_attributes(object,
                   KPDS_MAP_POSITION,     0, 0, 0, 0, 0,
                   KPDS_MAP_DATA_TYPE,    KFLOAT,
                   KPDS_MAP_REGION_SIZE,  mapwidth, mapheight, 1, 1, 1,
                   NULL);

	    /* go ahead and read in the whole map at once */
            mapdata = kpds_get_data(object, KPDS_MAP_REGION, NULL);

	    /* depending on data type of map, format for strings differs */
	    switch (map_datatype)
	    { 
 		case KBIT:
 		case KBYTE:
 		case KUBYTE:
	             length = 4;
		     ksprintf(scale, "%%g");
		     break;

 		case KSHORT:
 		case KINT:
	             length = 6;
		     ksprintf(scale, "%%d");
		     break;

 		case KFLOAT:
	             length = 8;
		     ksprintf(scale, "%%.3f");
		     break;

		default:
		     break;
	    }
	  	
	    /* restore data type of map so we can do this again, next time */
	    kpds_set_attribute(object, KPDS_MAP_DATA_TYPE, map_datatype);
	}

	/*	
	 *  ------ for printing normalized values from xcolor array -------
	 *  If no map is available, we will simply print the RGB values that
	 *  were used to produce the colors in which pixels are displayed 
	 */
	else 
	{
	    length = 4;
	    ksprintf(scale, "%%3d");
	}

	
	xpos = 3;
	ypos = font_height;
	
	/*
	 *  Print labels in front of each of the three display components 
	 *  according to whether actual map data values are being displayed
	 *  or whether RGB values are being displayed
	 */
	if (policy == KPRINTMAPVAL_MAPDATAVALUES)
        {
	    ksprintf(temp1, "Actual Map Values Defining Red:");
	    ksprintf(temp2, "Actual Map Values Defining Green:");
	    ksprintf(temp3, "Actual Map Values Defining Blue:");
	}
	else
	{
	    ksprintf(temp1, "Red Components of Displayed Pixels:");
	    ksprintf(temp2, "Green Components of Displayed Pixels:");
	    ksprintf(temp3, "Blue Components of Displayed Pixels:");
	}
	foreground = xwid->printmapval.black;
	background = xwid->printmapval.white;
        XSetForeground(display, gc, foreground);
        XSetBackground(display, gc, background);
	y = ypos + (height*font_height + 6)*0;
	XDrawImageString(display, window, gc, xpos+10, y, 
			 temp1, kstrlen(temp1));
	y = ypos + (height*font_height + 6)*1 + font_height;
	XDrawImageString(display, window, gc, xpos+10, y, 
			 temp2, kstrlen(temp2));
	y = ypos + (height*font_height + 6)*2 + 2*font_height;
	XDrawImageString(display, window, gc, xpos+10, y, 
			 temp3, kstrlen(temp3));
	    
	/*
	 *  Protect against situation w/ RGB images where there is no map data. 
         *  Simply print strings indicating lack, but don't attempt to 
         *  print actual map values
	 */
	if (!map_available)
	{
	    y = ypos + (height*font_height + 6)*0.25;
	    ksprintf(temp1, "No map data available");
            XDrawImageString(display, window, gc, xpos+15, y, 
			    temp1, kstrlen(temp1));
	    y = ypos + (height*font_height + 6)*1.5;
	    ksprintf(temp1, "No map data available");
            XDrawImageString(display, window, gc, xpos+15, y, 
			    temp1, kstrlen(temp1));
	    y = ypos + (height*font_height + 6)*2.5;
	    ksprintf(temp1, "No map data available");
            XDrawImageString(display, window, gc, xpos+15, y, 
			    temp1, kstrlen(temp1));

	    kpds_set_attribute(object, KPDS_VALUE_DATA_TYPE, val_datatype);
            kfree(data);
            kfree(mapdata);
            kfree(maskdata);
	    return;
	}

	/*
	 *  Here is the actual procedure for updating each of the labels
	 *  displaying the map data indexed by each pixel value.  Doing
	 *  the R, G, and B labels for each pixel value at the same time.
	 */
	for (i = 0; i < width*height; i++, xpos += length*font_width)
	{
	   /*
	    *  increment location in display to left side after each row
	    */
	   if ((i % width) == 0 && i != 0)
	   {
	      xpos = 3;
	      ypos += font_height;
	   }

	   /*
	    *  for value data types of float and double, have to normalize
	    *  value in order to index into the map
	    */
	    if ((val_datatype == KDOUBLE) || (val_datatype == KFLOAT))
	        indx = (int) (data[i] - dmin)*(255.0/(dmax-dmin));
	    else indx = (int) data[i];
	
	   /*
	    *  ------ for printing actual values in map segment -------
	    * format map values for map columns 0, 1, and 2.  to really
	    * be correct, this needs to be changed to whatever map columns
	    * may be displayed as R, G, and B.
	    */
	   if (policy == KPRINTMAPVAL_MAPDATAVALUES)
           {
	       ksprintf(orig, scale, mapdata[indx*mapwidth+0]);
	       format_number(orig, temp1, length);
               ksprintf(orig, scale, mapdata[indx*mapwidth+1]);
	       format_number(orig, temp2, length);
               ksprintf(orig, scale, mapdata[indx*mapwidth+2]);
	       format_number(orig, temp3, length);
           }

	   /*
	    * ---- for printing normalized values from xcolor array -----
	    * format direct R,G,B values currently being used in the
	    * xcolors array to create the color in which the pixel is 
	    * displayed.
	    */
	   else
	   {
	       ksprintf(orig, scale, xcolors[indx].red >> 8);
	       format_number(orig, temp1, length);
	       ksprintf(orig, scale, xcolors[indx].green >> 8);
	       format_number(orig, temp2, length);
	       ksprintf(orig, scale, xcolors[indx].blue >> 8);
	       format_number(orig, temp3, length);
	   }

	   /*
	    * if there is mask data associated with the value data,
	    * and the mask data indicates invalid data at a particular
	    * point, simply don't display a value in that area.
	    */
	   if (maskdata != NULL && maskdata[i] == 0)
	   {
	      y = ypos + (height*font_height + 6)*0 - font_height;
	      XClearArea(display, window, xpos, y, 
		         length*font_width, font_height, FALSE);

	      y = ypos + (height*font_height + 6)*1 - font_height;
	      XClearArea(display, window, xpos, y, 
			 length*font_width, font_height, FALSE);

	      y = ypos + (height*font_height + 6)*2 - font_height;
	      XClearArea(display, window, xpos, y, 
			 length*font_width, font_height, FALSE);
	      continue;
	   }

	   /*
	    * if we are showing the color in which the pixel appears as
	    * the background color for that value in the display, need
	    * to determine what that color is, set the background color
	    * accordingly, and use XDrawImageString() to display the value
	    */
	   if (xwid->printmapval.showcolor)
	   {

	      RGB_to_HLS(xcolors[indx], val1, light, val3);
	      if (light >= 0.45)
		 foreground = xwid->printmapval.black;
	      else
		 foreground = xwid->printmapval.white;

	      background = ColorAllocate(widget, indx);
	      XSetBackground(display, gc, background);
	      XSetForeground(display, gc, foreground);
	      y = ypos + (height*font_height + 6)*0 + font_height;
              XDrawImageString(display, window, gc, xpos, y, temp1, length+1);
	      y = ypos + (height*font_height + 6)*1 + 2*font_height;
              XDrawImageString(display, window, gc, xpos, y, temp2, length+1);
	      y = ypos + (height*font_height + 6)*2 + 3*font_height;
              XDrawImageString(display, window, gc, xpos, y, temp3, length+1);
	   }

	   /*
	    * if we are *not* showing the color in which the pixel appears
	    * just use XDrawImageString() to display the value
	    */
	   else
	   {
	      y = ypos + (height*font_height + 6)*0 + font_height;
              XDrawImageString(display, window, gc, xpos, y, temp1, length+1);
	      y = ypos + (height*font_height + 6)*1 + 2*font_height;
              XDrawImageString(display, window, gc, xpos, y, temp2, length+1);
	      y = ypos + (height*font_height + 6)*2 + 3*font_height;
              XDrawImageString(display, window, gc, xpos, y, temp3, length+1);
	   }
	}

	/*
	 *  restore the data type of the value data
	 */
	kpds_set_attribute(object, KPDS_VALUE_DATA_TYPE, val_datatype);

	/*
	 * cleanup 
	 */
	kfree(data);
	kfree(mapdata);
	kfree(maskdata);
}

static void format_number(
    char *orig,
    char *formatted,
    int  length)
{
	int i;

	if (kstrlen(orig) < length)
	{
            i = 0;
            while (i < length - kstrlen(orig))
            {
		formatted[i] = ' '; 
                i++;
            }
            ksprintf(&formatted[i], "%s ", orig);
        }
}


/************************************************************
*
*  Routine Name: xvw_create_printmapval - create a printmapval xvobject
*
*       Purpose: A printmapval object provides a mechanism which will track 
*                pointer movement in an image object and print the values of 
*                the map data indexed by the pixel under the pointer.
*                It was designed for use in conjunction with an image object,
*                and is only useful with data objects having a map segment.  
*
*                The printmapval object is made up of one or more 
*                (width x height) sets of label objects;  typically, there 
*                will be three such sets, one each for the Red, Green, and 
*                Blue columns of the colormap.  The background of each label 
*                is the color defined by the values of the map columns at that 
*                pixel, and the value displayed is the value of the 
*                corresponding map column.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: None
*
*	Returns: The printmapval xvobject on success, NULL otherwise
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 17, 1993
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_printmapval(
   xvobject parent,
   char     *name)
{
	xvobject object;


	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, PrintMapValWidgetClass);
	return(object);
}


