 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                 Position Gadget Routines
   >>>>
   >>>>	Private:
   >>>>	 Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			SetValues()
   >>>>			PositionCallback()
   >>>>			PositionGetName()
   >>>>			PositionSetName()
   >>>>   Public:
   >>>>			xvw_create_position()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvisual/PositionP.h>

static void ClassInitialize PROTO((void));
static void Initialize	    PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,
				   Cardinal *));
static void PositionCallback PROTO((kobject, char *, Widget, kdms_callback *));
static int  PositionGetName  PROTO((xvobject, char *, kaddr));
static int  PositionSetName  PROTO((xvobject, char *, kaddr));



/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_POSITION_OBJECT,       NULL,    XtRPointer,    NULL},
{XVW_POSITION_SHOW_VALUE,   NULL,    XtRInt,	    XtRBoolean},
{XVW_POSITION_UPDATEMODE,   NULL,    XtRInt,	    NULL},
};



/*--------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwPositionGadgetRec, position.field)

static XtResource resources[] = {
{XVW_POSITION_OBJECT, NULL, XtRPointer, sizeof(kobject),
      offset(object), XtRImmediate, (XtPointer) NULL},
{XVW_POSITION_SHOW_VALUE, NULL, XtRBoolean, sizeof(Boolean),
      offset(show_value), XtRImmediate, (XtPointer) TRUE},
{XVW_POSITION_UPDATEMODE, NULL, XtRInt, sizeof(int),
      offset(update_mode), XtRImmediate, 
      (XtPointer) KPOSITION_UM_CONTINUOUS},

{XVW_STRING_JUSTIFICATION, NULL, XtRInt, sizeof(int), 
      XtOffsetOf(XvwPositionGadgetRec, string.justification),
      XtRImmediate, (XtPointer) KSTRING_JUSTIFY_CENTER},
{XVW_FORCE_REDISPLAY, NULL, XtRBoolean, sizeof(Boolean),
      XtOffsetOf(XvwPositionGadgetRec, manager.force_redisplay),
      XtRImmediate, (XtPointer) FALSE},
};
#undef offset

#define SUPERCLASS (&xvwStringGadgetClassRec)

XvwPositionGadgetClassRec xvwPositionGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Position",			        /* class_name		  */
    sizeof(XvwPositionGadgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    NULL,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    XtInheritPicking,			/* pick object proc       */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritChangeGeometry,		/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    XtInheritRecomputePosition,		/* recompute position proc    */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwStringGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwPositionGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwPositionGadgetClass for public consumption
 */
WidgetClass xvwPositionGadgetClass = (WidgetClass) &xvwPositionGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of position object class has been created.
|                It will initialize all the class attributes. 
|
|         Input:
|        Output:
|
|    Written By: Mark Young
|          Date: Nov 17, 1992 10:22
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwPositionGadgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/Position.pane");
	xvw_define_attributes(xvwPositionGadgetClass,
            XVW_POSITION_FILENAME, XtRString, PositionSetName, PositionGetName,
            NULL);

	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Position");
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial position value
|                instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|
|	 Output: None
|
|    Written By: Mark Young
|          Date: May 26, 1993 13:28
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwPositionGadget xobj = (XvwPositionGadget) new;


	xobj->position.rgb = xobj->position.complex = FALSE;
	xvw_set_attribute(xvw_object(new), XVW_STRING_STRING, "(-1  x  -1)");
}


/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public fields
|                of a position object instance.
|                 
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output:
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 17, 1992 10:24
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwPositionGadget cobj = (XvwPositionGadget) current;
	XvwPositionGadget nobj = (XvwPositionGadget) new;

	int e, type;

	if (cobj->position.object != nobj->position.object)
	{
	   nobj->position.object = kpds_reference_object(nobj->position.object);
	   kpds_close_object(cobj->position.object);
	   kpds_add_value_callback(nobj->position.object,
		     KPDS_CALLBACK_ACCESS, PositionCallback, (kaddr) new);

	   /*
	    *  Change the object to use data type of double and then .
	    */
	   kpds_get_attributes(nobj->position.object,
			KPDS_VALUE_SIZE, NULL, NULL, NULL, NULL, &e,
			KPDS_VALUE_DATA_TYPE, &type,
			NULL);

	   nobj->position.rgb = (e == 3 || e == 4);
	   if (nobj->position.complex = (type == KCOMPLEX || type == KDCOMPLEX))
	      type = KDCOMPLEX;
	   else
	      type = KDOUBLE;

	   kpds_set_attributes(nobj->position.object,
			KPDS_VALUE_DATA_TYPE, type, 
			KPDS_VALUE_SCALING, KNONE,
	   		KPDS_MASK_DATA_TYPE,  KUBYTE,
			NULL);
	}
	return(FALSE);
}


/*-----------------------------------------------------------
|
|  Routine Name: PositionCallback
|
|       Purpose: This prints the position of the object being tracked
|                 
|         Input: 
|        Output:
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 17, 1992 10:24
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void PositionCallback(
   kobject object,
   char    *segment,
   Widget  widget,
   kdms_callback *cb)
{
	unsigned  char mval;
	double    dval,  dvect[4];
	kdcomplex dcval, dcvect[4];
	int       w, h, d, t, e, update;
	char      temp[KLENGTH], location[KLENGTH];
	XvwPositionGadget xobj = (XvwPositionGadget) widget;
	int	  show_value = xobj->position.show_value;


	/*
	 *  Make sure we aren't here because of ourself
	 */
	if (object == cb->object)
	   return;

	xvw_get_type(object, NULL, &update);
	if (xobj->position.update_mode == KPOSITION_UM_CONTINUOUS &&
	    update != MOTION_EVENT_UPDATE ||
	    xobj->position.update_mode == KPOSITION_UM_BUTTON_PRESS &&
	    update != BUTTONPRESS_EVENT_UPDATE)
	    /*update != IMAGE_POSITION_UPDATE)*/
	{
	   return;
	}

	w = (cb->end.w - cb->begin.w)/2 + cb->begin.w;
	h = (cb->end.h - cb->begin.h)/2 + cb->begin.h;
	d = cb->begin.d; t = cb->begin.t; e = cb->begin.e;

        if (kpds_query_mask(cb->object) == TRUE)
	{
	   kpds_set_attribute(cb->object, KPDS_MASK_POSITION, w, h, d, t, e);
	   if (kpds_get_data(cb->object, KPDS_MASK_POINT, &mval) != NULL)
	      show_value = mval;
	}

	if (show_value)
	{
	   kpds_set_attribute(cb->object, KPDS_VALUE_POSITION, w, h, d, t, e);
	   if (xobj->position.complex == FALSE)
	   {
	      if (xobj->position.rgb == FALSE)
	      {
	         if (kpds_get_data(cb->object, KPDS_VALUE_POINT, &dval) != NULL)
	            (void) ksprintf(temp, "(%4d x %4d = %4g )", w, h, dval);
	      }
	      else
	      {
	         if (kpds_get_data(cb->object,KPDS_VALUE_VECTOR, dvect)!= NULL)
	         {
	            (void) ksprintf(temp, "(%4d x %4d = %4g %4g %4g )", w, h,
				     dvect[0],  dvect[1],  dvect[2]);
	         }
	      }
	   }
	   else
	   {
	      if (xobj->position.rgb == FALSE)
	      {
	         if (kpds_get_data(cb->object,KPDS_VALUE_POINT, &dcval) != NULL)
		 {
	            ksprintf(temp, "(%4d x %4d = %4g %cj%1g)", w, h,
			dcval.r, dcval.i < 0.0 ? '-' : '+', kabs(dcval.i));
		 }
	      }
	      else
	      {
	         if (kpds_get_data(cb->object,KPDS_VALUE_VECTOR,dcvect) != NULL)
	         {
	            ksprintf(temp, "%4d x %4d = %4g %cj%1g\n            = %4g %cj%1g\n            = %4g %cj%1g\n", w, h,
	         dcvect[0].r, dcvect[0].i < 0.0 ? '-' : '+', kabs(dcvect[0].i),
	         dcvect[1].r, dcvect[1].i < 0.0 ? '-' : '+', kabs(dcvect[1].i),
	         dcvect[2].r, dcvect[2].i < 0.0 ? '-' : '+', kabs(dcvect[2].i));
	         }
	      }
	   }
	}
	else
	{
	   (void) ksprintf(temp, "(%4d x %4d)", w, h);
	}

	if (kpds_query_location(cb->object) == TRUE)
	{
	   kpds_set_attributes(cb->object,
		KPDS_LOCATION_POSITION, w, h, d, 0,
		KPDS_LOCATION_DATA_TYPE, KDOUBLE,
		NULL);
	   if (kpds_get_data(cb->object, KPDS_LOCATION_VECTOR, dvect) != NULL)
	   {
	      ksprintf(location,"  (%g x %g)", dvect[0], dvect[1]);
	      kstrcat(temp, location);
	   }
	}
	xvw_set_attribute(xvw_object(widget), XVW_STRING_STRING, temp);
}



/*-----------------------------------------------------------
|
|  Routine Name: PositionGetName
|
|       Purpose: PositionGetName is used to get the filename associated
|		 with the position object.
|
|         Input: object    - the position object
|                attribute - XVW_POSITION_FILENAME
|        Output: calldata  - returns the filename
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young & Danielle Argiro
|          Date: Dec 20, 1994 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int PositionGetName(
   xvobject object,
   char     *attribute,
   kaddr    calldata)
{
	kobject position;
	XvwPositionGadget xwid = (XvwPositionGadget) xvw_widget(object);
	String *filename = (String *) calldata;

        position = xwid->position.object;
	*filename = NULL;
	return(kpds_get_attribute(position, KPDS_NAME, filename));
}

/*-----------------------------------------------------------
|
|  Routine Name: PositionSetName
|
|       Purpose: PositionSetName is used to set the filename associated
|		 with the position object.
|
|         Input: object    - the position object
|		 attribute - XVW_POSITION_FILENAME
|		 calldata  - passes in the filename to be set
|        Output:
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young & Danielle Argiro
|          Date: Dec 20, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int PositionSetName(
   xvobject object,
   char     *attribute,
   kaddr    calldata)
{
	int	locate = TRUE;
	kobject out, position = NULL;
	XvwPositionGadget xwid = (XvwPositionGadget) xvw_widget(object);
	String *filename = (String *) calldata;

	if (*filename != NULL && (position = kdms_locate(*filename)) == NULL)
	{
	   locate = FALSE;
	   if ((position = kpds_open_object(*filename, KOBJ_READ)) == NULL)
	   {
	      kerror(XVISUAL, "PositionSetName", "Failed to load position '%s'",
		     *filename);
	      return(TRUE);
	   }
	}

	xvw_set_attribute(object, XVW_POSITION_OBJECT, position);
	if (!locate) kpds_close_object(position);
	
	return(TRUE);
}

/************************************************************
*
*  Routine Name: xvw_create_position - create a position object
*
*       Purpose: A position object is used to track movement of the 
*                pointer in an image object; thus, it was designed to be used 
*                in conjunction with an image object.  
*
*                The position object displays values in an (X x Y) or 
*                (X x Y = Z) format, where X and Y display the location
*                of the pointer in the image object, and the optional Z 
*                is the pixel value of the image at that location. When
*                the latter format is used with an RGB image, the format
*                is modified to be ( X x Y = R G B).
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: 
*	Returns: The position object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young 
*          Date: Nov 17, 1992 11:35
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_position(
   xvobject parent,
   char   *name)
{
	xvobject  object;

	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, PositionGadgetClass);
	return(object);
}
