/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>                                                       <<<<
   >>>>		       Grouping Routines                      <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>                xvf_call_do_group()                    <<<<
   >>>>                xvf_do_group()                         <<<<
   >>>>                xvf_set_group_selection()              <<<<
   >>>>   Static:                                             <<<<
   >>>>                set_toggle_groupmember_sensitivity()   <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#include "internals.h"


static void 
set_toggle_groupmember_sensitivity PROTO((kselection *));


/*-----------------------------------------------------------
|
|  Routine Name: xvf_call_do_group
|
|       Purpose: Calls the xvf_do_group() routine with the correct
|                value for the 'uplevel_status' parameter based on
|                the type of group that the selection belongs to.
|
|         Input: selection - the group member
|        Output: none
|          Date: Jun 09, 1992
|    Written By: Danielle Argiro
| Modifications:
|
-----------------------------------------------------------*/
void xvf_call_do_group(
    kselection *selection)
{
        kselection *start_group;

        start_group = selection->back_group;
        while (start_group->back_group != NULL)
            start_group = start_group->back_group;

        if (start_group->type == KUIS_MUTEXCL)
            (void) xvf_do_group(start_group, selection,
                                0, start_group->selected);
        else (void) xvf_do_group(start_group, selection, 0, FALSE);
}


/*-----------------------------------------------------------
|
|  Routine Name: xvf_do_group
|
|       Purpose: This is the subroutine for each of the buttons that make
|                up a mutually exclusive or mutually inclusive group.
|
|         Input: start_group - the beginning of the group (-C or -B selection)
|                selection   - member of the ME/MI group just clicked on
|                uplevel_status - status of UPPER LEVEL group, one of: 
|                                 NO_UPPER, ME_ON, ME_OFF, MI_ON, MI_OFF
|                required    - TRUE if group as a whole is required, 
|                              FALSE otherwise
|        Output: none
|          Date: Jun 09, 1992
|    Written By: Danielle Argiro
| Modifications:
|
-----------------------------------------------------------*/

int xvf_do_group(
   kselection *start_group,
   kselection *selection,
   int        uplevel_status,
   int        required)
{
	if (!(kvf_do_group(start_group, selection, !(selection->opt_selected),
		           uplevel_status, required, xvf_set_group_selection)))
	    return(FALSE);

	set_toggle_groupmember_sensitivity(start_group);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: xvf_set_group_selection
|
|       Purpose: This routine sets a selection to selected or
|                non-selected, depending on the value passed in.
|
|         Input: selection   - the selection to set
|                value       - value to set it to
|        Output: none
|          Date: Jun 10, 1992 
|    Written By: Danielle Argiro
| Modifications:
|
-----------------------------------------------------------*/
void xvf_set_group_selection(
   kselection *selection,
   int        value)
{
	Line_Info line_info;
	kselection *save_back_group;

	save_back_group = selection->back_group;
	selection->back_group = NULL;
	xvf_set_attribute(selection->back_kformstruct, XVF_OPTSEL, value);
	selection->back_group = save_back_group;


	if (line_info.live == TRUE)  
	{
	    xvf_update_form_tree(selection);
	    xvf_collect_check_data(selection->back_form); 
	    if (line_info.typeflag == KUIS_LOGICAL) 
	    {
		xvf_current_subform = selection->back_subform;
		xvf_current_form = selection->back_form;
		xvf_run_done(TRUE); 
	    }
	}

}

/*
 *  set toggles w/in ME group (if any)
 */
static void set_toggle_groupmember_sensitivity(
    kselection *group_start)
{
	kselection *groupmember;
        groupmember = group_start->group_next;
        while (groupmember != NULL)
        {
            if (groupmember->type == KUIS_TOGGLE)
                xvf_set_toggle_optional_sensitivity(groupmember);

	    else if ((groupmember->type == KUIS_MUTEXCL) ||
		     (groupmember->type == KUIS_MUTINCL) ||
		     (groupmember->type == KUIS_GROUP))
		set_toggle_groupmember_sensitivity(groupmember);

            groupmember = groupmember->next;
        }
}
