/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>		       Form Geometry Routines                 <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>                xvf_form_geometry()                    <<<<
   >>>>                xvf_subform_geometry()                 <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/*-----------------------------------------------------------
|
|  Routine Name: xvf_form_geometry
|
|	Purpose: Returns the location, width & height of a currently mapped
|                form in device coordinates.  
|
|	  Input: form   - the form to be inquired
|		 x, y   - the form's x and y position.
|		 width  - the form's width
|		 height - the form's height
|
|    Written By: Mark Young
|          Date: May 15, 1992
| Modifications: Updated from Khoros 1.0 (DA)
|
------------------------------------------------------------*/

void xvf_form_geometry(
   kform *form,
   int   *x,
   int   *y,
   int   *width,
   int   *height)
{
	xvobject	 object;
	Position xpos, ypos;
	XWindowAttributes  xwa;


	if (form->master != NULL)
	{
	   object = form->toplevel;
	   XtTranslateCoords(xvw_widget(object), 0, 0, &xpos, &ypos);
	   XGetWindowAttributes(xvw_display(object), xvw_window(object), &xwa);

	   *x = xpos - xwa.border_width;
	   *y = ypos - xwa.border_width;
	}
	else
	{
	    errno = KWIDGET_QUERY;
            kerror("xvforms", "xvf_form_geometry", 
	       "Unable to get form geometry.  Master form toplevel is NULL");
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: xvf_subform_geometry
|
|	Purpose: Returns the location, width & height of a currently mapped
|                subform in device coordinates.  
|
|	  Input: subform - the subform to be inquired
|		 x, y    - the subform's x and y position.
|		 width   - the subform's width
|		 height  - the subform's height
|
|    Written By: Mark Young
|          Date: May 15, 1992
| Modifications: Updated from Khoros 1.0 (DA)
|
------------------------------------------------------------------*/

void xvf_subform_geometry(
   ksubform *subform,
   int      *x,
   int      *y,
   int      *width,
   int      *height)
{
	xvobject	 object;
	Position xpos, ypos;
	XWindowAttributes  xwa;


	if (subform->toplevel != NULL)
	{
	   object = subform->toplevel;
	   XtTranslateCoords(xvw_widget(object), 0, 0, &xpos, &ypos);
	   XGetWindowAttributes(xvw_display(object), xvw_window(object), &xwa);

	   *x = xpos - xwa.border_width;
	   *y = ypos - xwa.border_width;
	}
	else
	{
	    errno = KWIDGET_QUERY;
            kerror("xvforms", "xvf_subform_geometry", 
	           "Unable to get subform geometry. Subform toplevel is NULL");
	}
}
