/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>		 GUI Item Attribute Change Callback Routines  <<<<
   >>>>  Private:					      <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:	xvf_add_extra_call()	              <<<<
   >>>>		        xvf_remove_extra_call()	              <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


static int  call_count = 0; 

/************************************************************
*
*  Routine Name: xvf_add_gui_callback - add callback to a GUI item
*
*       Purpose: This function adds a callback to a GUI item that will 
*                be called if an attribute of the GUI item itself is 
*                changed. 
*
*         Input: kformstruct - kform_struct associated with the GUI item,
*			       to which the callback is to be added.
*			       Note that all candidates for this argument
*                              will be found in the GUI Information structure,
*                              which is automatically generated in the 
*                              "form_info.h" file.
*
*                attribute   - the xvforms attribute on which to fire the
*                              callback.  For all GUI item attribute changes,
*                              provide, "xvf_all_attributes".
*
*		 routine     - The callback routine to fire. This routine MUST
*                              be declared as follows:
*
*                                ! void routine(kform_struct kformstuct,
*                                !              char  *attribute,
*                                !              kaddr attr_value,
*                                !              kaddr client_data)
*
*		 client_data   - Client data with which to call extra routine.
*                                The client_data pointer is used when it is 
*                                necessary to pass arguments to a callback 
*                                routine.  First, define a single structure 
*                                containing all the parameters needed. Declare
*                                a pointer to the structure, dynamically 
*                                allocate the pointer, and initialize all the 
*                                fields with the values that you would have 
*                                given to the parameters before passing them to 
*                                the routine in a normal call.  Pass the pointer
*                                to your allocated, initialized structure to 
*                                xvf_add_extra_call() as the client_data.  
*                                Inside the callback, cast the client_data to 
*                                the appropriate structure type, as in:
*                              ! my_struct *my_ptr = (my_struct *) client_data;
*                                At that point, the fields may be accessed as
*                                desired.  They will hold the values to which
*                                they were initialized.
*        Output: none
*
*       Returns: TRUE on success, FALSE on failure
*
*  Restrictions: 
*    Written By: Danielle Argiro 
*          Date: June 14, 1993 
*      Verified:
*  Side Effects:
* Modifications: 
* Declaration: int xvf_add_gui_callback(
*			kform_struct *kformstruct,
*			char         *attribute,
*			kfunc_void   routine,
*			kaddr        client_data)
*
*************************************************************/

int xvf_add_gui_callback(
   kform_struct *kformstruct,
   char         *attribute,
   kfunc_void   routine,
   kaddr        client_data)
{
	int attribute_token;
	xvf_callback_info *call_info;

	call_info = (xvf_callback_info *) 
		     kcalloc(1, sizeof(xvf_callback_info));
	if (call_info == NULL)
	{
	    kerror("xvforms", "xvf_add_gui_callback",
		   "Unable to allocate callback list");
	    return(FALSE);
	}

	call_info->routine        = routine;
	call_info->client_data    = client_data;
	call_count++;

	attribute_token = kstring_to_token(attribute);

	kformstruct->callback_list = 
		klist_insert(kformstruct->callback_list,
                             (kaddr) attribute_token, (kaddr) call_info,
                             KLIST_NEXT, TRUE);

	if (kformstruct->callback_list != NULL)
                     return(TRUE);
        else return(FALSE);

}

/************************************************************
*
*  Routine Name: xvf_remove_gui_callback - remove callback from GUI item
*
*       Purpose: This function removes a callback from a GUI item that was 
*                being called when an attribute of the GUI item was changed.
*
*         Input: kformstruct   - kform_struct associated with the GUI item,
*			         from which the callback is to be removed
*                                (passed to xvf_add_gui_callback earlier).
*                attribute     - the xvforms attribute on which the callback
*                                was fired.  For all GUI item attribute changes,
*                                provide, "xvf_all_attributes".
*		 routine       - The extra routine that was being called
*                                (passed to xvf_add_gui_callback earlier).
*		 client_data   - Client data with which routine was called
*                                (passed to xvf_add_gui_callback earlier).
*
*        Output: none
*
*       Returns: TRUE on success, FALSE on failure
*
*  Restrictions: This routine should only be used for callbacks that were
*                added earlier to GUI items with a call to xvf_add_gui_callback.
*
*    Written By: Danielle Argiro 
*          Date: June 14, 1993
*      Verified:
*  Side Effects:
* Modifications: 
*
*************************************************************/

/* ARGSUSED */
int xvf_remove_gui_callback(
   kform_struct *kformstruct,
   char         *attribute,
   kfunc_void   routine,
   kaddr        client_data)
{
	int attribute_token;
	
	attribute_token = kstring_to_token(attribute);

	kformstruct->callback_list = 
			klist_delete(kformstruct->callback_list, 
			             (kaddr) attribute_token);
	return(TRUE);
}
