/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	List Utilities for MultiList & ScrolledList Widgets
   >>>> 
   >>>>	Private: 
   >>>>	Static: 
   >>>>	Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#ifdef KATHENA_DEF


/*
 *	Like DrawString, except it takes an additional  "tabs"
 *	argument, used to specify what horizontal pixel position to
 *	move to when tab characters are present in the string.  If
 *	the "tabs" argument is NULL, works exactly like its
 *	counterpart.
 */
void
XfwfDrawString(display, drawable, gc, x, y, string, length, tabs)
     Display *display;
     Drawable drawable;
     GC gc;
     int x;
     int y;
     String string;
     int length;
     int *tabs;
{
	register char	*p, *ep;
	register int	tx, tab;

	tab = tx = 0;
	for (p = string; length; )
	{
		ep = kstrchr(p, '\t'/*, length*/);
		if (ep && tabs)
		{
			XDrawString(display, drawable, gc, x+tx, y,
				p, ep - p);
			tx = tabs[tab++];
			length -= ep - p + 1;
			p = ep + 1;
		}
		else
		{
			XDrawString(display, drawable, gc, x+tx, y,
				p, length);
			break;
		}
	}
}

/*
 *	Like TextWidth, except it takes an additional  "tabs"
 *	argument, used to specify what horizontal pixel position to
 *	move to when tab characters are present in the string.  If
 *	the "tabs" argument is NULL, works exactly like its
 *	counterpart.
 */
int
XfwfTextWidth(font, str, length, tabs)
     XFontStruct *font;
     String str;
     int length;
     int *tabs;
{
	register char	*p, *ep;
	register int	tx, tab, rc;

	tab = tx = 0;
 	if (length == 0) return 0;
	for (p = str; length; )
	{
		ep = kstrchr(p, '\t'/*, length*/);
		if (ep && tabs)
		{
			tx = tabs[tab++];
			length -= ep - p + 1;
			p = ep + 1;
		}
		else
		{
			rc = XTextWidth(font, p, length);
			if (rc < 0) return rc; else return rc + tx;
		}
	}
}


/*
 *	Converts a string list of tabs to an array of tabs
 */
int *
XfwfTablist2Tabs(tablist)
char *tablist;
{
	register int	*tabs;
	register int	ntabs = 0;

	if (!tablist)
		return NULL;
	for (;;)
	{
		/* Skip leading blanks */
		while (*tablist && *tablist == ' ') ++tablist;
		if (!*tablist) break;

		/* Allocate space for the new tab */
		if (ntabs)
			tabs = (int *) XtRealloc( (char *) tabs,
						(ntabs+1) * sizeof(int));
		else
			tabs = (int *) XtMalloc( (ntabs + 1) * sizeof(int));
		/* Add it to the list */
		tabs[ntabs++] = atoi(tablist);
		/* Skip to the next blank */
		while (*tablist && *tablist != ' ') ++tablist;
	}
	return (tabs);
}

#endif /* KATHENA_DEF */
/* Don't add after the endif */
