 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>             Athena xvobject Creation                  <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                xvw_create_menubutton()		      <<<<
   >>>>                xvw_create_button()		      <<<<
   >>>>                xvw_create_label()		      <<<<
   >>>>                xvw_create_scrollbar() 	              <<<<
   >>>>                xvw_create_list() 	              <<<<
   >>>>                xvw_create_text()	 	      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


#include "internals.h"

#ifdef KATHENA_DEF

klist *xvw_menuwidget_list = NULL;
klist *xvw_listwidget_list = NULL;


static void text_focus PROTO((xvobject, kaddr, XEvent *));

/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_menubutton
|
|       Purpose: Creates a compound menubutton object
|                using the Athena Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference menubutton
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro 
|          Date: Jun 26, 1992
| Modifications: 
|
------------------------------------------------------------*/

static xvattribute menu_attributes[] = {
{XVW_LABEL,		XtNlabel,    XtRString, NULL},
};

xvobject xvw_create_menubutton(
   xvobject parent,
   char     *name)
{
	int    i;
	Arg    args[MAX_ARGS];
	Widget menubutton, menu;
	klist  *menuwidget_list;
	char   temp[KLENGTH], *menuname = NULL;
	Pixel  background;

	static int initialized = FALSE;

	/*
	 * support for "plain" pulldown menus 
	 */
	if (xvw_class(parent) != xvwSimpleMenuWidgetClass)
	{
	   /* create the menu button with which to pull down the menu */
	   i = 0;
	   XtSetArg(args[i], XtNmappedWhenManaged, TRUE);	   	i++;
	   XtSetArg(args[i], XtNmenuName,   kstrdup(name));	   	i++;
	   XtSetArg(args[i], XtNshapeStyle, XmuShapeOval);		i++;
	   menubutton = XtCreateManagedWidget(name, menuButtonWidgetClass, 
				      	   xvw_widget(parent), args, i);
	   XtVaGetValues(menubutton, XtNmenuName, &menuname, NULL);

	   /* create the menu to be pulled down */
	   i = 0;
	   XtSetArg(args[i], XtNbottomMargin,      3);	           	i++;
	   XtSetArg(args[i], XtNtopMargin,         3);	      		i++;
	   XtSetArg(args[i], XtNmappedWhenManaged, TRUE);     		i++;
	   menu = XtCreatePopupShell(menuname, xvwSimpleMenuWidgetClass, 
			          menubutton, args, i);

	   /* a kludge to put an invisible line as the child of the menu, so we 
	      won't have a 0x0 widget just waiting to give an X protocol error
	      if there is never any buttons or labels added to menu */
	   XtVaGetValues(menu, XtNbackground, &background, NULL);
	   i = 0;
	   XtSetArg(args[i], XtNforeground, background); 		i++;
	   XtSetArg(args[i], XtNwidth,      15); 			i++;
	   XtCreateManagedWidget("kludgeline", smeLineObjectClass,
				 menu, args, i);
	}

	/*
	 * support for "walking" pulldown menus 
	 */
	else
	{
	   /* create the menu to be pulled down by walking menu */
	   i = 0;
	   XtSetArg(args[i], XtNbottomMargin,      3);	      		i++;
	   XtSetArg(args[i], XtNtopMargin,         3);	              	i++;
	   XtSetArg(args[i], XtNmappedWhenManaged, TRUE);		i++;
	   ksprintf(temp, "%s-menu", name);
	   menu = XtCreatePopupShell(temp, xvwSimpleMenuWidgetClass, 
			          xvw_widget(parent), args, i);

	   /* a kludge to put an invisible line as the child of the menu, so we 
	      won't have a 0x0 widget just waiting to give an X protocol error
	      if there is never any buttons or labels added to menu */
	   XtVaGetValues(menu, XtNbackground, &background, NULL);
	   i = 0;
	   XtSetArg(args[i], XtNforeground, background); 		i++;
	   XtSetArg(args[i], XtNwidth,      15); 			i++;
	   XtCreateManagedWidget("kludgeline", smeLineObjectClass,
				 menu, args, i);

	   /* create the menu button object within an existing pulldown menu,
	      to support walking menus in Athena */
	   i = 0;
	   XtSetArg(args[i], XtNmappedWhenManaged, TRUE);		i++;
	   XtSetArg(args[i], XtNlabel,             kstrdup(name));	i++;
	   XtSetArg(args[i], XtNmenu,              menu);		i++;
	   XtSetArg(args[i], XtNleftMargin,        10);			i++;
	   XtSetArg(args[i], XtNrightMargin,       10);			i++;
	   XtSetArg(args[i], XtNvertSpace,         75);			i++;
	   XtSetArg(args[i], XtNjustify,           XtJustifyLeft);	i++;
	   menubutton = XtCreateManagedWidget(name, xfwfEzMEObjectClass, 
				      	   xvw_widget(parent), args, i);
	}
	menuwidget_list = klist_locate(xvw_menuwidget_list, 
				       xvw_object(menubutton));
	if (menuwidget_list != NULL)
           menuwidget_list->client_data = (kaddr) (xvw_object(menu));
        else xvw_menuwidget_list = klist_add(xvw_menuwidget_list,
					     xvw_object(menubutton), 
					     xvw_object(menu));

	if (!initialized)
	{
	   initialized = TRUE;
	   xvw_init_attributes(menuButtonWidgetClass, menu_attributes,
		            knumber(menu_attributes), NULL, 0, NULL);
	   xvw_init_attributes(xfwfEzMEObjectClass, menu_attributes,
		            knumber(menu_attributes), NULL, 0, NULL);
	   xvw_init_attributes(XtClass(menu), menu_attributes,
		            knumber(menu_attributes), NULL, 0, NULL);
	}
	return(xvw_object(menubutton));
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_button
|
|       Purpose: Creates a button object using the Athena Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference button
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro 
|          Date: April 6, 1992
| Modifications:
|
------------------------------------------------------------*/

static xvattribute button_attributes[] = {
{XVW_LABEL,           XtNlabel,        XtRString,   NULL},
{XVW_LABEL_JUSTIFY,   XtNjustify,      XtRInt,      NULL},
{XVW_PIXMAP,          XtNbitmap,       XtRPixmap,   NULL},
{XVW_PIXMAP_FILENAME, XtNbitmap,       XtRFilename, XtRPixmap},
{XVW_PIXMAP_JUSTIFY,  XtNjustify,      XtRInt,      NULL},
{XVW_BUTTON_TYPE,     NULL,	       XtRInt,      NULL},
};

xvobject xvw_create_button(
   xvobject parent,
   char     *name)
{
	int i;
	Arg args[MAX_ARGS];
	Widget button;

	static int initialized = FALSE;

	i = 0;
	XtSetArg(args[i], XtNmappedWhenManaged, TRUE);	i++;
	if (xvw_class(parent) != xvwSimpleMenuWidgetClass)
	{
	   XtSetArg(args[i], XtNjustify, XtJustifyCenter);i++;
	   button = XtCreateManagedWidget(name, commandWidgetClass, 
				       xvw_widget(parent), args, i);
	}
	else
	{
	   XtSetArg(args[i], XtNleftMargin,  10);		i++;
	   XtSetArg(args[i], XtNrightMargin, 10);		i++;
	   XtSetArg(args[i], XtNvertSpace,   75);		i++;
	   XtSetArg(args[i], XtNjustify,     XtJustifyLeft);	i++;
	   button = XtCreateManagedWidget(name, smeBSBObjectClass, 
				       xvw_widget(parent), args, i);
	}

	if (!initialized)
	{
	   initialized = TRUE;

	   xvw_init_attributes(commandWidgetClass, button_attributes,
		knumber(button_attributes), NULL, 0, NULL);
	   xvw_init_attributes(smeBSBObjectClass, button_attributes,
		knumber(button_attributes), NULL, 0, NULL);
	   xvw_define_attributes(commandWidgetClass,
		XVW_BUTTON_SHAPE, XtRInt, xvw_set_misc, xvw_get_misc,
		NULL);
	   xvw_define_attributes(smeBSBObjectClass,
		XVW_BUTTON_SHAPE, XtRInt, xvw_set_misc, xvw_get_misc,
		NULL);
	   xvw_define_callback(XVW_BUTTON_SELECT, XtNcallback, NULL);
	}

	return(xvw_object(button));
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_label
|
|       Purpose: Creates a label object using the Athena Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference label
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro 
|          Date: April 9, 1992
| Modifications:
|
------------------------------------------------------------*/

static xvattribute label_attributes[] = {
{XVW_LABEL,             XtNlabel,	XtRString,   NULL},
{XVW_LABEL_JUSTIFY,     XtNjustify,	XtRInt,      NULL},
{XVW_PIXMAP,            XtNbitmap,	XtRPixmap,   NULL},
{XVW_PIXMAP_FILENAME,   XtNbitmap,	XtRFilename, XtRPixmap},
{XVW_PIXMAP_JUSTIFY,    XtNjustify,	XtRInt,      NULL},
{XVW_LABEL_TYPE,        NULL,		XtRInt,      NULL},
};

xvobject xvw_create_label(
   xvobject parent,
   char     *name)
{
	int     i;
	Widget  label;
	Arg     args[MAX_ARGS];

	static int initialized = FALSE;

	i = 0;
	XtSetArg(args[i], XtNmappedWhenManaged, TRUE);		        i++;
	XtSetArg(args[i], XtNborderWidth,       0);            	    	i++;
	XtSetArg(args[i], XtNinternalWidth,     0);           	    	i++;
	XtSetArg(args[i], XtNinternalHeight,    0);           	    	i++;
	if (xvw_class(parent) == xvwSimpleMenuWidgetClass)
	{
	    XtSetArg(args[i], XtNjustify, XtJustifyCenter);             i++;
	}
	else
	{
	    XtSetArg(args[i], XtNjustify, XtJustifyLeft);               i++;
	}

	label = XtCreateManagedWidget(name, labelWidgetClass,
				      xvw_widget(parent), args, i);

	if (!initialized)
	{
	   initialized = TRUE;
	   xvw_init_attributes(XtClass(label), label_attributes,
		knumber(label_attributes), NULL, 0, NULL);
	}
	return(xvw_object(label));
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_text
|
|       Purpose: Creates a text object using the Athena Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference text object
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro 
|          Date: April 10, 1992
| Modifications:
|
------------------------------------------------------------*/

static xvattribute text_attributes[] = {
{XVW_TEXT_INSERT_POS,   XtNinsertPosition,   XtRInt,              NULL},
{XVW_TEXT_LENGTH,       XtNlength,           XtRInt,              NULL},
{XVW_TEXT_LEFT_MARGIN,  XtNleftMargin,       XtRDimension,        NULL},
};

xvobject xvw_create_text(
   xvobject parent,
   char     *name)
{
	int     i;
	Arg     args[MAX_ARGS];
	Widget  text;

	static int initialized = FALSE;

        i = 0;
      	XtSetArg(args[i], XtNeditType,          XawtextEdit);		i++;
        XtSetArg(args[i], XtNmappedWhenManaged, TRUE);		        i++;
        XtSetArg(args[i], XtNwidth,             10);			i++;
        XtSetArg(args[i], XtNwrap,              XawtextWrapWord);	i++;
        XtSetArg(args[i], XtNpieceSize,         50);			i++;
        XtSetArg(args[i], XtNdisplayCaret,      FALSE);			i++;
	text = XtCreateManagedWidget(name, asciiTextWidgetClass,
				      xvw_widget(parent), args, i);

	if (!initialized)
	{
	    initialized = TRUE;

	    xvw_init_attributes(XtClass(text), text_attributes,
		knumber(text_attributes), NULL, 0, NULL);
	    xvw_define_attributes(XtClass(text),
	     XVW_TEXT_STRING, XtRString, xvw_set_textstring, xvw_get_textstring,
	     XVW_TEXT_EDIT_TYPE,    XtRInt, xvw_set_misc,    xvw_get_misc,
	     XVW_TEXT_TYPE,         XtRInt, xvw_set_misc,    xvw_get_misc,
	     XVW_TEXT_WRAP,         XtRInt, xvw_set_misc,    xvw_get_misc,
             XVW_TEXT_SCROLL_VERT,  XtRInt, xvw_set_misc,    xvw_get_misc,
             XVW_TEXT_SCROLL_HORIZ, XtRInt, xvw_set_misc,    xvw_get_misc,
	     XVW_TEXT_MULTILINE,    XtRInt, xvw_set_textmulti,  xvw_get_textmulti,
	     NULL);
	}

	xvw_set_attribute(xvw_object(text), XVW_TEXT_MULTILINE, FALSE);
	xvw_add_event(xvw_object(text), EnterWindowMask | LeaveWindowMask, 
		      text_focus, NULL);
	return(xvw_object(text));
}
/*-----------------------------------------------------------
|
|  Routine Name: text_focus
|
|       Purpose: Focuses into the text window when the pointer is in it.
|
|         Input: object      - the text xvobject
|                client_data - client data (unused)
|                event       - event responsible for firing event handler 
|                              (EnterWindowMask | LeaveWindowMask)
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro
|          Date: December 9, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void text_focus(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
	int     i;
        Arg     args[MAX_ARGS];

	i = 0;
	if (event->type == EnterNotify)
	{
	    XtSetArg(args[i], XtNdisplayCaret, TRUE);	i++;
	}
	else
	{
	    XtSetArg(args[i], XtNdisplayCaret, FALSE);	i++;
	}
	XtSetValues(xvw_widget(object), args, i); 
}

/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_scrollbar
|
|       Purpose: Creates a scrollbar using the Athena Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference scrollbar
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro 
|          Date: April 9, 1992
| Modifications:
|
------------------------------------------------------------*/

xvobject xvw_create_scrollbar(
   xvobject parent,
   char     *name)
{
	Widget  scroll;
	Arg     args[MAX_ARGS];
	int     i;

	static int initialized = FALSE;

	i = 0;
        XtSetArg(args[i], XtNmappedWhenManaged, TRUE);	        i++;
        XtSetArg(args[i], XtNorientation, XtorientHorizontal);	i++;
	scroll = XtCreateManagedWidget(name, xvwScrollbarWidgetClass,
				       xvw_widget(parent), args, i);

	if (!initialized)
	{
	   initialized = TRUE;

	   xvw_init_attributes(XtClass(scroll), NULL, 0, NULL, 0, NULL);
	   xvw_define_callback(XVW_SCROLL_CONT_MOTION, XtNjumpProc,
	                       xvw_update_scroll_value);
	   xvw_define_callback(XVW_SCROLL_INCR_MOTION, XtNscrollProc,
	                       xvw_update_scroll_value);
	   xvw_define_attributes(XtClass(scroll),
	     XVW_SCROLL_MIN,   XtRDouble, xvw_set_scrollbar, xvw_get_scrollbar,
	     XVW_SCROLL_MAX,   XtRDouble, xvw_set_scrollbar, xvw_get_scrollbar,
	     XVW_SCROLL_VALUE, XtRDouble, xvw_set_scrollbar, xvw_get_scrollbar,
	     XVW_SCROLL_INCR,  XtRDouble, xvw_set_scrollbar, xvw_get_scrollbar,
	     XVW_ORIENTATION,  XtRInt,    xvw_set_scrollbar, xvw_get_scrollbar,
	     NULL);
	}
	return(xvw_object(scroll));
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_list
|
|       Purpose: Creates a compound list object using the Athena Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference list
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro 
|          Date: April 12, 1992
| Modifications:
|
------------------------------------------------------------*/

xvobject xvw_create_list(
   xvobject parent,
   char     *name)
{
	int      i;
	Widget   list;
	Arg      args[MAX_ARGS];
	static   char *default_list[] = { "" };

	static int initialized = FALSE;

	i = 0;
        XtSetArg(args[i], XtNlist, default_list);		i++;
        XtSetArg(args[i], XtNnumberStrings, 1);			i++;
	list = XtCreateManagedWidget(name, xfwfScrolledListWidgetClass,
		     xvw_widget(parent), args, i);


	if (!initialized)
	{
	   initialized = TRUE;

	   xvw_init_attributes(XtClass(list), NULL, 0, NULL, 0, NULL);
	   xvw_define_callback(XVW_LIST_ITEM_SELECT, XtNcallback,
               xvw_update_list_struct);
	   xvw_define_callback(XVW_LIST_ITEM_ACTION, XtNcallback,
               xvw_update_list_struct);
	   xvw_define_attributes(XtClass(list),
	      XVW_LIST_SIZE,          XtRInt, xvw_set_list_num, 
					      xvw_get_list_num,
	      XVW_LIST_HIGHLT_ELEM,   XtRInt, xvw_set_list_highlight,   
				              xvw_get_list_highlight,
	      XVW_LIST_UNHIGHLT_ELEM, XtRInt, xvw_set_list_unhighlight, NULL,
	      NULL);
	}
	return(xvw_object(list));
}

#else
/*
 * These are dummy function calls so that if the widget set is not supported
 * on the machine a message is printed out.
 */
xvobject xvw_create_menubutton(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Athena widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

xvobject xvw_create_button(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Athena widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

xvobject xvw_create_label(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Athena widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

xvobject xvw_create_scrollbar(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Athena widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

xvobject xvw_create_list(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Athena widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

xvobject xvw_create_text(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Athena widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}
#endif /* KATHENA_DEF */
/* Don't add after the endif */
