 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>       Purpose: Contains all #defines, structures, global <<<<
   >>>>                definitions used by the xvutils library   <<<<
   >>>>                                                          <<<<
   >>>>    Written by: Danielle Argiro				 <<<<
   >>>>                                                          <<<<
   >>>>          Date: Jul 7, 1992  16:56                        <<<<
   >>>>                                                          <<<<
   >>>> Modifications:				                 <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#ifndef _xvutils_xvutils_h_
#define _xvutils_xvutils_h_


	/*-------------------------------------*
        |       #include
        ---------------------------------------*/

	/*-------------------------------------*
        |       #defines
        ---------------------------------------*/

	/*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

/*
 *  structure used by xvu_create_display
 */
typedef struct {

	xvobject toplevel;
        xvobject back;
	xvobject viewport;
	xvobject label;
	xvobject text;
	int    update_time;
	char   *filename;

        } DisplayWid_Data;

	/*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
        |       macros
        ---------------------------------------*/

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/* browser.c */
char *xvu_run_browser      PROTO((char *));

/* display.c */
DisplayWid_Data *xvu_create_display PROTO((char *, char *, float));
int xvu_update_display              PROTO((DisplayWid_Data *, char *, float));


/* error.c */
int xvu_error      PROTO((char *, char *, char *, char *, char *, char *));
int xvu_error_wait PROTO((char *, char *, char *));

/* exit.c */
int xvu_exit_wait PROTO((char *, char *, char *, char *, char *));

/* help.c */
int xvu_online_help_wait   PROTO((char *, char *));

/* info.c */
int xvu_info      PROTO((char *));
int xvu_info_wait PROTO((char *, char *, char *));

/* inform.c */
int xvu_inform_wait PROTO((char **, int, char *, char *));

/* list.c */
xvw_list_struct *xvu_run_list_wait          PROTO((char **, int, char *, char *, int, int));
xvw_list_struct **xvu_run_list_multsel_wait PROTO((char **, int, char *, char *, int, int, int *));

/* query.c */
int xvu_query_wait PROTO((char *, char **, char *, char **, int, int));

/* select.c */
int xvu_choose      PROTO((char **, int, int, int *, char **, char *));
int xvu_select_wait PROTO((char *, char *, char **, int));

/* text.c */
char *xvu_text_wait PROTO((char *, char *, char *, int, int));

/* view.c */
int xvu_view_wait PROTO((char *, char *));

/* warn.c */
int xvu_warn      PROTO((char *, char *, char *, char *, char *));
int xvu_warn_wait PROTO((char *, char *, char *));

/* prompt.c */
int xvu_prompt      PROTO((char *, char *, int, char *));
int xvu_prompt_wait PROTO((char *, char *, char *, char *));


#endif /* _xvutils_xvutils_h_ */
/* Don't add after the endif */
