 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Viewport object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_ViewportP_h_
#define _xvobjects_ViewportP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvobjects/Viewport.h>
#include <xvobjects/ManagerP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct _XvwViewportWidgetClassPart
{
     XtPointer  extension;
} XvwViewportWidgetClassPart;

typedef struct _XvwViewportWidgetClassRec
{
   CoreClassPart       core_class;
   CompositeClassPart  composite_class;
   ConstraintClassPart constraint_class;
   XvwManagerWidgetClassPart   manager_class;
   XvwViewportWidgetClassPart  viewport_class;
} XvwViewportWidgetClassRec;

extern  XvwViewportWidgetClassRec xvwViewportWidgetClassRec;

typedef struct
{
   Boolean allow_vertical;	/* allows a vertical scrollbar to be added    */
   Boolean allow_horizontal;	/* allows a horizontal scrollbar to be added  */
   Boolean force_vertical;	/* force vertical scrollbar to be used        */
   Boolean force_horizontal;	/* force horizontal scrollbar to be used      */
   Boolean use_bottom;		/* horizontal scrollbar located on bottom     */
   Boolean use_right;		/* vertical scrollbar located on right        */
   Position xoffset;		/* set horizontal position of contents (pixs) */
   Position yoffset;		/* set vertical position of contents (pixs)   */
   float char_xoffset;		/* set horizontal position of contents (char) */
   float char_yoffset;		/* set vertical position of contents (char)   */

   xvobject vertical;		/* the vertical scrollbar if applicable       */
   xvobject horizontal;		/* the horizontal scrollbar if applicable     */
   xvobject clip;		/* the clip widget will clip the plane widget */
   xvobject plane;		/* the plane widget is a backplane that will  */
				/* contain all the viewport children          */

   Boolean override;		/* this private routine is used to override   */
				/* the mapping of children into the "plane"   */
				/* object.				      */
   double xscale, yscale;
   xvobject top, left, right, bottom;
} XvwViewportPart;


typedef struct _XvwViewportWidgetRec
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  XvwManagerPart	manager;
  XvwViewportPart	viewport;

} XvwViewportWidgetRec;

typedef struct {int empty;} XvwViewportConstraintsPart;

typedef struct _XvwViewportWidgetConstraintsRec {
    XvwManagerConstraintsPart   manager;
    XvwViewportConstraintsPart   viewport;
} XvwViewportWidgetConstraintsRec, *XvwViewportWidgetConstraints;

typedef struct  _XvwViewportWidgetClassRec  *XvwViewportWidgetClass;
typedef struct  _XvwViewportWidgetRec       *XvwViewportWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwViewportWidget
 */
extern XvwViewportWidgetClassRec xvwViewportWidgetClassRec;


#endif /* _xvobjects_ViewportP_h_ */
/* Do not add after this line */
