 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of  Viewport Widget
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Viewport_h_
#define _xvobjects_Viewport_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

/*
 *  Viewport attributes
 */

/*------------------------------------------------------------------------
| Attribute:	XVW_VP_ALLOW_VERT
| Description:  Set to TRUE if a vertical scrollbar should appear if it 
|		is needed.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	vpAllowVert
------------------------------------------------------------------------*/
#define XVW_VP_ALLOW_VERT	"vpAllowVert"

/*------------------------------------------------------------------------
| Attribute:	XVW_VP_ALLOW_HORIZ
| Description:  Set to TRUE if a horizontal scrollbar should appear if it 
|		is needed.
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:	vpAllowHoriz
------------------------------------------------------------------------*/
#define XVW_VP_ALLOW_HORIZ	"vpAllowHoriz"

/*------------------------------------------------------------------------
| Attribute:	XVW_VP_FORCE_VERT
| Description:  Set to TRUE if a vertical scrollbar should always appear.  
|		Only valid if
|		.symbol noindex XVW_VP_ALLOW_VERT
|		is TRUE.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	vpForceVert
------------------------------------------------------------------------*/
#define XVW_VP_FORCE_VERT	"vpForceVert"

/*------------------------------------------------------------------------
| Attribute:	XVW_VP_FORCE_HORIZ
| Description:  Set to TRUE if a horizontal scrollbar should always appear.  
|		Only valid if
|		.symbol noindex XVW_VP_ALLOW_HORIZ
|		is TRUE.
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:	vpForceHoriz
------------------------------------------------------------------------*/
#define XVW_VP_FORCE_HORIZ	"vpForceHoriz"

/*------------------------------------------------------------------------
| Attribute:	XVW_VP_USE_BOTTOM
| Description:  Set to TRUE if the horizontal scrollbar should appear at 
|		the bottom of the viewport; set to FALSE to make the 
|		horizontal scrollbar appear at the top of the viewport.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	vpUseBottom
------------------------------------------------------------------------*/
#define XVW_VP_USE_BOTTOM	"vpUseBottom"

/*------------------------------------------------------------------------
| Attribute:	XVW_VP_USE_RIGHT
| Description:  Set to TRUE if the vertical scrollbar should appear at the 
|		right of the viewport; set to FALSE to make the vertical 
|		scrollbar appear at the left of the viewport.
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:	vpUseRight
------------------------------------------------------------------------*/
#define XVW_VP_USE_RIGHT	"vpUseRight"

/*------------------------------------------------------------------------
| Attribute:	XVW_VP_XOFFSET
| Description:  The offset of the viewport in pixels from the left side.
| Type:         int
| Default:      0
| Legal Values: value >= 0 
| Resource:	vpXoffset
------------------------------------------------------------------------*/
#define XVW_VP_XOFFSET          "vpXoffset"

/*------------------------------------------------------------------------
| Attribute:	XVW_VP_YOFFSET
| Description:  The offset of the viewport in pixels from the top.
| Type:         int
| Default:      0
| Legal Values: values >= 0 
| Resource:	vpYoffset
------------------------------------------------------------------------*/
#define XVW_VP_YOFFSET          "vpYoffset"

/*
 *  Internal sub-objects used by the viewport
 */

/*------------------------------------------------------------------------
| Attribute:	XVW_VP_VERTICAL_SCROLLBAR
| Description:  This is a read-only attribute that will return the pointer 
|		to the xvobject for the vertical scrollbar.
| Type:         xvobject
| Default:      NULL
| Legal Values: valid xvobject
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_VP_VERTICAL_SCROLLBAR	"vpVerticalScrollbar"

/*------------------------------------------------------------------------
| Attribute:	XVW_VP_HORIZONTAL_SCROLLBAR
| Description:  This is a read-only attribute that will return the pointer 
|		to the xvobject for the horizontal scrollbar.
| Type:         xvobject
| Default:      NULL
| Legal Values: valid xvobject
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_VP_HORIZONTAL_SCROLLBAR	"vpHorizontalScrollbar"

/*------------------------------------------------------------------------
| Attribute:	XVW_VP_CLIP_OBJECT
| Description:  This is the clip object component of the viewport;  it 
|		serves as the viewport to the plane object.
| Type:         xvobject
| Default:      NULL
| Legal Values: valid xvobject
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_VP_CLIP_OBJECT		"vpClipObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_VP_PLANE_OBJECT
| Description:  This is the plane object component of the viewport;  
|		children of the viewport created by the application are 
|		actually created as children of this plane object, \fInot\fP 
|		of the viewport itself.
| Type:         xvobject
| Default:      NULL
| Legal Values: valid xvobject
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_VP_PLANE_OBJECT		"vpPlaneObject"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Viewport Object by.
#define ViewportWidgetClass	xvwViewportWidgetClass
 */


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration ViewportWidgetClass
 */
extern   WidgetClass     xvwViewportWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Viewport Object
 */
xvobject xvw_create_viewport PROTO((xvobject, char *));


#endif /* _xvobjects_Viewport_h_ */
/* Do not add after this line */
