 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of  OutputFile Widget
   >>>>
   >>>>    Written By: Mark Young and Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_OutputFile_h_
#define _xvobjects_OutputFile_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_OUTPUTFILE_CRLABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               pixmap object component of the the outputfile object that
|               indicates a "live" selection.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The pixmap object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_OUTPUTFILE_CRLABEL_OBJECT "outputfileCrlabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_OUTPUTFILE_BUTTON_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               button object component of the the outputfile object.
|
| Type:        	xvobject
| Default:	NULL
| Legal Values: The button object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_OUTPUTFILE_BUTTON_OBJECT  "outputfileButtonObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_OUTPUTFILE_TEXT_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               text object component of the the outputfile object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The text object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_OUTPUTFILE_TEXT_OBJECT    "outputfileTextObject"

/*------------------------------------------------------------------------
| Attribute:    XVW_OUTPUTFILE_BROWSER_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               browser object which is popped up when the user clicks
|		on the button of the outputfile object.
|
| Type:         xvobject 
| Default:      NULL 
| Legal Values: The browser object (read-only). 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_OUTPUTFILE_BROWSER_OBJECT "outputfileBrowserObject"


/*------------------------------------------------------------------------
| Attribute:    XVW_OUTPUTFILE_FILENAME
|
| Description:  The filename which is currently displayed in the text object.  
|		This attribute can be used to initialize the filename to be 
|		displayed in the outputfile object, or to acquire the filename
|		that has been entered by the user in the text object.
|
| Type:         char *
| Default:      NULL
| Legal Values: any valid output file name
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_OUTPUTFILE_FILENAME		"outputfileTextObject.textString"

/*------------------------------------------------------------------------
| Attribute:    XVW_OUTPUTFILE_LABEL
|
| Description:  This is the text that will appear in the label object
|               component of the outputfile object.  Provide text appropriate
|               as a title of the outputfile object.
|
| Type:         char *
| Default:      NULL 
| Legal Values: any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_OUTPUTFILE_LABEL		"outputfileButtonObject.label"

/*------------------------------------------------------------------------
| Attribute:    XVW_OUTPUTFILE_DISPLAY_BUTTON
|
| Description:  This attribute controls whether the browser button should
|		be displayed (mapped) or not.  If not then the text object
|	        stretches the difference.
|
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	outputfileDisplayButton
------------------------------------------------------------------------*/
#define XVW_OUTPUTFILE_DISPLAY_BUTTON	"outputfileDisplayButton"

/*------------------------------------------------------------------------
| Attribute:	XVW_OUTPUTFILE_CALLBACK
|
| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the outputfile object which will be fired when 
|               the user enters a new filename, either by typing it in and
|               pressing <cr>, or by using the browser.  
|               When calling \fIxvw_add_callback()\fP, pass this attribute
|               directly, as in
|               .begin code
|               xvw_add_callback(outputfileobj, XVW_OUTPUTFILE_CALLBACK,
|                                outputfile_cb, client_data);
|               .end code
|               Note that the
|               current filename of the output file object will be passed to the
|               callback in the \fIcall_data\fP.  The value must be cast
|               to a string before use, as in:
|               .br
|               \f(CWchar *filename = *((char **) call_data);\fP
|               .br
|               Alternatively, the filename may be obtained with
|               .symbol index XVW_OUTPUTFILE_FILENAME .
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_OUTPUTFILE_CALLBACK		"outputfileCallback"


/*
 *  Define the Class name, by which people should be externally referencing
 *  the OutputFile Object by.
 */
#define OutputFileWidgetClass	xvwOutputFileWidgetClass


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration OutputFileWidgetClass
 */
extern   WidgetClass     OutputFileWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for OutputFile Object
 */
xvobject xvw_create_outputfile PROTO((xvobject, char *));


#endif /* _xvobjects_OutputFile_h_ */
/* Do not add after this line */
