 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of  NotifyWindow Widget
   >>>>
   >>>>    Written By: Neil Bowers & Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_NotifyWindow_h_
#define _xvobjects_NotifyWindow_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_NOTIFYWINDOW_LABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               label object component of the the notifywindow object (the
|               object used to display the label).
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The label object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NOTIFYWINDOW_LABEL_OBJECT   "notifywindowLabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_NOTIFYWINDOW_ICON_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               the icon object component of the notifywindow object (the icon
|               displays the picture of the hourglass (or whatever you
|		specify) on the notifywindow object).  Note that by getting
|		the icon object with this attribute, you may then use
|		the 
|		.symbol index XVW_ICON_PIXMAPFILE
|		attribute with the icon object to specify another icon;
|		alternatively, the resource name may be used to specify
|		the desired pixmap in the app-defaults file, as in:
|		.br
|		*notifywindowButtonObject.iconPixmapfile: my_pixmap.xpm
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The icon object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NOTIFYWINDOW_ICON_OBJECT    "notifywindowButtonObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_NOTIFYWINDOW_TEXT_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               text object component of the the notifywindow object (the
|               object used to display the message that the user reads
|		while they are waiting for the notifywindow to go away).
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The text object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NOTIFYWINDOW_TEXT_OBJECT    "notifywindowTextObject"


/*------------------------------------------------------------------------
| Attribute:	XVW_NOTIFYWINDOW_MESSAGE
|
| Description:  This is the message that appears in the notify window while
|		it is displayed;  users are expected to read it while they
|		are waiting for the notify window to go away.  The 
|		message is typically used to indicate what the program is doing
|		that is forcing the user to wait. With programs such as
|		\fHcraftsman\fP, for example, the message might inform the user
|		that a new toolbox or a new software object is being created.
|
| Type:         char *
| Default:      NULL
| Legal Values: any printable text. 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NOTIFYWINDOW_MESSAGE	"notifywindowMessage"

/*------------------------------------------------------------------------
| Attribute:	XVW_NOTIFYWINDOW_TITLE
|
| Description:  The title that appears in the titlebar of the notify window
|		object.  Typically, this is the name of the application 
|		using the notify window.  This title is only used if the 
|		user's window manager applies a window dressing to transient
|		windows.
|
| Type:         char *
| Default:      NULL
| Legal Values: any printable text. 
| Resource:	notifywindowTitle
------------------------------------------------------------------------*/
#define XVW_NOTIFYWINDOW_TITLE		"notifywindowTitle"

/*------------------------------------------------------------------------
| Attribute:	XVW_NOTIFYWINDOW_LABEL
|
| Description:  The label that appears at the top of the notify window 
|		object.  This is usually a generalized label such as
|		"Working..." or some other string to indicate that the
|		program is busy. 
|
| Type:         char *
| Default:      NULL
| Legal Values: any printable text 
| Resource:	notifywindowLabel
------------------------------------------------------------------------*/
#define XVW_NOTIFYWINDOW_LABEL		"notifywindowLabel"

/*------------------------------------------------------------------------
| Attribute:	XVW_NOTIFYWINDOW_VISIBLE
|
| Description:  Defines whether or not the notify window should be actively 
|		displayed.  If the
|		.symbol noindex XVW_NOTIFYWINDOW_VISIBLE
|		attribute is FALSE, then the notify window will be unmapped 
|		from the screen.  If TRUE then the notify window will be 
|		placed centered according to the
|		.symbol noindex XVW_NOTIFYWINDOW_VISIBLE
|		attribute.
|
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NOTIFYWINDOW_VISIBLE	"notifywindowVisible"

/*------------------------------------------------------------------------
| Attribute:	XVW_NOTIFYWINDOW_NOTIFYFOR
|
| Description:	The
|		.symbol noindex XVW_NOTIFYWINDOW_NOTIFYFOR
|		attribute is used to specify the object for which the notify 
|		window appears.  Typically, this is the application's toplevel
|		object.  When a notify window is made "visible", the notify 
|		window will be centered around the specified object.  If this 
|		field is not specified, then the notify window will be placed 
|		according to the location of the user's pointer.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: Toplevel object of calling application.
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NOTIFYWINDOW_NOTIFYFOR	"notifywindowNotifyfor"

/*------------------------------------------------------------------------
| Attribute:    XVW_NOTIFYWINDOW_PIXMAPFILE
|
| Description:  This is the file defining the pixmap that appears in the
|		notify window. 
|
| Type:         char *
| Default:	The hourglass.xbm file in the \fIxvobjects/misc/pixmaps\fP
|		directory, which defines the "hourglass" pixmap.
| Legal Values: The full path to a valid xpm or xbm file, defining
|               the desired pixmap.  Note that the path may contain
|               $TOOLBOX.
| Resource:     notifywindowPixmapfile
------------------------------------------------------------------------*/
#define XVW_NOTIFYWINDOW_PIXMAPFILE         "notifywindowPixmapfile"

/*------------------------------------------------------------------------
| Attribute:	XVW_NOTIFYWINDOW_PIXMAP
|
| Description:  This is the pixmap that appears in the notify window object.
|               Candidates for the value of this attribute may be created 
|		with the use of \fIXCreatePixmap()\fP;  see \fIThe Xlib 
|		Reference Manual\fP by O'Reilly and Associates.
|		Note that this attribute is mutually exclusive with
|               .symbol index XVW_NOTIFYWINDOW_PIXMAPFILE ;
|               specify one or the other, not both.
|
| Type:         Pixmap
| Default:      The "hourglass" pixmap 
| Legal Values: Valid Pixmap structure 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NOTIFYWINDOW_PIXMAP		"notifywindowPixmap"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the NotifyWindow Object by.
 */
#define NotifyWindowWidgetClass	xvwNotifyWindowWidgetClass


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration NotifyWindowWidgetClass
 */
extern   WidgetClass     NotifyWindowWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for NotifyWindow Object
 */
xvobject xvw_create_notifywindow PROTO((xvobject, char *));


#endif /* _xvobjects_NotifyWindow_h_ */
/* Do not add after this line */
