 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Definitions of Attributes
   >>>>                used to specify relative layout of an object.
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_ManagerRelLayout_h_
#define _xvobjects_ManagerRelLayout_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:    XVW_LEFT_OF
| Description:	The object having the attribute set will appear to the 
|		left of the object specified.  Setting the attribute to NULL 
|		implies that the object will be left of \fInothing\fP; ie, it 
|		will appear at the right edge of the parent.
| Type:         xvobject 
| Default:      MANAGER_UNDEFINED
| Legal Values: NULL, or sibling visual object
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_LEFT_OF 		"leftOf"

/*------------------------------------------------------------------------
| Attribute:	XVW_RIGHT_OF
| Description:  The object having the attribute set will appear to the 
|               right of the object specified.  Setting the attribute to NULL 
|               implies that the object will be right of \fInothing\fP; ie, it 
|               will appear at the left edge of the parent.
| Type:         xvobject 
| Default:      MANAGER_UNDEFINED
| Legal Values: NULL, or sibling visual object
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_RIGHT_OF 		"rightOf"

/*------------------------------------------------------------------------
| Attribute:    XVW_BELOW
| Description:  The object having the attribute set will appear below
|               the object specified.  Setting the attribute to NULL 
|               implies that the object will be below \fInothing\fP; ie, it 
|               will appear at the top of the parent.
| Type:         xvobject 
| Default:      MANAGER_UNDEFINED
| Legal Values: NULL, or sibling visual object
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_BELOW		"below"

/*------------------------------------------------------------------------
| Attribute:    XVW_ABOVE
| Description:  The object having the attribute set will appear above
|               the object specified.  Setting the attribute to NULL 
|               implies that the object will be above \fInothing\fP; ie, it 
|               will appear at the bottom of the parent.
| Type:         xvobject 
| Default:      MANAGER_UNDEFINED
| Legal Values: NULL, or sibling visual object 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_ABOVE		"above"

#endif /* _xvobjects_ManagerRelLayout_h_ */
/* Do not add after this line */
