 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Defines for the Manager Widget
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Manager_h_
#define _xvobjects_Manager_h_

        /*-------------------------------------*
        |       #includes
        ---------------------------------------*/

#include <xvobjects/ManagerRelLayout.h>    /* attrs for relative layout       */
#include <xvobjects/ManagerPixelGeom.h>    /* attrs for pixel geometry bounds */
#include <xvobjects/ManagerPixelSpacing.h> /* attrs for pixel spacing         */
#include <xvobjects/ManagerPref.h>         /* attrs for preferred w & h       */
#include <xvobjects/ManagerManip.h>        /* attrs for direct manipulation   */
#include <xvobjects/ManagerTack.h>         /* attrs for tacking               */

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

/*
 *  The attributes below are UNDOCUMENTED for a good reason.  Either
 *  we don't want people using them, or they are not implemented yet.
 */
#define XVW_MANAGER_RELAYOUT  	   "managerRelayout"
#define XVW_MANAGER_DELAYED_LAYOUT "managerDelayedLayout"
#define XVW_CANVAS_COLOR   	   "canvasColor"
#define XVW_CANVAS_PIXEL   	   "canvasPixel"
#define XVW_TOP_SHADOW_COLOR       "topShadowColorname"
#define XVW_TOP_SHADOW_PIXEL   	   "topShadowPixel"
#define XVW_TOP_SHADOW_COLOR       "topShadowColorname"
#define XVW_BOTTOM_SHADOW_PIXEL	   "bottomShadowPixel"
#define XVW_BOTTOM_SHADOW_COLOR    "bottomShadowColorname"
#define XVW_TOP_MARGIN             "topMargin"
#define XVW_BOTTOM_MARGIN          "bottomMargin"
#define XVW_LEFT_MARGIN            "leftMargin"
#define XVW_RIGHT_MARGIN           "rightMargin"
#define XVW_HORIZ_SPACING          "horizSpacing"
#define XVW_VERT_SPACING           "vertSpacing"



#define KMANAGER_UNDEFINED   (&manager_undefined)

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Manager Object by.
 */
#define ManagerWidgetClass	xvwManagerWidgetClass


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration ManagerWidgetClass
 */
extern   WidgetClass     ManagerWidgetClass;
extern   long		 manager_undefined;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Manager Object
 */
xvobject xvw_create_manager PROTO((xvobject, char *));


#endif /* _xvobjects_Manager_h_ */
/* Do not add after this line */
