 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       graphical layout manager.
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Layout_h_
#define _xvobjects_Layout_h_


    /*-------------------------------------*
    |       #defines 
    ---------------------------------------*/

/*
 *  Attribute definitions for Layout Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:	XVW_LAYOUT_NUMBER_ACROSS
| Description:  This attribute specifies how many area objects will be 
|		placed on the same row before a new row is started.
| Type:         int
| Default:      1
| Legal Values: values > 0
| Resource:	layoutNumberAcross
------------------------------------------------------------------------*/
#define XVW_LAYOUT_NUMBER_ACROSS	"layoutNumberAcross"

/*------------------------------------------------------------------------
| Attribute:	XVW_LAYOUT_BUFFER_SIZE
| Description:  This attribute specifies the distance between area objects, 
|		in pixels.  
| Type:         int
| Default:      5
| Legal Values: values >= 0 
| Resource:	layoutBufferSize
------------------------------------------------------------------------*/
#define XVW_LAYOUT_BUFFER_SIZE 	        "layoutBufferSize"

/*------------------------------------------------------------------------
| Attribute:	XVW_LAYOUT_BORDER_SIZE
| Description:  When the user selects one of the area object children of the 
|		the layout object, the border of the area object will be
|		highlighted.  This attribute specifies the line width of
|		the highlighted border.
| Type:         int
| Default:      2
| Legal Values: values >= 0
| Resource:	layoutBorderSize
------------------------------------------------------------------------*/
#define XVW_LAYOUT_BORDER_SIZE 	        "layoutBorderSize"

/*------------------------------------------------------------------------
| Attribute:	XVW_LAYOUT_AREA_JUSTIFICATION
| Description:  This attribute indicates how to lay out the last row of 
|		area objects, assuming that the last row has a smaller 
|		number of area objects than any of the other rows.  For 
|		example, assume that there are 3 area objects, and
|		.symbol noindex XVW_NUMBER_ACROSS
|		has been specified as 2.  In this scenario, the layout 
|		object will place the first two area objects in the first 
|		row, and have a last area object to place somewhere in the 
|		second row.  The
|		.symbol noindex XVW_AREA_JUSTIFICATION
|		attribute indicates where in the last row the last area 
|		object will be placed.  The following settings may be used:
|		.br
|		.symbol index KLAYOUT_AREA_CENTER - 
|		.br
|		center the area object(s) in the last row
|		.br
|		.symbol index KLAYOUT_AREA_RIGHT -
|		.br
|		right justify the area object(s) in the last row
|		.br
|		.symbol index KLAYOUT_AREA_LEFT - 
|		.br
|		left justify the area object(s) in the last row
|		.br
|		.symbol index KLAYOUT_AREA_FULL - 
|		.br
|		"stretch" the area object(s) to fill the last row
| Type:         int
| Default:      .symbol index KLAYOUT_AREA_CENTER
| Legal Values: .symbol index KLAYOUT_AREA_CENTER
|		.symbol index KLAYOUT_AREA_RIGHT
|		.symbol index KLAYOUT_AREA_LEFT
|		.symbol index KLAYOUT_AREA_FULL
| Resource:	layoutAreaJustification
------------------------------------------------------------------------*/
#define XVW_LAYOUT_AREA_JUSTIFICATION 	"layoutAreaJustification"

/*------------------------------------------------------------------------
| Attribute:	XVW_LAYOUT_SELECTED_CHILD
| Description:  Specifies which area object is currently selected;  
|		the selected area object will be highlighted.  The 
|		default is NULL.
| Type:         xvobject
| Default:      NULL
| Legal Values: valid xvobject
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_LAYOUT_SELECTED_CHILD	"layoutSelectedChild"


/*------------------------------------------------------------------------
| Attribute:	XVW_LAYOUT_CALLBACK

| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the layout object which will be fired when the 
|		user selects the layout object by clicking on it.
|               When calling \fIxvw_add_callback()\fP, pass this attribute
|               directly, as in
|               .begin code
|               xvw_add_callback(layoutobj, XVW_LAYOUT_CALLBACK,
|                                layout_cb, client_data);
|               .end code
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_LAYOUT_CALLBACK	"layoutCallback"

/*
 *  Value definitions for Layout Visual Object
 */
#define KLAYOUT_AREA_CENTER     1
#define KLAYOUT_AREA_RIGHT      2
#define KLAYOUT_AREA_LEFT       3
#define KLAYOUT_AREA_FULL       4

#define KLAYOUT_NOT_ATTATCHED   (~0L)
#define KLAYOUT_MAX_AREAS       64

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Layout Object by.
 */
#define LayoutWidgetClass	xvwLayoutWidgetClass

    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration for LayoutWidgetClass
 */
extern   WidgetClass     LayoutWidgetClass;


    /*-------------------------------------*
    |       routine definitions
    ---------------------------------------*/

/*
 *  Function definitions for Layout Visual Object
 */
xvobject xvw_create_layout PROTO((xvobject, char *));


#endif /* _xvobjects_Layout_h_ */
/* Don't add after this point */
