 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Float object
   >>>>
   >>>>    Written By: Mark Young and Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_FloatP_h_
#define _xvobjects_FloatP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvobjects/Float.h>
#include <xvobjects/ManagerP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct _XvwFloatWidgetClassPart
{
     XtPointer  extension;
} XvwFloatWidgetClassPart;

typedef struct _XvwFloatWidgetClassRec
{
   CoreClassPart		core_class;
   CompositeClassPart		composite_class;
   ConstraintClassPart		constraint_class;
   XvwManagerWidgetClassPart	manager_class;
   XvwFloatWidgetClassPart	float_class;
} XvwFloatWidgetClassRec;

extern  XvwFloatWidgetClassRec xvwFloatWidgetClassRec;

typedef struct
{
   float   value;
   float   minvalue;
   float   maxvalue;
   xvobject scrollbar;
   xvobject crlabel;
   xvobject label;
   xvobject text;
   XtCallbackList float_callback;

} XvwFloatPart;


typedef struct _XvwFloatWidgetRec
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  XvwManagerPart	manager;
  XvwFloatPart		floatpart;

} XvwFloatWidgetRec;

typedef struct {int empty;} XvwFloatConstraintsPart;

typedef struct _XvwFloatWidgetConstraintsRec {
    XvwManagerConstraintsPart	manager;
    XvwFloatConstraintsPart	floatpart;
} XvwFloatWidgetConstraintsRec, *XvwFloatWidgetConstraints;

typedef struct  _XvwFloatWidgetClassRec  *XvwFloatWidgetClass;
typedef struct  _XvwFloatWidgetRec       *XvwFloatWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwFloatWidget
 */
extern XvwFloatWidgetClassRec xvwFloatWidgetClassRec;


#endif /* _xvobjects_FloatP_h_ */
/* Do not add after this line */
