 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Error object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_ErrorP_h_
#define _xvobjects_ErrorP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvobjects/Error.h>
#include <xvobjects/ManagerP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct _XvwErrorWidgetClassPart
{
     XtPointer  extension;
} XvwErrorWidgetClassPart;

typedef struct _XvwErrorWidgetClassRec
{
   CoreClassPart		core_class;
   CompositeClassPart		composite_class;
   ConstraintClassPart		constraint_class;
   XvwManagerWidgetClassPart	manager_class;
   XvwErrorWidgetClassPart	error_class;
} XvwErrorWidgetClassRec;

extern  XvwErrorWidgetClassRec xvwErrorWidgetClassRec;

typedef struct
{
   xvobject button;
   xvobject label;
   xvobject text;
   Pixmap   error_pixmap;
   XtCallbackList error_callback;

} XvwErrorPart;


typedef struct _XvwErrorWidgetRec
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  XvwManagerPart	manager;
  XvwErrorPart		error;

} XvwErrorWidgetRec;

typedef struct {int empty;} XvwErrorConstraintsPart;

typedef struct _XvwErrorWidgetConstraintsRec {
    XvwManagerConstraintsPart	manager;
    XvwErrorConstraintsPart	error;
} XvwErrorWidgetConstraintsRec, *XvwErrorWidgetConstraints;

typedef struct  _XvwErrorWidgetClassRec  *XvwErrorWidgetClass;
typedef struct  _XvwErrorWidgetRec       *XvwErrorWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwErrorWidget
 */
extern XvwErrorWidgetClassRec xvwErrorWidgetClassRec;


#endif /* _xvobjects_ErrorP_h_ */
/* Do not add after this line */
