 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Loop object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Nov 24, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_LoopP_h_
#define _xvlang_LoopP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvlang/Loop.h>
#include <xvlang/ProcedureP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct _XvwLoopWidgetClassPart
{
     XtPointer  extension;
} XvwLoopWidgetClassPart;

typedef struct _XvwLoopWidgetClassRec
{
   CoreClassPart		core_class;
   CompositeClassPart		composite_class;
   ConstraintClassPart		constraint_class;
   XvwManagerWidgetClassPart	manager_class;
   XvwNodeWidgetClassPart	node_class;
   XvwGlyphWidgetClassPart	glyph_class;
   XvwProcedureWidgetClassPart	procedure_class;
   XvwLoopWidgetClassPart	loop_class;
} XvwLoopWidgetClassRec;

extern  XvwLoopWidgetClassRec xvwLoopWidgetClassRec;

typedef struct
{
   int      type;
   int	    value;
   xvobject count;

} XvwLoopPart;


typedef struct _XvwLoopWidgetRec
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  XvwManagerPart	manager;
  XvwNodePart		node;
  XvwGlyphPart		glyph;
  XvwProcedurePart	procedure;
  XvwLoopPart		loop;

} XvwLoopWidgetRec;

typedef struct {int empty;} XvwLoopConstraintsPart;

typedef struct _XvwLoopWidgetConstraintsRec {
    XvwManagerConstraintsPart	manager;
    XvwNodeConstraintsPart	node;
    XvwGlyphConstraintsPart	glyph;
    XvwProcedureConstraintsPart	procedure;
    XvwLoopConstraintsPart	loop;
} XvwLoopWidgetConstraintsRec, *XvwLoopWidgetConstraints;

typedef struct  _XvwLoopWidgetClassRec  *XvwLoopWidgetClass;
typedef struct  _XvwLoopWidgetRec       *XvwLoopWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwLoopWidget
 */
extern XvwLoopWidgetClassRec xvwLoopWidgetClassRec;


#endif /* _xvlang_LoopP_h_ */
/* Do not add after this line */
