 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Glyph object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: May 21, 1993 09:42
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_GlyphP_h_
#define _xvlang_GlyphP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvlang/Glyph.h>
#include <xvlang/NodeP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct _XvwGlyphWidgetClassPart
{
   XtPointer  extension;

} XvwGlyphWidgetClassPart;

typedef struct _XvwGlyphWidgetClassRec
{
   CoreClassPart		core_class;
   CompositeClassPart		composite_class;
   ConstraintClassPart		constraint_class;
   XvwManagerWidgetClassPart	manager_class;
   XvwNodeWidgetClassPart	node_class;
   XvwGlyphWidgetClassPart	glyph_class;
} XvwGlyphWidgetClassRec;

extern  XvwGlyphWidgetClassRec xvwGlyphWidgetClassRec;

typedef struct
{
   kform    *form;
   String   tbname;
   String   oname;
   String   panefile;
   Boolean  echo;
   Boolean  reporting;
   Boolean  show_status;
   xvobject connection_parent;  /* the parent to create the connection on     */
   kaddr    expression_id;      /* the parent to create the connection on     */

   xvobject destroy;
   xvobject menuform;
   xvobject execute;
   xvobject remote;
   xvobject error;
   xvobject help;
   xvobject status;		/* the input/output xvform selection name     */
   xvobject cflow_in;		/* the input control flow object 	      */
   xvobject cflow_out;		/* the output control flow object 	      */

   Pixmap   on_pixmap;
   Pixmap   off_pixmap;
   Pixmap   error_pixmap;
   Pixmap   info_pixmap;
   Pixmap   destroy_pixmap;
   Pixmap   openpane_pixmap;
   Pixmap   closepane_pixmap;
   Pixmap   distribute_pixmap;
   Pixmap   dav_pixmap;
   Pixmap   control_pixmap;

   int		pid;
   int		rsize;
   kform_struct	**rsels;
   int		exectype;

   int          isize;
   xvobject     *iports;
   kform_struct **isels;

   int          osize;
   xvobject     *oports;
   kform_struct **osels;
   xvobject	export_button;
   xvobject	options_button;
   Boolean	options_initialized;
   int		inum, onum;
   xvobject	*iconnections, *oconnections;

   Boolean	created_form; /* whether we created the form or not     */
   kform	*wkspgui;     /* workspace GUI to export to if not NULL */

} XvwGlyphPart;


typedef struct _XvwGlyphWidgetRec
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  XvwManagerPart	manager;
  XvwNodePart		node;
  XvwGlyphPart		glyph;

} XvwGlyphWidgetRec;

typedef struct {int empty;} XvwGlyphConstraintsPart;

typedef struct _XvwGlyphWidgetConstraintsRec {
    XvwManagerConstraintsPart	manager;
    XvwNodeConstraintsPart	node;
    XvwGlyphConstraintsPart	glyph;
} XvwGlyphWidgetConstraintsRec, *XvwGlyphWidgetConstraints;

typedef struct  _XvwGlyphWidgetClassRec  *XvwGlyphWidgetClass;
typedef struct  _XvwGlyphWidgetRec       *XvwGlyphWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwGlyphWidget
 */
extern XvwGlyphWidgetClassRec xvwGlyphWidgetClassRec;


#endif /* _xvlang_GlyphP_h_ */
/* Do not add after this line */
