 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       Threshold widget.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Nov 16, 1992 16:20
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Threshold_h_
#define _xvisual_Threshold_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attribute definitions for Threshold Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_THRESHOLD_SHOW_PALETTE
| Description:  This attribute causes the palette of linear colormap values
|               to be displayed above the lower/upper/range scrollbars.  
|               Set to FALSE if the palette is not to be shown.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     thresholdShowPalette
------------------------------------------------------------------------*/
#define XVW_THRESHOLD_SHOW_PALETTE  "thresholdShowPalette"

/*------------------------------------------------------------------------
| Attribute:    XVW_THRESHOLD_PALETTE_OBJECT
| Description:  This is the palette component of the threshold object.
|               The palette component is where the actual pixels are
|               displayed and reflect the thresholding process.
| Type:         xvobject
| Default:      NULL
| Legal Values: valid xvobject
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_THRESHOLD_PALETTE_OBJECT "thresholdPaletteObject"

/*------------------------------------------------------------------------
| Attribute:    XVW_THRESHOLD_POLICY
| Description:  .include $DESIGN/manual/shared/xvisual/threshold/Threshold.sec
| Type:         int
| Default:      .symbol index KTHRESHOLD_POLICY_CLIP
| Legal Values: .symbol index KTHRESHOLD_POLICY_THRESH
|               .symbol index KTHRESHOLD_POLICY_CLIP
| Resource:     thresholdPolicy
------------------------------------------------------------------------*/
#define XVW_THRESHOLD_POLICY  	    "thresholdPolicy"


/*------------------------------------------------------------------------
| Attribute:    XVW_THRESHOLD_LOWERVAL
| Description:  The lower value of the thresholding (or clipping) region.
| Type:         int
| Default:      0
| Legal Values: 0 - 255
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_THRESHOLD_LOWERVAL      "thresholdLowerval"

/*
 * range integer object only exists for the user's ease in changing
 * the upper and lower values of the threshold region; its own integer
 * value is not actually used.
 */
#define XVW_THRESHOLD_RANGEVAL      "thresholdRangeval"

/*------------------------------------------------------------------------
| Attribute:    XVW_THRESHOLD_UPPERVAL
| Description:  The upper value of the thresholding (or clipping) region
| Type:         int 
| Default:      255 
| Legal Values: 0 - 255 
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_THRESHOLD_UPPERVAL      "thresholdUpperval"

/*------------------------------------------------------------------------
| Attribute:    XVW_THRESHOLD_CLIP_PIXELVAL
| Description:  .include $DESIGN/manual/shared/xvisual/threshold/ClipPixelVal.sec
| Type:         int
| Default:      0
| Legal Values: 0 - 255
| Resource:     thresholdClipPixelVal
------------------------------------------------------------------------*/

#define XVW_THRESHOLD_CLIP_PIXELVAL      "thresholdClipPixelVal"
/*------------------------------------------------------------------------
| Attribute:    XVW_THRESHOLD_CLIP_ACCEPT
| Description:  .include $DESIGN/manual/shared/xvisual/threshold/ClipAccept.sec
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     thresholdClipAccept
------------------------------------------------------------------------*/
#define XVW_THRESHOLD_CLIP_ACCEPT  "thresholdClipAccept"

/*------------------------------------------------------------------------
| Attribute:    XVW_THRESHOLD_THRESH_PIXELVAL
| Description:  .include $DESIGN/manual/shared/xvisual/threshold/ThresPixelVal.sec
| Type:         int
| Default:      255
| Legal Values: 1 - 255
| Resource:     thresholdThresPixelVal
------------------------------------------------------------------------*/
#define XVW_THRESHOLD_THRES_PIXELVAL      "thresholdThresPixelVal"

/*------------------------------------------------------------------------
| Attribute:    XVW_THRESHOLD_THRES_INVERT
| Description:  .include $DESIGN/manual/shared/xvisual/threshold/ThresInvert.sec
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     thresholdThresInvert
------------------------------------------------------------------------*/
#define XVW_THRESHOLD_THRES_INVERT  "thresholdThresInvert"

/*------------------------------------------------------------------------
| Attribute:    XVW_THRESHOLD_CALLBACK
|
| Description:  If desired, a callback may be installed on the threshold
|               object that will be fired each time the user employs one of
|               the scrollbars to change the lower or upper bound of the
|               thresholding (or clipping) region.  An 
|               \fIxvw_threshold_struct\fP will be passed in as the call_data; 
|               cast this parameter accordingly before using, as in:
|               .begin code
|               xvw_threshold_struct *thresh_struct;
|               thresh_struct = (xvw_threshold_struct *) call_data;\fP
|               .end code
|               The \fIxvw_threshold_struct\fP is defined in
|               $ENVISION/include/xvisual/Threshold.h as follows:
|               .begin code
|               typedef struct
|               {
|                   xvobject intobj;
|                   int      type;
|                   int      value;
|               } xvw_threshold_struct;
|               .end code
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|               .begin code
|               void callback_function
|                   xvobject object,
|                   kaddr client_data,
|                   kaddr call_data)
|               .end code
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_THRESHOLD_CALLBACK	    "thresholdCallback"

/*
 *  Value definitions for Threshold Visual Object
 */
#define KTHRESHOLD_POLICY_CLIP	 1
#define KTHRESHOLD_POLICY_THRESH 2

/*
 *  Value definitions for Threshold Visual Object
 */
#define KTHRESHOLD_LOWER	0
#define KTHRESHOLD_UPPER	1
#define KTHRESHOLD_RANGE	2

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Threshold Object by.
 */
#define ThresholdWidgetClass	xvwThresholdWidgetClass
 
        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

/*
 *  Callback structure for the XVW_THRESHOLD_CALLBACK.  The calldata
 *  consists of:
 *  1)  the integer object that allows the user to change the threshold value, 
 *  2)  which value the integer object is changing: 
 *      the upper value, the lower value, or the range, 
 *  3)  the current value of the integer object.
 */
typedef struct
{
	xvobject intobj;
	int	 type;
	int      value;
} xvw_threshold_struct;

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

/*
 *  XToolkit Widget Declaration for ThresholdWidgetClass
 */
extern   WidgetClass     ThresholdWidgetClass;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definitions for Threshold Visual Object
 */
xvobject xvw_create_threshold  PROTO((xvobject, char *));


#endif /* _xvisual_Threshold_h_ */
/* Don't add after this point */
