 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       graphical plot2d object.
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 14:27
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Plot2D_h_
#define _xvisual_Plot2D_h_

    /*-------------------------------------*
    |       #defines 
    ---------------------------------------*/

/*
 *  Attribute definitions for Plot 2D Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT2D_PLOTOBJ
|
| Description:  The data object containing the 2D plot data to be displayed.
|               Note that this attribute is mutually exclusive with
|               .symbol index XVW_PLOT2D_PLOTFILE ;
|               use one or the other, not both.
|
| Type:         kobject
| Default:      NULL
| Legal Values: any valid data object
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT2D_PLOTOBJ		"plot2DPlotobj"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT2D_PLOTFILE
|
| Description:  The file containing the 2D plot data to be displayed.
|               Note that this attribute is mutually exclusive with
|               .symbol index XVW_PLOT2D_PLOTOBJ ;
|               use one or the other, not both.
|
| Type:         char *
| Default:      NULL
| Legal Values: any valid input file
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT2D_PLOTFILE		"plot2DPlotfile"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT2D_DATA_MAX_X
|
| Description:  This \fIread-only\fP attribute returns the maximum of the 
|               X coordinates in the 2D plot data currently in the Coord array 
|               specified with 
|               .symbol index XVW_PLOT2D_POINTS .
|
| Type:         double
| Default:      1.0 
| Legal Values: the maximum X world coordinate value (read only)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT2D_DATA_MAX_X		"plot2DDataMaxX"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT2D_DATA_MAX_Y
|
| Description:  This \fIread-only\fP attribute returns the maximum of the
|               Y coordinates in the 2D plot data currently in the Coord array
|               specified with
|               .symbol index XVW_PLOT2D_POINTS .
|
| Type:         double
| Default:      1.0
| Legal Values: the maximum Y world coordinate value (read only)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT2D_DATA_MAX_Y		"plot2DDataMaxY"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT2D_DATA_MIN_X
|
| Description:  This \fIread-only\fP attribute returns the minimum of the
|               X coordinates in the 2D plot data currently in the Coord array
|               specified with
|               .symbol index XVW_PLOT2D_POINTS .
|
| Type:         double
| Default:      0.0
| Legal Values: the minimum X world coordinate value (read only)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT2D_DATA_MIN_X		"plot2DDataMinX"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT2D_DATA_MIN_Y
|
| Description:  This \fIread-only\fP attribute returns the minimum of the
|               Y coordinates in the 2D plot data currently in the Coord array
|               specified with
|               .symbol index XVW_PLOT2D_POINTS .
|
| Type:         double
| Default:      0.0
| Legal Values: the minimum Y world coordinate value (read only)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT2D_DATA_MIN_Y		"plot2DDataMinY"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT2D_PLOTTYPE
| Description:  This attribute indicates how the plot is to be displayed. 
|               Choices include:
|               .symbol index KPLOT2D_LINEPLOT
|               .symbol index KPLOT2D_DISCRETE
|               .symbol index KPLOT2D_BARGRAPH
|               .symbol index KPLOT2D_POLYMARKER
|               .symbol index KPLOT2D_LINEMARKER
|               .symbol index KPLOT2D_COLORMARKER
| Type:         int
| Default:      .symbol index KPLOT2D_LINEPLOT
| Legal Values: .symbol index KPLOT2D_BARGRAPH
|               .symbol index KPLOT2D_COLORLINE
|               .symbol index KPLOT2D_COLORMARKER
|               .symbol index KPLOT2D_DISCRETE
|               .symbol index KPLOT2D_LINEPLOT
|               symbol index KPLOT2D_LINEMARKER
|               .symbol index KPLOT2D_POLYMARKER
| Resource:     plot2DPlotType
------------------------------------------------------------------------*/
#define XVW_PLOT2D_PLOTTYPE		"plot2DPlotType"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT2D_PLOTSIZE
|
| Description:  This is the number of data points contained in the Coord 
|               array specified by the attribute
|               .symbol noindex XVW_PLOT2D_POINTS .
|               Note that you \fImust\fP use this attribute to specify the 
|               number of points prior to specifying the data points with
|               .symbol noindex XVW_PLOT2D_POINTS .
|
| Type:         int
| Default:      0
| Legal Values: values > 0
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT2D_PLOTSIZE		"plot2DPlotsize"

/*------------------------------------------------------------------------
| Attribute:    XVW_PLOT2D_POINTS
|
| Description:  This is the array of coordinates defining the 2D data points 
|               in the plot. It is an array of type Coord, where the Coord 
|               structure is defined as:
|               .begin code
|               typedef  struct
|               {
|                   Real  x, y, z;
|                   Index d;
|               }  Coord;
|               .end code
|               Note that the
|               .symbol index XVW_PLOT2D_PLOTSIZE
|               attribute \fImust\fP be set to the number of points in the
|               Coord array \fIprior\fP to setting the
|               .symbol index XVW_PLOT2D_POINTS
|               attribute.
|               .br
|               The \fIz\fP value is ignored for all 2D plot types.  
|               .br
|               The \fId\fP value is used only in the plot types
|               .symbol index KPLOT2D_COLORLINE
|               and
|               .symbol index KPLOT2D_COLORMARKER .
|               It should be set to a valid color index (on a 8-bit display 
|               the range is 0-255 all values outside that range are defaulted 
|               to the default foreground color).
|
| Type:         Coord *
| Default:      NULL
| Legal Values: array of Coords defining data points for 2D plot
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PLOT2D_POINTS		"plot2DPoints"

/*
 *  Value definitions for Plot 2D Visual Object
 */

/* 2D Plot types used by graphics library */
#define KPLOT2D_LINEPLOT           1
#define KPLOT2D_DISCRETE           2
#define KPLOT2D_BARGRAPH           3
#define KPLOT2D_POLYMARKER         4
#define KPLOT2D_LINEMARKER         5
#define KPLOT2D_COLORMARKER        6
#define KPLOT2D_COLORLINE          7

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Plot2D Object by.
 */
#define Plot2DGadgetClass	xvwPlot2DGadgetClass

    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration for Plot2DGadgetClass
 */
extern   WidgetClass     Plot2DGadgetClass;


    /*-------------------------------------*
    |       routine definitions
    ---------------------------------------*/

/*
 *  Function Definitions Plot 2D Visual Object
 */
xvobject xvw_create_plot2d  PROTO((xvobject, char *));


#endif /* _xvisual_Plot2D_h_ */
/* Don't add after this point */
