 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines for axis class attributes
   >>>>                that offer control over axis labels
   >>>>
   >>>>    Written By: John Salas, Danielle Argiro, Mark Young
   >>>>
   >>>>          Date: Aug 20, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_AxisLabel_h_
#define _xvisual_AxisLabel_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_LABELING_MODE
|
| Description:  This attribute controls which of: 
|		.br
|		(1) the label interval, 
|		.br
|		(2) the number of steps, or
|		.br
|		(3) the minimum & maximum values
|		.br
|		dictate how the numbers are labeled on the axis.  
|		.br
|		There are five labeling modes available:
|               .sp
|               .symbol index KAXIS_SET_LABELED_INTERVAL - 
|               The specified label interval is used to control labelling;
|		the number of steps is calculated from the interval.  
|		The maximum and minimum may be changed to fit the interval.
|               .sp
|               .symbol index KAXIS_SET_NUMBER_STEPS - 
|               The specified number of steps is used to control labelling;
|		the label interval is calculated from the number of steps.  
|		The maximum and minimum may be changed to fit the step number.
|               .sp
|               .symbol index KAXIS_SET_INTERVAL_STEPS - 
|               The specified label interval and number of steps are used.  
|               The maximum and minimum may be changed to fit the label 
|               interval and number of steps.
|               .sp
|               .symbol index KAXIS_SET_MAX_MIN - 
|               The specified maximum and minimum are used.  The label 
|               interval will be a multiple of 1, 2, 4 and 5 and the
|               number of steps adjusted accordingly.
|               .sp
|               .symbol index KAXIS_SET_DEFAULT_MODE - 
|               Similar to maximum and minimum, this is used as default mode for
|               the initialization purposes.  It differs in that the maximum 
|               and minimum will be adjusted so that they are even multiples 
|               of the label interval.
|
| Type:         int
| Default:      .symbol index KAXIS_SET_DEFAULT_MODE
| Legal Values: .symbol index KAXIS_SET_LABELED_INTERVAL
|               .symbol index KAXIS_SET_NUMBER_STEPS
|               .symbol index KAXIS_SET_INTERVAL_STEPS
|               .symbol index KAXIS_SET_MAX_MIN
|               .symbol index KAXIS_SET_DEFAULT_MODE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_LABELING_MODE		 "axisLabelingMode"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_LABELED_MIN
|
| Description:  This is the smallest value which is labeled on the axis;  it
|               may differ from the actual world coordinate minimum. 
|               For example, suppose that a 2D plot has X values which range
|               from 0.214 to 1.0;  it may be nicer to have the X axis labeled
|               from 0 to 1, in which case
|               .symbol index XVW_AXIS_LABELED_MIN
|               would be set to 0.0.
|
| Type:         double
| Default:      0.0
| Legal Values: any double world coordinate value
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_LABELED_MIN		 "axisLabeledMin"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_LABELED_MAX
|
| Description:  This is the largest value which is labeled on the axis;  it
|               may differ from the actual world coordinate maximum.
|               For example, suppose that a 2D plot has X values which range
|               from 0.0 to 0.789;  it may be nicer to have the X axis labeled 
|               from 0 to 1, in which case
|               .symbol index XVW_AXIS_LABELED_MAX
|               would be set to 1.0.
|
| Type:         double
| Default:      1.0
| Legal Values: any double world coordinate value
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_LABELED_MAX             "axisLabeledMax"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_LABELED_INTERVAL
|
| Description:  The labeling interval between each major tic mark.
|
| Type:         double
| Default:      0.2
| Legal Values: world coordinate values > 0.0
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_LABELED_INTERVAL	 "axisLabeledInterval"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_NICE_LABELS
|
| Description:  When set to TRUE, labels of the axis will follow these rules:
|		.br
|               1) Minimum will be a even multiple of the labeled interval.
|		.br
|               2) Maximum will be a even multiple of the labeled interval 
|               and will be equal to the minimum + number of steps * label 
|               interval.
|               .br
|               3) Each major tic label will be a even multiple of the 
|               labeled interval.
|		.sp
|               When FALSE, the labels of the axis will follow these rules:
|               .br
|               1) Minimum may or may not be a even multiple of the labeled 
|               interval.
|		.br
|               2) Maximum may or may not be a even multiple of the labeled 
|               interval and may not even be displayed.
|               .br
|               3) Each major tic label may or may not be a even multiple of 
|               the labeled interval.
|               .br
|               4) If the number of steps may or may not be an even multiple
|               of the range divided by the interval size.
|               .sp
|               Note: when this attribute is set from FALSE to TRUE and back
|               again, the labels will be re-adjusted and will not be
|               exactly the same each time.
|
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     axisNiceLabels
------------------------------------------------------------------------*/
#define XVW_AXIS_NICE_LABELS		 "axisNiceLabels"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_NUMBER_STEPS
|
| Description:  The number of steps to take starting at the minimum value.  
|               This parameter will control the number of major tics which 
|               is this value + 1.
|
| Type:         double
| Default:      5.0
| Legal Values: value > 0.0
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_NUMBER_STEPS		 "axisNumberSteps"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_NUMERICAL_LABELS_FORMAT
|
| Description:  This controls how the numerical labels are displayed.  The 
|               format is the same as for printf().  If a numerical value 
|               is 1.34 and the format value is %g, the label will be 
|               displayed as 1.34.  However, if the format is %f the label will
|               be display as 1.340000.  You can not specify string formats 
|               like %s and %c.
|
| Type:         char *
| Default:      "%g"
| Legal Values: standard printf() formatting strings
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_NUMERICAL_LABELS_FORMAT "axisNumericalLabelsFormat"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_RESTORE_LABELS
|
| Description:	Setting this \fIaction attribute\fP will cause the numeric
|		labels on the axes to be restored to the actual minimum
|		and maximum values of the world coordinates.  
|		Note that the labelled maximum and minimum could have been
|		changed to something other than the actual minimum and
|		maximum values with the use of the
|		.symbol index XVW_AXIS_LABELED_MIN
|		and/or
|               .symbol index XVW_AXIS_LABELED_MAX .
|		Thus, 
|		.symbol index XVW_AXIS_RESTORE_LABELS
|		is used to restore the original labelled values.
|
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_RESTORE_LABELS          "axisRestoreLabels"


#endif /* _xvisual_AxisLabel_h_ */
/* Don't add after this point */
