 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines for axis class attributes that give
   >>>>		       control over displayed axis elements
   >>>>
   >>>>    Written By: John Salas, Danielle Argiro, Mark Young
   >>>>
   >>>>          Date: Aug 20, 1994 
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_AxisElements_h_
#define _xvisual_AxisElements_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:     XVW_AXIS_SHOW_AXIS
|
| Description:   Dictates whether or not the axis itself is displayed.
|
| Type:          int
| Default:       TRUE
| Legal Values:  TRUE/FALSE
| Resource:      axisShowAxis
------------------------------------------------------------------------*/
#define XVW_AXIS_SHOW_AXIS		 "axisShowAxis"

/*------------------------------------------------------------------------
| Attribute:     XVW_AXIS_SHOW_AXIS_LABEL
|
| Description:   Dictates whether or not the axis label is displayed.
|
| Type:          int
| Default:       TRUE
| Legal Values:  TRUE/FALSE
| Resource:      axisShowAxisLabel
------------------------------------------------------------------------*/
#define XVW_AXIS_SHOW_AXIS_LABEL         "axisShowAxisLabel"

/*------------------------------------------------------------------------
| Attribute:     XVW_AXIS_SHOW_BOX
|
| Description:   Dictates whether or not the axis box will be displayed.
|
| Type:          int
| Default:       TRUE
| Legal Values:  TRUE/FALSE
| Resource:      axisShowBox
------------------------------------------------------------------------*/
#define XVW_AXIS_SHOW_BOX		 "axisShowBox"

/*------------------------------------------------------------------------
| Attribute:     XVW_AXIS_SHOW_MAJOR_GRID
|
| Description:   Dictates whether or not a grid will be drawn using the
|                major tics to specify location of grid lines.
|
| Type:          int
| Default:       FALSE
| Legal Values:  TRUE/FALSE
| Resource:	 axisShowMajorGrid
------------------------------------------------------------------------*/
#define XVW_AXIS_SHOW_MAJOR_GRID	 "axisShowMajorGrid"

/*------------------------------------------------------------------------
| Attribute:     XVW_AXIS_SHOW_MINOR_GRID
|
| Description:   Dictates whether or not a grid will be drawn using the
|                minor tics to specify location of grid lines.
|
| Type:          int
| Default:       FALSE
| Legal Values:  TRUE/FALSE
| Resource:      axisShowMinorGrid
------------------------------------------------------------------------*/
#define XVW_AXIS_SHOW_MINOR_GRID	 "axisShowMinorGrid"

/*------------------------------------------------------------------------
| Attribute:     XVW_AXIS_SHOW_NUMERICAL_LABELS
|
| Description:   Dictates whether or not the numerical labels are displayed,
|                marking the world coordinate values at the major tic marks.
|
| Type:          int
| Default:       TRUE
| Legal Values:  TRUE/FALSE
| Resource:      axisShowNumericalLabel
------------------------------------------------------------------------*/
#define XVW_AXIS_SHOW_NUMERICAL_LABELS	 "axisShowNumericalLabel"

/*------------------------------------------------------------------------
| Attribute:     XVW_AXIS_SHOW_TICS
|
| Description:   Dictates whether or not tic marks are displayed.
|
| Type:          int
| Default:       TRUE
| Legal Values:  TRUE/FALSE
| Resource:      axisShowTics
------------------------------------------------------------------------*/
#define XVW_AXIS_SHOW_TICS		 "axisShowTics"

/*------------------------------------------------------------------------
| Attribute:     XVW_AXIS_SHOW_ZERO_LINE
|
| Description:   Dictates whether or not a line should be drawn to
|                mark the location of zero on the axis.
|
| Type:          int
| Default:       TRUE
| Legal Values:  TRUE/FALSE
| Resource:      axisShowZeroLine
------------------------------------------------------------------------*/
#define XVW_AXIS_SHOW_ZERO_LINE          "axisShowZeroLine"

#endif /* _xvisual_AxisElements_h_ */
/* Don't add after this point */
