 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       graphical area manager.
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 11:16
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Area_h_
#define _xvisual_Area_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attributes for Area Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:     XVW_AREA_DISPLAY_TITLE
| Description:   This attribute controls whether or not a title is displayed 
|                at the top of the area object.  Set to TRUE to display title, 
|                FALSE to suppress title.
| Type:          int
| Default:       TRUE
| Legal Values:  TRUE/FALSE
| Resource:      areaDisplayTitle
------------------------------------------------------------------------*/
#define XVW_AREA_DISPLAY_TITLE	"areaDisplayTitle"

/*------------------------------------------------------------------------
| Attribute:     XVW_AREA_DISPLAY_DATE
| Description:   This attribute controls whether or not the date is displayed 
|                at the bottom of the area object.  Set to True to display 
|                date, False to suppress date.
| Type:          int
| Default:       FALSE
| Legal Values:  TRUE/FALSE
| Resource:      areaDisplayDate
------------------------------------------------------------------------*/
#define XVW_AREA_DISPLAY_DATE	"areaDisplayDate"

/*------------------------------------------------------------------------
| Attribute:    XVW_AREA_TITLE_STRING
|
| Description:  If
|               .symbol noindex XVW_AREA_DISPLAY_TITLE
|               is set to TRUE, this attribute determines the string 
|               that is used as the title of the area object.
|
| Type:         char *
| Default:      "Area Object"
| Legal Values: any valid string 
| Resource:     areaTitle.stringString
------------------------------------------------------------------------*/
#define XVW_AREA_TITLE_STRING "areaTitle.stringString"

/*------------------------------------------------------------------------
| Attribute:    XVW_AREA_TITLE
|
| Description:  If 
|		.symbol noindex XVW_AREA_DISPLAY_TITLE
|               is set to TRUE, this \fIread-only\fP attribute
|               attribute may be used to obtain the string visual 
|               object in which the title is displayed.
|
| Type:         xvobject 
| Default:      NULL 
| Legal Values: string xvobject (read only)
| Resource: 	N/A
------------------------------------------------------------------------*/
#define XVW_AREA_TITLE		"areaTitle"

/*------------------------------------------------------------------------
| Attribute:    XVW_AREA_DATE
|
| Description:  If 
|		.symbol noindex XVW_AREA_DISPLAY_DATE
|               is set to TRUE, this \fIread-only\fP attribute
|               attribute may be used to obtain the date visual 
|               object in which the date is displayed.
|
| Type:         xvobject 
| Default:      NULL 
| Legal Values: date xvobject (read only) 
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AREA_DATE		"areaDate"

/*------------------------------------------------------------------------
| Attribute:    XVW_AREA_ATTACH
|
| Description:  This attribute indicates the object from which another object 
|               will acquire its world coordinate view.  For example, suppose 
|               that an area object has an axis object and three 2D plot objects 
|		as its children.  The 
|		.symbol noindex XVW_AREA_ATTACH
|               attribute should be set on each of the axis and plot objects to
|		their area object parent. For example:
|		.begin code
|		xvw_set_attribute(axis,  XVW_AREA_ATTACH, area);
|		xvw_set_attribute(plot1, XVW_AREA_ATTACH, area);
|		xvw_set_attribute(plot2, XVW_AREA_ATTACH, area);
|		xvw_set_attribute(plot3, XVW_AREA_ATTACH, area);
|		This will cause the area object to 
|		propogate changes in the world coordinates, the viewport, and the 
|		perspective to the axis and plot objects, so that together they
|	 	maintain a consistent world coordinate view. 
|
| Type:         xvobject 
| Default:      NULL
| Legal Values: other xvobjects having the same area object as a parent 
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AREA_ATTACH		"areaAttach"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Area Object by.
 */
#define AreaWidgetClass	xvwAreaWidgetClass

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definition for Area Visual Object
 */
xvobject xvw_create_area PROTO((xvobject, char *));


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration AreaWidgetClass
 */
extern   WidgetClass	AreaWidgetClass;


#endif /* _xvisual_Area_h_ */
/* Don't add after this point */
