#include <xvinclude.h>

void button_callback PROTO((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char **argv,
   char **envp)
{
	xvobject manager, button, toplevel;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "example", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}


	manager = xvw_create_manager(NULL, "");
	toplevel = xvw_toplevel(manager);
	xvw_unmap(toplevel);
	xvw_set_attributes(manager, XVW_WIDTH, 512, XVW_HEIGHT, 512, NULL);

	manager = xvw_create_manager(NULL, "");
	button = xvw_create_button(manager, "button");
	xvw_set_attributes(button,
	    XVW_LABEL,		 "Press Me",
	    XVW_BORDER_WIDTH,    2,
            NULL);

	xvw_add_callback(button, XVW_BUTTON_SELECT, button_callback, toplevel);

	/*
	 * display & run program
	 */
	xvf_run_form();
}

/*
 * here's the callback for the button
 */
void button_callback(
    xvobject object,      /* the button */
    kaddr    client_data, /* not used   */
    kaddr    call_data)   /* not used   */
{
	xvobject toplevel = (xvobject) client_data;

	xvw_unmap(toplevel);
	xvw_map(toplevel);
}
