#include <xvinclude.h>


/*
 *   This program shows how both buttons and labels may display pixmaps rather
 *   than labels.  It also shows how XVW_ABOVE, XVW_BELOW, XVW_RIGHT_OF, and
 *   XVW_LEFT_OF can be used to lay out objects with respect to their parent.
 *
 *   The program creates two labels displaying pixmaps, one in the upper right
 *   hand corner of the parent, and one in the upper left hand corner of the
 *   parent.  It creates two buttons which display pixmaps,  one in the lower
 *   right hand corner of the parent, and one in the lower left hand corner of
 *   the parent.
 *
 *   Callbacks (not using client_data) are installed on the buttons, which
 *   will print out the path to the file defining the pixmap displayed on the
 *   button when the user clicks on the button.
 */

static void button_cb PROTO((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;
	xvobject button;
	xvobject label;

	char *label1_filename = 
		"$DESIGN/repos/bitmaps/live_pixmaps/cr.xbm";
	char *label2_filename = 
		"$DESIGN/repos/bitmaps/cursors/coffee";
	char *button1_filename = 
		"$DESIGN/repos/bitmaps/live_pixmaps/lightning.xbm";
	char *button2_filename = 
		"$DESIGN/repos/bitmaps/cursors/stopwatch";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager backplane; 300x300 (pixels) */
	manager = xvw_create_manager(NULL, "back");
	xvw_set_attributes(manager,
			   XVW_WIDTH, 300,
		           XVW_HEIGHT, 300,
		           NULL);

	/*
	 * create the 1st label.  Use XVW_LABEL_TYPE to specify that it will
         * contain a pixmap rather than a label;  use XVW_PIXMAP_FILENAME 
         * to specify the file where the pixmap is defined.  setting
         * XVW_BELOW and XVW_RIGHT_OF, both to NULL causes it to appear in
         * the upper left corner.
	 */
	label  = xvw_create_label(manager, "label1");
	xvw_set_attributes(label,
	     XVW_BORDER_WIDTH,    0,               
             XVW_LABEL_TYPE,      KLABEL_TYPE_PIXMAP,  
             XVW_PIXMAP_FILENAME, label1_filename,
	     XVW_BELOW,           NULL,
	     XVW_RIGHT_OF,        NULL,
	     NULL);

	/*
	 * create the 2nd label.  setting XVW_BELOW and XVW_LEFT_OF both 
         * to NULL causes it to appear in the upper right corner.
	 */
	label  = xvw_create_label(manager, "label2");
	xvw_set_attributes(label,
	     XVW_BORDER_WIDTH,    0,               
             XVW_LABEL_TYPE,      KLABEL_TYPE_PIXMAP,  
             XVW_PIXMAP_FILENAME, label2_filename,
	     XVW_BELOW,           NULL,
	     XVW_LEFT_OF,         NULL,
	     NULL);

	/*
	 * create the 1st button.  Use XVW_BUTTON_TYPE to specify that it will
         * contain a pixmap rather than a label;  use XVW_PIXMAP_FILENAME 
         * to specify the file where the pixmap is defined. use XVW_ABOVE and
         * XVW_RIGHT_OF to make it appear in the lower left corner.
	 */
	button = xvw_create_button(manager, "button");
	xvw_set_attributes(button,
	      XVW_BORDER_WIDTH,    1,              
              XVW_PIXMAP_FILENAME, button1_filename,
              XVW_BUTTON_TYPE,     KBUTTON_TYPE_PIXMAP,  
              XVW_ABOVE,           NULL,
              XVW_RIGHT_OF,        NULL,
	      NULL);

	/* add simple callback to the button */
	xvw_add_callback(button, XVW_BUTTON_SELECT, button_cb, NULL);

        /*
         * create the 2nd button.  use XVW_ABOVE and XVW_LEFT_OF to make it 
         * appear in the lower right corner.
         */
        button = xvw_create_button(manager, "button");
        xvw_set_attributes(button,
              XVW_BORDER_WIDTH,    1,
              XVW_PIXMAP_FILENAME, button2_filename,
              XVW_BUTTON_TYPE,     KBUTTON_TYPE_PIXMAP,
              XVW_ABOVE,           NULL,
              XVW_LEFT_OF,         NULL,
              NULL);
        xvw_add_callback(button, XVW_BUTTON_SELECT, button_cb, NULL);

	/* display & run the program.  */
	xvf_run_form();
}

static void button_cb(
    xvobject object,
    kaddr    client_data, /* not used */
    kaddr    call_data)   /* not used */
{
	char *filename;

	/*
	 *  just print out the path to the file where the pixmap
         *  being displayed is defined.
	 */
	xvw_get_attribute(object, XVW_PIXMAP_FILENAME, &filename);
	kfprintf(kstderr, "Pixmap definition located in:\n   %s\n", 
	         filename);

}

