#include "xvinclude.h"


/*
 *  This program creates a GUI with a button.  When the user clicks on the
 *  button, a pop-up text object appears;  the user can enter text as desired.
 *
 *  This example illustrates the use of xvu_text_wait(). The xvu_text_wait()
 *  routine is a utility in xvutils which pops up a text object of predefined
 *  size, allows the user to enter text as desired, and returns the contents
 *  of the text object to the caller when the user clicks on "Use".  If the
 *  user clicks on "Cancel", xvu_text_wait() returns NULL.  Note that
 *  xvu_text_wait will block the calling program until the user clicks on
 *  "Use" or "Cancel".
 *
 */
static void test_text_cb PROTO ((xvobject, kaddr, kaddr));
static void quit_cb      PROTO ((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	char     *textstring;
	xvobject manager;
	xvobject button;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create the manager backplane */
        manager = xvw_create_manager(NULL, "back");
	xvw_set_attributes(manager,
			   XVW_CHAR_WIDTH, 30.0,
			   XVW_CHAR_HEIGHT, 10.0,
			   NULL);

	/*
	 *  create a button in the middle of the manager parent
         *  that the user can click on to display pop-up
         *  text object created by xvu_text_wait().
	 */
	button = xvw_create_button(manager, "button");
	xvw_set_attributes(button, 
			   XVW_LABEL,   "enter text",
			   XVW_RIGHT_OF, NULL,
			   XVW_LEFT_OF,  NULL,
			   XVW_ABOVE,    NULL,
			   XVW_BELOW,    NULL,
		           NULL);

	/* it is the callback which will actually call xvu_text_wait().  */
	xvw_add_callback(button, XVW_BUTTON_SELECT, 
			 test_text_cb, NULL);
	
	/* create quit button in upper right hand corner.  */
	button = xvw_create_button(manager, "quit");
        xvw_set_attributes(button, 
                           XVW_LABEL,   "quit",
                           XVW_LEFT_OF,  NULL,
                           XVW_BELOW,    NULL,
                           NULL);
	xvw_add_callback(button, XVW_BUTTON_SELECT, 
			 quit_cb, NULL);

	/* display & run program */
	xvf_run_form();

}

static void test_text_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	char *defstring;
	char *label;
	char *prompt;
	char *textstring;
	int  width, height;

	/*
	 *  use xvu_text_wait() to pop up the text object. the string
         *  returned will be the current contents of the text object when
         *  the user clicks on "Use", or the default string if they hit
         *  "Cancel".
	 */
	width  = 60;
	height = 20;
	defstring = "here is some default text.\nmodify it as desired\n";
	label     = "Pop-up text object created by xvu_text_wait()";
	prompt    = "change text below, then hit 'Use':"; 
	textstring = xvu_text_wait(defstring, label, prompt, width, height);

	/*
	 *  print text returned.
	 */
	kfprintf(kstderr, "%s\n\n", textstring);
}

static void quit_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	kexit(KEXIT_SUCCESS);
}

