#include <xvinclude.h>

/*
 *  This routine displays a console and prints messages once a second, which
 *  automatically appear in the console instead of standard error.
 */
static void print_message PROTO((xvobject, kaddr, int *));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject console;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

        /* initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 *  create the console object
	 */
	console = xvw_create_console(NULL, "console");
	xvw_add_timeout(console, 0.2, print_message, NULL);

	/* display & run program */
	xvf_run_form();
}

/*
 *  simple print a message to standard error
 */
static void print_message(
    xvobject object,
    kaddr    client_data,
    int	     *stop_timer)
{
	static int count = 0;

	kfprintf(kstderr, "I'm the timer that is printing message %d cool!\n",
			count++);
}
