#include <xvinclude.h>

/*
 *  This example demonstrates the use of the notifywindow object.
 *  Notifywindows are nice when an application has to do something that
 *  will take a while, and the developer wants to inform the user about
 *  what's happening.  They don't require acknowledgement;  they just
 *  pop up to say something while the program is working, and go away
 *  when the program is done doing whatever it's doing.
 */

static void button_cb PROTO((xvobject, kaddr, kaddr));
static void quit_cb   PROTO((xvobject, kaddr, kaddr));

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;
        xvobject button;
        xvobject quit;
        xvobject notifywindow;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager object backplane for a button */
	manager = xvw_create_manager(NULL, "manager");
	xvw_set_attributes(manager,
			   XVW_WIDTH,  200,
			   XVW_HEIGHT, 200,
		           NULL);

	/*
	 *  create a yellow button in the middle of the manager;
         *  install a callback which will display the notifier.
	 */
	button = xvw_create_button(manager, "button");
	xvw_set_attributes(button,
			   XVW_LABEL,            "Press Me",
			   XVW_BACKGROUND_COLOR, "yellow",
			   XVW_LEFT_OF,           NULL,
			   XVW_RIGHT_OF,          NULL,
			   XVW_ABOVE,             NULL,
			   XVW_BELOW,             NULL,
			   NULL);

	/* create a quit button, just to be fancy.  */
	quit = xvw_create_button(manager, "quit");
        xvw_set_attributes(quit,
                           XVW_LABEL,            "quit",
                           XVW_LEFT_OF,           NULL,
                           XVW_BELOW,             NULL,
                           NULL);
	/*
	 *  Create the notify window object. Since the parent is NULL, a
	 *  toplevel window will be created and the notifywindow placed
	 *  inside.  Give the notify window a title and a message.
         *
         *  The XVW_NOTIFYWINDOW_VISIBLE attribute is used when an application
         *  will be repeatedly using a notify window;  you don't want to
         *  recreate it every time (since that's slow), so you just create it
         *  the first time, and then set the XVW_NOTIFYWINDOW_VISIBLE to
         *  FALSE after it's done, and back to TRUE again when putting
         *  up a new message.
	 */
	notifywindow = xvw_create_notifywindow(NULL, "notify");
	xvw_set_attributes(notifywindow,
		           XVW_NOTIFYWINDOW_VISIBLE, FALSE,
		           XVW_NOTIFYWINDOW_TITLE,   "Please Wait. . .",
		           NULL);

	/*
	 * add callback to button to display notifywindow.  pass
         * notifywindow as clientdata so we can use it inside the callback.
	 */
	xvw_add_callback(button, XVW_BUTTON_SELECT,
			 button_cb, notifywindow);

	/*
	 * add callback to button to quit.  pass notifywindow as clientdata 
         * so we can destroy it inside the callback.
	 */
	xvw_add_callback(quit, XVW_BUTTON_SELECT,
			 quit_cb, notifywindow);

	/* display and run the program.  */
	xvf_run_form();
}

/*
 *  callback to display notify window
 */
static void button_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	int      indx;
	static   int count = 0;
	xvobject notifywindow = (xvobject) client_data;

	static  char *messages[] = {
			  "just doing my job", 
			  "conductor: done generating 'form_info.h'",
			  "all in a day's work",
			  "isn't this fun",
			  "notifywindows are great"};

	indx = count % (knumber(messages));
	xvw_set_attributes(notifywindow,
		           XVW_NOTIFYWINDOW_MESSAGE, messages[indx],
		           XVW_NOTIFYWINDOW_VISIBLE, TRUE,
		           NULL);
	sleep(5);

	xvw_set_attribute(notifywindow, XVW_NOTIFYWINDOW_VISIBLE, FALSE);

	count++;
}

/*
 *  callback to quit
 */
static void quit_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
        xvobject notifywindow = (xvobject) client_data;
	xvw_destroy(notifywindow);
	kexit(KEXIT_SUCCESS);
}
