#include <design.h>
#include <xvinclude.h>

static void restore_cb PROTO((xvobject, kaddr, kaddr));
static void run_cb     PROTO((xvobject, kaddr, kaddr));
static void clear_cb   PROTO((xvobject, kaddr, kaddr));
static void quit_cb    PROTO((xvobject, kaddr, kaddr));

main(
 int argc,
 char *argv[])
{
	char     *filename = "workspaces:ColorArith1";
	xvobject parent, workspace, run, clear, quit, restore;


	if (argc > 1)
	   filename = argv[1];

	xvw_initialize(XVW_MENUS_XVFORMS);
	parent = xvw_create_manager(NULL, "Example Workspace Program");

	restore = xvw_create_inputfile(parent, "inputfile");
	xvw_set_attributes(restore,
		XVW_INPUTFILE_LABEL,   "Restore Workspace",
		XVW_INPUTFILE_FILENAME, filename,
                XVW_WIDTH,              450,
		XVW_BELOW,              NULL,
		XVW_RIGHT_OF,           NULL,
		NULL);

	run = xvw_create_button(parent, "Run");
	xvw_set_attributes(run,
		XVW_LABEL,       "Run",
		XVW_BELOW,       restore,
		XVW_RIGHT_OF,    NULL,
		XVW_CHAR_WIDTH,  6.0,
		XVW_CHAR_HEIGHT, 1.2,
		XVW_VERT_DIST,   8,
		NULL);

	clear = xvw_create_button(parent, "Clear");
	xvw_set_attributes(clear,
		XVW_LABEL,      "Clear",
		XVW_BELOW,       run,
		XVW_RIGHT_OF,    NULL,
		XVW_VERT_DIST,   5,
		XVW_CHAR_WIDTH,  6.0,
		XVW_CHAR_HEIGHT, 1.2,
		NULL);

	quit = xvw_create_button(parent, "Quit");
	xvw_set_attributes(quit,
		XVW_LABEL,       "Quit",
		XVW_BELOW,       clear,
		XVW_RIGHT_OF,    NULL,
		XVW_VERT_DIST,   5,
		XVW_CHAR_WIDTH,  6.0,
		XVW_CHAR_HEIGHT, 1.2,
		NULL);

	workspace = xvw_create_workspace(parent, "Workspace");
	xvw_set_attributes(workspace,
		XVW_WIDTH, 1024,
		XVW_HEIGHT, 700,
		XVW_BELOW,   restore,
		XVW_VERT_DIST, 5,
		XVW_RIGHT_OF, clear,
		NULL);

        xvw_add_callback(run,   XVW_BUTTON_SELECT, run_cb,   workspace);
        xvw_add_callback(clear, XVW_BUTTON_SELECT, clear_cb, workspace);
        xvw_add_callback(quit,  XVW_BUTTON_SELECT, quit_cb,  workspace);
        xvw_add_callback(restore,XVW_INPUTFILE_CALLBACK, restore_cb, workspace);
	xvf_run_form();
}

static void restore_cb(
    xvobject object,
    kaddr client_data,
    kaddr call_data)
{
	char *filename = NULL;
	xvobject workspace = (xvobject) client_data;


	xvw_get_attribute(object, XVW_INPUTFILE_FILENAME, &filename);
	if (filename != NULL)
	   xvw_set_attribute(workspace, XVW_WORKSPACE_RESTORE, filename);
}

static void run_cb(
    xvobject object,
    kaddr client_data,
    kaddr call_data)
{
	xvobject workspace = (xvobject) client_data;
	xvw_set_attribute(workspace, XVW_WORKSPACE_RUN, TRUE);
}

static void clear_cb(
    xvobject object,
    kaddr client_data,
    kaddr call_data)
{
	xvobject workspace = (xvobject) client_data;
	xvw_set_attribute(workspace, XVW_WORKSPACE_CLEAR, TRUE);
}

static void quit_cb(
    xvobject object,
    kaddr client_data,
    kaddr call_data)
{
	kexit(KEXIT_SUCCESS);
}
