#include <xvinclude.h>

/*
 */

void main(
   int  argc,
   char **argv,
   char **envp)
{
	int	 mask;
	xvobject manager, center, top, bottom, left, right, button;
	
        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");
	
        /* initialize xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	manager = xvw_create_manager(NULL, "back");
	xvw_set_attributes(manager,
		      XVW_DEF_HORIZ_DIST, 100,
		      XVW_DEF_VERT_DIST,  100,
		      XVW_WIDTH,  750,
		      XVW_HEIGHT, 750,
		      NULL);

	
	center = xvw_create_button(manager, "center");
	xvw_set_attributes(center,
	   	      XVW_LABEL,     "X",
	   	      XVW_XPOSITION, 750/2,
	   	      XVW_YPOSITION, 750/2,
	   	      NULL);

	left = xvw_create_button(manager, "left");
	xvw_set_attributes(left,
	   	      XVW_LABEL,     " ",
		      XVW_LEFT_OF,  center,
		      XVW_ABOVE,    center,
		      XVW_BELOW,    center,
	   	      NULL);
	right = xvw_create_button(manager, "right");
	xvw_set_attributes(right,
	   	      XVW_LABEL,     " ",
		      XVW_RIGHT_OF, center,
		      XVW_ABOVE,    center,
		      XVW_BELOW,    center,
	   	      NULL);
	top = xvw_create_button(manager, "top");
	xvw_set_attributes(top,
	   	      XVW_LABEL,     " ",
		      XVW_ABOVE,    center,
		      XVW_LEFT_OF,  center,
		      XVW_RIGHT_OF, center,
	   	      NULL);
	bottom = xvw_create_button(manager, "bottom");
	xvw_set_attributes(bottom,
	   	      XVW_LABEL,     " ",
		      XVW_BELOW,    center,
		      XVW_LEFT_OF,  center,
		      XVW_RIGHT_OF, center,
	   	      NULL);

	button = xvw_create_button(manager, "left-top");
	xvw_set_attributes(button,
	   	      XVW_LABEL,     " ",
		      XVW_LEFT_OF,  top,
		      XVW_RIGHT_OF, left,
		      XVW_ABOVE,    left,
		      XVW_BELOW,    top,
	   	      NULL);
	button = xvw_create_button(manager, "right-top");
	xvw_set_attributes(button,
	   	      XVW_LABEL,     " ",
		      XVW_LEFT_OF,  right,
		      XVW_RIGHT_OF, top,
		      XVW_ABOVE,    right,
		      XVW_BELOW,    top,
	   	      NULL);
	button = xvw_create_button(manager, "left-bottom");
	xvw_set_attributes(button,
	   	      XVW_LABEL,     " ",
		      XVW_LEFT_OF,  bottom,
		      XVW_RIGHT_OF, left,
		      XVW_ABOVE,    bottom,
		      XVW_BELOW,    left,
	   	      NULL);
	button = xvw_create_button(manager, "right-bottom");
	xvw_set_attributes(button,
	   	      XVW_LABEL,     " ",
		      XVW_LEFT_OF,  right,
		      XVW_RIGHT_OF, bottom,
		      XVW_ABOVE,    bottom,
		      XVW_BELOW,    right,
	   	      NULL);

	/*
	 * display & run program
	 */
	xvf_run_form();
}
