#include <dataserv.h>
#define TOTAL 80
main(int argc,char **argv)
{
   kobject r;
   kobject o;
   unsigned char *data;
   int i;
   int shift;
   int begin[5] = {0, 0, 0, 0, 0};
   int end[5] = {0, 4, 0, 0, 0};
   int size[5] = {16, 5, 1, 1, 1};
   int order[5] = {KWIDTH,KHEIGHT,KDEPTH,KTIME,KELEMENTS};

   if ((r = kdms_open("input.raw", KOBJ_READ | KOBJ_HEADERLESS)) == NULL)
   {
      kprintf("Coulnd't open the headerless data.\n");
      kexit(1);
   }
   if ((o = kdms_open("test.viff", KOBJ_WRITE)) == NULL)
   {
      kprintf("Coulnd't open the headerful data.\n");
      kexit(1);
   }

   if (argc <= 1) 
   {
      kprintf("No shift argument.\n");
      kexit(1);
   }
   shift = atoi(argv[1]);   
   
   kdms_set_attribute(r, NULL, KDMS_ARCHITECTURE, KMACH_LOCAL);
   kdms_set_attribute(r, KDMS_SEGMENT_VALUE, KDMS_DIMENSION, 5);
   kdms_set_attribute(r, KDMS_SEGMENT_VALUE, KDMS_INDEX_ORDER, order);
   kdms_set_attribute(r, KDMS_SEGMENT_VALUE, KDMS_SIZE, size);
   kdms_set_attribute(r, KDMS_SEGMENT_VALUE, KDMS_DATA_TYPE, KBIT);
   kdms_set_attribute(r, KDMS_SEGMENT_VALUE, KDMS_COUPLING, KUNCOUPLED);

   kdms_create_segment(o, KDMS_SEGMENT_VALUE);
   
   kdms_set_attributes(o, KDMS_SEGMENT_VALUE, KDMS_DIMENSION, 5,
		       KDMS_INDEX_ORDER, order,
		       KDMS_SIZE, size,
		       KDMS_DATA_TYPE, KBIT, NULL);
   
   begin[0] = 0;
   end[0] = 12;

   if ((data = kdms_get_data(r,KDMS_SEGMENT_VALUE,begin,end,NULL)) == NULL)
      kexit(1);

   begin[0] = shift;
   end[0] = 12 + shift;
   
   if (!kdms_put_data(o, KDMS_SEGMENT_VALUE, begin, end, data))
   {
      kprintf("Failed put data.\n");
      kexit(1);
   }

   kdms_close(r);
   kdms_close(o);
   kfree(data);

   if ((o = kdms_open("test.viff", KOBJ_READ)) == NULL)
   {
      kprintf("Coulnd't open the headerful data.\n");
      kexit(1);
   }
   begin[0] = 0;
   end[0] = 15;

   kdms_set_attribute(o, KDMS_SEGMENT_VALUE, KDMS_DATA_TYPE, KUBYTE);

   if ((data = kdms_get_data(o,KDMS_SEGMENT_VALUE,begin,end,NULL)) == NULL)
      kexit(1);

   for (i=0;i<TOTAL;i++)
   {
      if ((i % 16) == 0)
         kprintf("\n");
      kprintf("%.1x ",(unsigned int)data[i]);
   }
   kprintf("\n");
   
   kexit(0);
   return(0);
}
