#include <dataserv.h>
#define TOTAL 80
main(int argc,char **argv)
{
   kobject o;
   unsigned char *data;
   int i;
   int shift;
   int begin[5] = {0, 0, 0, 0, 0};
   int end[5] = {0, 4, 0, 0, 0};
   int size[5] = {16, 5, 1, 1, 1};
   int order[5] = {KWIDTH,KHEIGHT,KDEPTH,KTIME,KELEMENTS};

   if ((o = kdms_open("input.raw", KOBJ_READ | KOBJ_HEADERLESS)) == NULL)
   {
      kprintf("Coulnd't open the headerless data.\n");
      kexit(1);
   }

   if (argc <= 1) 
   {
      kprintf("No shift argument.\n");
      kexit(1);
   }
   shift = atoi(argv[1]);   
   begin[0] = shift;
   end[0] = 7 + shift;
   
   kdms_set_attribute(o, NULL, KDMS_ARCHITECTURE, KMACH_LOCAL);
   kdms_set_attribute(o, KDMS_SEGMENT_VALUE, KDMS_DIMENSION, 5);
   kdms_set_attribute(o, KDMS_SEGMENT_VALUE, KDMS_INDEX_ORDER, order);
   kdms_set_attribute(o, KDMS_SEGMENT_VALUE, KDMS_SIZE, size);
   kdms_set_attribute(o, KDMS_SEGMENT_VALUE, KDMS_DATA_TYPE, KBIT);

   /*
    * change coupling...so we can get it back as unsigned byte.
    */
   kdms_set_attribute(o, KDMS_SEGMENT_VALUE, KDMS_COUPLING, KUNCOUPLED);

   kdms_set_attribute(o, KDMS_SEGMENT_VALUE, KDMS_DATA_TYPE, KUBYTE);

   if ((data = kdms_get_data(o,KDMS_SEGMENT_VALUE,begin,end,NULL)) == NULL)
      kexit(1);
   
   for (i=0;i<TOTAL/2;i++)
   {
      if ((i % 8) == 0)
	 kprintf("\n");
      kprintf("%.1x ",(unsigned int)data[i]);
   }
   kprintf("\n");

   kdms_close(o);
   kfree(data);
   kexit(0);
   return(0);
}
